/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene.effect;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.scene.FluentScene;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.util.TextUtils;
import nl.colorize.util.animation.Interpolation;
import nl.colorize.util.animation.Timeline;

public final class Effects {
    private Effects() {
    }

    public static Scene scaleToFit(Sprite sprite) {
        return (context, deltaTime) -> {
            Canvas canvas = context.getCanvas();
            float scaleX = (float)canvas.getWidth() / (float)sprite.getCurrentWidth();
            float scaleY = (float)canvas.getHeight() / (float)sprite.getCurrentHeight();
            sprite.getTransform().setScale(Math.max(scaleX, scaleY) * 100.0f);
        };
    }

    public static Scene appearText(Text text, float duration) {
        Preconditions.checkArgument((duration > 0.0f ? 1 : 0) != 0, (Object)("Invalid duration: " + duration));
        String originalText = TextUtils.LINE_JOINER.join(text.getLines());
        Timeline timeline = new Timeline();
        timeline.addKeyFrame(0.0f, 0.0f);
        timeline.addKeyFrame(duration, (float)originalText.length());
        Updatable onFrame = deltaTime -> {
            timeline.movePlayhead(deltaTime);
            String visibleText = originalText.substring(0, (int)timeline.getValue());
            text.setText(visibleText);
        };
        return new FluentScene(onFrame).withCompletion(() -> ((Timeline)timeline).isCompleted());
    }

    public static Scene spin(Sprite graphic, float duration) {
        Preconditions.checkArgument((duration > 0.0f ? 1 : 0) != 0, (Object)("Invalid duration: " + duration));
        Timeline timeline = new Timeline(Interpolation.LINEAR, true);
        timeline.addKeyFrame(0.0f, 0.0f);
        timeline.addKeyFrame(duration, 360.0f);
        return (context, deltaTime) -> {
            timeline.movePlayhead(deltaTime);
            graphic.getTransform().setRotation(timeline.getValue());
        };
    }
}

