/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene.effect;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.animation.Timeline;

public class ParticleWipe
implements Scene {
    private Container container = new Container();
    private boolean reverse;
    private Image particleImage;
    private float duration;
    private ColorRGB fillColor;
    private List<Particle> particles;
    public static final ResourceFile DIAMOND = new ResourceFile("effects/particle-diamond.png");
    public static final ResourceFile CIRCLE = new ResourceFile("effects/particle-circle.png");
    private static final int PARTICLE_SIZE = 64;
    private static final int PADDING = 32;

    public ParticleWipe(Image particleImage, ColorRGB color, float duration, boolean reverse) {
        this.duration = duration;
        this.particleImage = particleImage;
        this.fillColor = color;
        this.reverse = reverse;
        this.particles = new ArrayList<Particle>();
    }

    @Override
    public void start(SceneContext context) {
        int columnIndex = 0;
        int endX = context.getCanvas().getWidth() + 32;
        int endY = context.getCanvas().getHeight() + 32;
        for (int x = -32; x <= endX; x += 64) {
            ++columnIndex;
            for (int y = -32; y <= endY; y += 64) {
                Particle particle = new Particle(x, y, (float)columnIndex * 0.04f, this.duration * 0.5f);
                particle.sprite = new Sprite(this.particleImage);
                this.particles.add(particle);
                this.container.addChild(particle.sprite);
            }
        }
        context.getStage().getRoot().addChild(this.container);
    }

    @Override
    public void update(SceneContext context, float deltaTime) {
        for (Particle particle : this.particles) {
            particle.timeline.movePlayhead(deltaTime);
            particle.sprite.getTransform().setMaskColor(this.fillColor);
            particle.sprite.getTransform().setPosition(particle.position);
            particle.sprite.getTransform().setScale(this.getParticleScale(particle));
            particle.sprite.getTransform().setVisible(particle.sprite.getTransform().getScaleX() > 1.0f);
        }
    }

    private float getParticleScale(Particle particle) {
        float delta = particle.timeline.getValue();
        if (this.reverse) {
            delta = 1.0f - delta;
        }
        return Math.max(delta * 200.0f, 1.0f);
    }

    @Override
    public boolean isCompleted() {
        return this.particles.stream().allMatch(particle -> particle.timeline.isCompleted());
    }

    @Override
    public void end(SceneContext context) {
        context.getStage().detach(this.container);
    }

    @Generated
    public Container getContainer() {
        return this.container;
    }

    private static class Particle {
        private Point2D position;
        private Timeline timeline;
        private Sprite sprite;

        public Particle(float x, float y, float delay, float duration) {
            this.position = new Point2D(x, y);
            this.timeline = new Timeline().addKeyFrame(0.0f, 0.0f).addKeyFrame(delay, 0.0f).addKeyFrame(delay + duration, 1.0f);
        }
    }
}

