/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene.effect;

import java.util.ArrayList;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.SegmentedLine;
import nl.colorize.multimedialib.renderer.FrameStats;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.stage.Align;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.FontFace;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.StageNode2D;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.util.TextUtils;

public class PerformanceMonitor
implements Scene {
    private Container container;
    private Text framerate;
    private Container frameDataContainer;
    private boolean detailed;
    private static final ColorRGB FRAME_COLOR = ColorRGB.parseHex("#e45d61");
    private static final ColorRGB UPDATE_COLOR = ColorRGB.parseHex("#DC9498");
    private static final ColorRGB RENDER_COLOR = ColorRGB.parseHex("#DCBEC0");
    private static final ColorRGB LINE_COLOR = ColorRGB.parseHex("#adadad");

    public PerformanceMonitor(boolean detailed) {
        this.detailed = detailed;
        this.container = new Container();
        this.container.addChild(new Primitive(new Rect(0.0f, 0.0f, 300.0f, 100.0f), ColorRGB.BLACK, 50.0f));
    }

    @Override
    public void start(SceneContext context) {
        context.getStage().getRoot().addChild(this.container);
        this.frameDataContainer = new Container();
        this.container.addChild(this.frameDataContainer);
        FontFace font = context.getMediaLoader().loadDefaultFont(12, ColorRGB.WHITE);
        this.framerate = new Text("", font.derive(30), Align.RIGHT);
        this.framerate.getTransform().setPosition(290.0f, 30.0f);
        this.container.addChild(this.framerate);
        for (int i = 0; i <= 5; ++i) {
            this.container.addChild(new Primitive(new Line(0.0f, i * 20, 300.0f, i * 20), LINE_COLOR));
            if (i <= 0) continue;
            Text label = new Text(i * 10 + "ms", font.derive(10).derive(LINE_COLOR));
            label.getTransform().setPosition(5.0f, (5 - i) * 20 + 12);
            this.container.addChild(label);
        }
        this.container.addChild(new Primitive(new Line(0.0f, 0.0f, 300.0f, 0.0f), ColorRGB.WHITE));
        this.container.addChild(new Primitive(new Line(0.0f, 100.0f, 300.0f, 100.0f), ColorRGB.WHITE));
        this.container.addChild(new Primitive(new Line(0.0f, 0.0f, 0.0f, 100.0f), LINE_COLOR));
        this.container.addChild(new Primitive(new Line(300.0f, 0.0f, 300.0f, 100.0f), LINE_COLOR));
    }

    @Override
    public void update(SceneContext context, float deltaTime) {
        FrameStats stats = context.getSceneManager().getFrameStats();
        if (this.isActive() && stats.getBufferSize() >= 10) {
            this.container.setPosition(20.0f, context.getCanvas().getHeight() - 120);
            this.framerate.setText(TextUtils.numberFormat((float)stats.getAverageFramerate(), (int)1));
            Iterable<Long> frameTimes = stats.getFrameTimes("$$frameTime");
            Iterable<Long> frameUpdateTimes = stats.getFrameTimes("$$frameUpdate");
            Iterable<Long> frameRenderTimes = stats.getFrameTimes("$$frameRender");
            this.frameDataContainer.clearChildren();
            if (this.detailed) {
                this.frameDataContainer.addChild(this.depictFrameStats(frameRenderTimes, RENDER_COLOR));
                this.frameDataContainer.addChild(this.depictFrameStats(frameUpdateTimes, UPDATE_COLOR));
            }
            this.frameDataContainer.addChild(this.depictFrameStats(frameTimes, FRAME_COLOR));
        }
    }

    private StageNode2D depictFrameStats(Iterable<Long> frameTimes, ColorRGB color) {
        float x = 0.0f;
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (long frameTime : frameTimes) {
            float y = Math.clamp(100.0f - (float)frameTime * 2.0f, 0.0f, 100.0f);
            points.add(new Point2D(x, y));
            x += 5.0f;
        }
        Primitive line = new Primitive(new SegmentedLine(points), color);
        line.setStroke(3.0f);
        return line;
    }

    public void setActive(boolean active) {
        this.container.getTransform().setVisible(active);
    }

    public boolean isActive() {
        return this.container.getTransform().isVisible();
    }
}

