/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

public record ColorRGB(int r, int g, int b) {
    public static final ColorRGB BLACK = new ColorRGB(0, 0, 0);
    public static final ColorRGB WHITE = new ColorRGB(255, 255, 255);
    public static final ColorRGB GRAY = new ColorRGB(127, 127, 127);
    public static final ColorRGB RED = new ColorRGB(255, 0, 0);
    public static final ColorRGB GREEN = new ColorRGB(0, 255, 0);
    public static final ColorRGB BLUE = new ColorRGB(0, 0, 255);
    public static final ColorRGB YELLOW = new ColorRGB(255, 255, 0);
    public static final ColorRGB ORANGE = new ColorRGB(255, 127, 0);
    public static final ColorRGB PURPLE = new ColorRGB(127, 64, 255);
    public static final ColorRGB PINK = new ColorRGB(255, 107, 228);

    public ColorRGB {
        Preconditions.checkArgument((r >= 0 && r <= 255 ? 1 : 0) != 0, (Object)("Invalid red: " + r));
        Preconditions.checkArgument((g >= 0 && g <= 255 ? 1 : 0) != 0, (Object)("Invalid green: " + g));
        Preconditions.checkArgument((b >= 0 && b <= 255 ? 1 : 0) != 0, (Object)("Invalid blue: " + b));
    }

    public ColorRGB(int rgba) {
        this(rgba >> 16 & 0xFF, rgba >> 8 & 0xFF, rgba & 0xFF);
    }

    public int getRGB() {
        int rgb = this.r;
        rgb = (rgb << 8) + this.g;
        rgb = (rgb << 8) + this.b;
        return rgb;
    }

    public String toHex() {
        String hex = "#" + this.toHex(this.r) + this.toHex(this.g) + this.toHex(this.b);
        return hex.toUpperCase();
    }

    private String toHex(int component) {
        String str = Integer.toHexString(component);
        return str.length() > 1 ? str : "0" + str;
    }

    public ColorRGB alter(int deltaR, int deltaG, int deltaB) {
        return new ColorRGB(Math.clamp((long)(this.r + deltaR), 0, 255), Math.clamp((long)(this.g + deltaG), 0, 255), Math.clamp((long)(this.b + deltaB), 0, 255));
    }

    public List<ColorRGB> interpolate(ColorRGB target, int steps) {
        Preconditions.checkArgument((!this.equals(target) ? 1 : 0) != 0, (Object)"Cannot interpolate between identical colors");
        Preconditions.checkArgument((steps >= 2 ? 1 : 0) != 0, (Object)"Need at least 2 colors for interpolation");
        int stepR = (target.r - this.r) / (steps - 1);
        int stepG = (target.g - this.g) / (steps - 1);
        int stepB = (target.b - this.b) / (steps - 1);
        ArrayList<ColorRGB> colors = new ArrayList<ColorRGB>();
        colors.add(this);
        for (int i = 1; i < steps - 1; ++i) {
            colors.add(new ColorRGB(this.r + i * stepR, this.g + i * stepG, this.b + i * stepB));
        }
        colors.add(target);
        return colors;
    }

    @Override
    public String toString() {
        return this.toHex();
    }

    public static ColorRGB parseHex(String hexColor) {
        Object hex = hexColor.startsWith("#") ? hexColor.substring(1) : hexColor;
        Preconditions.checkArgument((((String)hex).length() == 3 || ((String)hex).length() == 6 ? 1 : 0) != 0, (Object)("Invalid hexadecimal color string: " + hexColor));
        if (((String)hex).length() == 3) {
            hex = "" + ((String)hex).charAt(0) + ((String)hex).charAt(0) + ((String)hex).charAt(1) + ((String)hex).charAt(1) + ((String)hex).charAt(2) + ((String)hex).charAt(2);
        }
        return new ColorRGB(Integer.parseInt(((String)hex).substring(0, 2), 16), Integer.parseInt(((String)hex).substring(2, 4), 16), Integer.parseInt(((String)hex).substring(4, 6), 16));
    }
}

