/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import com.google.common.base.Preconditions;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import lombok.Generated;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.StageNode2D;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.multimedialib.stage.Transform;
import nl.colorize.util.SubscribableCollection;

public class Container
implements StageNode2D,
Iterable<StageNode2D> {
    private String name;
    private Container parent;
    private SubscribableCollection<StageNode2D> children;
    private Transform transform;
    private Transform globalTransform;

    public Container(String name) {
        this.name = name;
        this.children = SubscribableCollection.wrap(new CopyOnWriteArrayList());
        this.transform = new Transform();
        this.globalTransform = new Transform();
    }

    public Container() {
        this("Container");
    }

    public void addChild(StageNode2D child) {
        Preconditions.checkArgument((this != child ? 1 : 0) != 0, (Object)"Cannot attach container to itself");
        Preconditions.checkState((child.getParent() == null ? 1 : 0) != 0, (Object)"Node is already attached to container");
        StageNode2D stageNode2D = child;
        Objects.requireNonNull(stageNode2D);
        StageNode2D stageNode2D2 = stageNode2D;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Container.class, Primitive.class, Sprite.class, Text.class}, (Object)stageNode2D2, n)) {
            case 0: {
                Container container = (Container)stageNode2D2;
                container.setParent(this);
                break;
            }
            case 1: {
                Primitive primitive = (Primitive)stageNode2D2;
                primitive.setParent(this);
                break;
            }
            case 2: {
                Sprite sprite = (Sprite)stageNode2D2;
                sprite.setParent(this);
                break;
            }
            case 3: {
                Text text = (Text)stageNode2D2;
                text.setParent(this);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown graphics type: " + String.valueOf(child));
            }
        }
        this.children.add((Object)child);
    }

    public void addChild(StageNode2D child, Point2D relativePosition) {
        this.addChild(child);
        child.getTransform().setPosition(relativePosition);
    }

    public void addChild(StageNode2D child, float relativeX, float relativeY) {
        this.addChild(child);
        child.getTransform().setPosition(relativeX, relativeY);
    }

    public Container addChildContainer() {
        Container child = new Container();
        this.addChild(child);
        return child;
    }

    public void removeChild(StageNode2D child) {
        StageNode2D stageNode2D = child;
        Objects.requireNonNull(stageNode2D);
        StageNode2D stageNode2D2 = stageNode2D;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Container.class, Primitive.class, Sprite.class, Text.class}, (Object)stageNode2D2, n)) {
            case 0: {
                Container container = (Container)stageNode2D2;
                container.setParent(null);
                break;
            }
            case 1: {
                Primitive primitive = (Primitive)stageNode2D2;
                primitive.setParent(null);
                break;
            }
            case 2: {
                Sprite sprite = (Sprite)stageNode2D2;
                sprite.setParent(null);
                break;
            }
            case 3: {
                Text text = (Text)stageNode2D2;
                text.setParent(null);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown graphics type: " + String.valueOf(child));
            }
        }
        this.children.remove((Object)child);
    }

    public void clearChildren() {
        this.children.forEach(this::removeChild);
        this.children.clear();
    }

    public <T extends StageNode2D> void forEach(Class<T> type, Consumer<T> callback) {
        for (StageNode2D child : this.children) {
            if (child.getClass() != type) continue;
            callback.accept(child);
        }
    }

    @Override
    public Rect getStageBounds() {
        if (this.children.isEmpty()) {
            return new Rect(0.0f, 0.0f, 0.0f, 0.0f);
        }
        Rect bounds = ((StageNode2D)this.children.iterator().next()).getStageBounds();
        for (StageNode2D child : this.children) {
            bounds = bounds.combine(child.getStageBounds());
        }
        return bounds;
    }

    @Override
    public void animate(Timer sceneTime) {
    }

    @Override
    public Iterator<StageNode2D> iterator() {
        return this.children.iterator();
    }

    public String toString() {
        return String.format("%s [%d]", this.name, this.children.size());
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public Container getParent() {
        return this.parent;
    }

    @Override
    @Generated
    public Transform getTransform() {
        return this.transform;
    }

    @Override
    @Generated
    public Transform getGlobalTransform() {
        return this.globalTransform;
    }

    @Generated
    protected void setParent(Container parent) {
        this.parent = parent;
    }

    @Generated
    protected SubscribableCollection<StageNode2D> getChildren() {
        return this.children;
    }
}

