/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import com.google.common.base.Preconditions;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.stage.Light;
import nl.colorize.multimedialib.stage.Mesh;
import nl.colorize.multimedialib.stage.StageNode3D;
import nl.colorize.multimedialib.stage.Transform3D;
import nl.colorize.util.SubscribableCollection;

public class Group
implements StageNode3D,
Iterable<StageNode3D> {
    private String name;
    Group parent;
    private SubscribableCollection<StageNode3D> children;
    private Transform3D transform;
    private Transform3D globalTransform;

    public Group(String name) {
        this.name = name;
        this.children = SubscribableCollection.wrap(new CopyOnWriteArrayList());
        this.transform = new Transform3D();
        this.globalTransform = new Transform3D();
    }

    public Group() {
        this("Group");
    }

    public void addChild(StageNode3D child) {
        Preconditions.checkArgument((this != child ? 1 : 0) != 0, (Object)"Cannot attach group to itself");
        Preconditions.checkState((child.getParent() == null ? 1 : 0) != 0, (Object)"Node is already attached to group");
        StageNode3D stageNode3D = child;
        Objects.requireNonNull(stageNode3D);
        StageNode3D stageNode3D2 = stageNode3D;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Group.class, Mesh.class, Light.class}, (Object)stageNode3D2, n)) {
            case 0: {
                Group group = (Group)stageNode3D2;
                group.setParent(this);
                break;
            }
            case 1: {
                Mesh mesh = (Mesh)stageNode3D2;
                mesh.setParent(this);
                break;
            }
            case 2: {
                Light light = (Light)stageNode3D2;
                light.setParent(this);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown graphics type: " + String.valueOf(child));
            }
        }
        this.children.add((Object)child);
    }

    public Group addChildGroup() {
        Group child = new Group();
        this.addChild(child);
        return child;
    }

    public void removeChild(StageNode3D child) {
        StageNode3D stageNode3D = child;
        Objects.requireNonNull(stageNode3D);
        StageNode3D stageNode3D2 = stageNode3D;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Group.class, Mesh.class, Light.class}, (Object)stageNode3D2, n)) {
            case 0: {
                Group group = (Group)stageNode3D2;
                group.setParent(null);
                break;
            }
            case 1: {
                Mesh mesh = (Mesh)stageNode3D2;
                mesh.setParent(null);
                break;
            }
            case 2: {
                Light light = (Light)stageNode3D2;
                light.setParent(null);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown graphics type: " + String.valueOf(child));
            }
        }
        this.children.remove((Object)child);
    }

    public void clearChildren() {
        this.children.forEach(this::removeChild);
        this.children.clear();
    }

    @Override
    public void animate(Timer animationTimer) {
    }

    @Override
    public Iterator<StageNode3D> iterator() {
        return this.children.iterator();
    }

    public String toString() {
        return String.format("%s [%d]", this.name, this.children.size());
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public Group getParent() {
        return this.parent;
    }

    @Override
    @Generated
    public Transform3D getTransform() {
        return this.transform;
    }

    @Override
    @Generated
    public Transform3D getGlobalTransform() {
        return this.globalTransform;
    }

    @Generated
    protected void setParent(Group parent) {
        this.parent = parent;
    }

    @Generated
    protected SubscribableCollection<StageNode3D> getChildren() {
        return this.children;
    }
}

