/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import lombok.Generated;
import nl.colorize.multimedialib.math.Angle;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Transform;
import nl.colorize.util.stats.Aggregate;

public class ImageTransform
extends Transform {
    private Angle rotation = Angle.ORIGIN;
    private float scaleX = 100.0f;
    private float scaleY = 100.0f;
    private boolean flipHorizontal = false;
    private boolean flipVertical = false;
    private ColorRGB maskColor = null;

    public void setRotation(Angle rotation) {
        this.rotation = rotation;
    }

    public void setRotation(float degrees) {
        this.setRotation(new Angle(degrees));
    }

    public void addRotation(float degrees) {
        this.setRotation(this.rotation.move(degrees));
    }

    public void setScale(float scale) {
        this.setScaleX(scale);
        this.setScaleY(scale);
    }

    public void setScaleX(float scaleX) {
        this.scaleX = Math.abs(scaleX);
    }

    public float getScaleX() {
        return this.flipHorizontal ? -this.scaleX : this.scaleX;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = Math.abs(scaleY);
    }

    public float getScaleY() {
        return this.flipVertical ? -this.scaleY : this.scaleY;
    }

    @Override
    public void set(Transform other) {
        super.set(other);
        if (other instanceof ImageTransform) {
            ImageTransform otherIT = (ImageTransform)other;
            this.setRotation(otherIT.rotation);
            this.setScaleX(otherIT.scaleX);
            this.setScaleY(otherIT.scaleY);
            this.setFlipHorizontal(otherIT.flipHorizontal);
            this.setFlipVertical(otherIT.flipVertical);
            this.setMaskColor(otherIT.maskColor);
        }
    }

    @Override
    public ImageTransform combine(Transform other) {
        ImageTransform combined = new ImageTransform();
        combined.setVisible(this.isVisible() && other.isVisible());
        combined.setPosition(this.getPosition().add(other.getPosition()));
        combined.setAlpha(Aggregate.multiplyPercentage((float)this.getAlpha(), (float)other.getAlpha()));
        if (other instanceof ImageTransform) {
            ImageTransform otherIT = (ImageTransform)other;
            combined.setRotation(this.rotation.degrees() + otherIT.rotation.degrees());
            combined.setScaleX(Aggregate.multiplyPercentage((float)this.scaleX, (float)otherIT.scaleX));
            combined.setScaleY(Aggregate.multiplyPercentage((float)this.scaleY, (float)otherIT.scaleY));
            combined.setFlipHorizontal(this.flipHorizontal || otherIT.flipHorizontal);
            combined.setFlipVertical(this.flipVertical || otherIT.flipVertical);
            combined.setMaskColor(otherIT.maskColor != null ? otherIT.maskColor : this.maskColor);
        }
        return combined;
    }

    @Generated
    public Angle getRotation() {
        return this.rotation;
    }

    @Generated
    public boolean isFlipHorizontal() {
        return this.flipHorizontal;
    }

    @Generated
    public boolean isFlipVertical() {
        return this.flipVertical;
    }

    @Generated
    public ColorRGB getMaskColor() {
        return this.maskColor;
    }

    @Generated
    public void setFlipHorizontal(boolean flipHorizontal) {
        this.flipHorizontal = flipHorizontal;
    }

    @Generated
    public void setFlipVertical(boolean flipVertical) {
        this.flipVertical = flipVertical;
    }

    @Generated
    public void setMaskColor(ColorRGB maskColor) {
        this.maskColor = maskColor;
    }
}

