/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import lombok.Generated;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Shape;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.StageNode2D;
import nl.colorize.multimedialib.stage.Transform;

public class Primitive
implements StageNode2D {
    private Container parent;
    private final Transform transform = new Transform();
    private final Transform globalTransform = new Transform();
    private Shape shape;
    private ColorRGB color;
    private float stroke;

    public Primitive(Shape shape, ColorRGB color) {
        this.shape = shape;
        this.color = color;
        this.stroke = 1.0f;
    }

    public Primitive(Shape shape, ColorRGB color, float alpha) {
        this(shape, color);
        this.getTransform().setAlpha(alpha);
    }

    @Override
    public Rect getStageBounds() {
        return this.shape.reposition(this.globalTransform.getPosition()).getBoundingBox();
    }

    @Override
    public void animate(Timer sceneTime) {
    }

    public String toString() {
        if (this.shape instanceof Rect || this.shape instanceof Circle) {
            return this.shape.getClass().getSimpleName() + " [" + String.valueOf(this.shape) + "]";
        }
        return this.shape.getClass().getSimpleName();
    }

    public static Primitive fromRect(float width, float height, ColorRGB color) {
        return Primitive.fromRect(width, height, color, 100.0f);
    }

    public static Primitive fromRect(float width, float height, ColorRGB color, float alpha) {
        return new Primitive(Rect.aroundOrigin(width, height), color, alpha);
    }

    public static Primitive fromCircle(float radius, ColorRGB color) {
        return Primitive.fromCircle(radius, color, 100.0f);
    }

    public static Primitive fromCircle(float radius, ColorRGB color, float alpha) {
        return new Primitive(new Circle(radius), color, alpha);
    }

    @Override
    @Generated
    public Container getParent() {
        return this.parent;
    }

    @Override
    @Generated
    public Transform getTransform() {
        return this.transform;
    }

    @Override
    @Generated
    public Transform getGlobalTransform() {
        return this.globalTransform;
    }

    @Generated
    public Shape getShape() {
        return this.shape;
    }

    @Generated
    public ColorRGB getColor() {
        return this.color;
    }

    @Generated
    public float getStroke() {
        return this.stroke;
    }

    @Generated
    public void setShape(Shape shape) {
        this.shape = shape;
    }

    @Generated
    public void setColor(ColorRGB color) {
        this.color = color;
    }

    @Generated
    public void setStroke(float stroke) {
        this.stroke = stroke;
    }

    @Generated
    protected void setParent(Container parent) {
        this.parent = parent;
    }
}

