/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.stage.Animation;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.ImageTransform;
import nl.colorize.multimedialib.stage.StageNode2D;

public class Sprite
implements StageNode2D {
    private Container parent;
    private ImageTransform transform = new ImageTransform();
    private ImageTransform globalTransform = new ImageTransform();
    private Map<String, SpriteState> stateGraphics = new HashMap<String, SpriteState>();
    private SpriteState currentState = new SpriteState("$$null", null);
    private float currentStateTime = 0.0f;
    private Image currentGraphics;
    private float lastTick = -1.0f;
    private static final String NULL_STATE = "$$null";
    private static final String DEFAULT_STATE = "$$default";

    public Sprite() {
    }

    public Sprite(Animation anim) {
        this();
        this.addGraphics(DEFAULT_STATE, anim);
    }

    public Sprite(Image image) {
        this();
        this.addGraphics(DEFAULT_STATE, image);
    }

    public void addGraphics(String stateName, Animation graphics) {
        Preconditions.checkNotNull((Object)stateName, (Object)"Missing state name");
        Preconditions.checkNotNull((Object)graphics, (Object)"Missing state graphics");
        Preconditions.checkArgument((!this.hasGraphics(stateName) ? 1 : 0) != 0, (Object)("State already exists: " + stateName));
        SpriteState state = new SpriteState(stateName, graphics);
        this.stateGraphics.put(stateName, state);
        if (this.stateGraphics.size() == 1) {
            this.changeGraphics(stateName);
        }
        this.updateCurrentGraphics();
    }

    public void addGraphics(String stateName, Image stateGraphics) {
        this.addGraphics(stateName, new Animation(stateGraphics));
    }

    public void changeGraphics(String stateName) {
        SpriteState state = this.stateGraphics.get(stateName);
        Preconditions.checkNotNull((Object)state, (Object)("No graphics defined for " + stateName));
        if (!this.currentState.equals(state)) {
            this.currentState = state;
            this.currentStateTime = 0.0f;
            this.updateCurrentGraphics();
        }
    }

    public void resetCurrentGraphics() {
        this.currentStateTime = 0.0f;
        this.updateCurrentGraphics();
    }

    public String getActiveState() {
        return this.currentState.name;
    }

    public Set<String> getPossibleStates() {
        return this.stateGraphics.keySet();
    }

    public boolean hasGraphics(String stateName) {
        return this.stateGraphics.containsKey(stateName);
    }

    public Animation getGraphics(String stateName) {
        SpriteState state = this.stateGraphics.get(stateName);
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (Object)("No graphics defined: " + stateName));
        return state.graphics;
    }

    @Deprecated
    public Animation getCurrentStateGraphics() {
        Preconditions.checkState((this.currentGraphics != null ? 1 : 0) != 0, (Object)"Sprite is without graphics");
        return this.currentState.graphics;
    }

    @Deprecated
    public Timer getCurrentStateTimer() {
        if (this.currentState.graphics.isLoop() || this.currentState.graphics.getFrameCount() == 1) {
            return Timer.at(this.currentStateTime);
        }
        return Timer.at(this.currentStateTime, this.currentState.graphics.getDuration());
    }

    public Image getCurrentGraphics() {
        Preconditions.checkState((this.currentGraphics != null ? 1 : 0) != 0, (Object)"Sprite is without graphics");
        return this.currentGraphics;
    }

    public int getCurrentWidth() {
        Preconditions.checkState((this.currentGraphics != null ? 1 : 0) != 0, (Object)"Sprite is without graphics");
        return this.currentGraphics.getWidth();
    }

    public int getCurrentHeight() {
        Preconditions.checkState((this.currentGraphics != null ? 1 : 0) != 0, (Object)"Sprite is without graphics");
        return this.currentGraphics.getHeight();
    }

    @Override
    public void animate(Timer sceneTime) {
        Preconditions.checkState((this.currentGraphics != null ? 1 : 0) != 0, (Object)"Sprite is without graphics");
        float tick = sceneTime.getTime();
        if (this.lastTick >= 0.0f) {
            float deltaTime = tick - this.lastTick;
            this.currentStateTime += deltaTime;
        }
        this.updateCurrentGraphics();
        this.lastTick = tick;
    }

    private void updateCurrentGraphics() {
        this.currentGraphics = this.currentState.graphics.getFrameAtTime(this.currentStateTime);
    }

    @Override
    public Rect getStageBounds() {
        Point2D position = this.globalTransform.getPosition();
        float width = Math.max((float)this.getCurrentWidth() * (this.globalTransform.getScaleX() / 100.0f), 1.0f);
        float height = Math.max((float)this.getCurrentHeight() * (this.globalTransform.getScaleY() / 100.0f), 1.0f);
        return new Rect(position.x() - width / 2.0f, position.y() - height / 2.0f, width, height);
    }

    public Sprite copy() {
        Sprite copy = new Sprite();
        for (SpriteState state : this.stateGraphics.values()) {
            copy.addGraphics(state.name, state.graphics);
        }
        copy.changeGraphics(this.currentState.name);
        copy.getTransform().set(this.getTransform());
        return copy;
    }

    public String toString() {
        return "Sprite [" + this.currentState.name + "]";
    }

    @Override
    @Generated
    public Container getParent() {
        return this.parent;
    }

    @Generated
    protected void setParent(Container parent) {
        this.parent = parent;
    }

    @Override
    @Generated
    public ImageTransform getTransform() {
        return this.transform;
    }

    @Override
    @Generated
    public ImageTransform getGlobalTransform() {
        return this.globalTransform;
    }

    private record SpriteState(String name, Animation graphics) {
    }
}

