/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import lombok.Generated;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.SegmentedLine;
import nl.colorize.multimedialib.math.Shape;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.Group;
import nl.colorize.multimedialib.stage.ImageTransform;
import nl.colorize.multimedialib.stage.Light;
import nl.colorize.multimedialib.stage.Mesh;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.StageNode2D;
import nl.colorize.multimedialib.stage.StageNode3D;
import nl.colorize.multimedialib.stage.StageSubscriber;
import nl.colorize.multimedialib.stage.StageVisitor;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.multimedialib.stage.Transform;
import nl.colorize.multimedialib.stage.Transform3D;
import nl.colorize.util.LogHelper;

public final class Stage {
    private final GraphicsMode graphicsMode;
    private final Canvas canvas;
    private final Timer animationTimer;
    private final Container root;
    private ColorRGB backgroundColor;
    private final Group root3D;
    private Point3D cameraPosition;
    private Point3D cameraFocus;
    private ColorRGB ambientLightColor;
    public static final ColorRGB DEFAULT_AMBIENT_LIGHT_COLOR = new ColorRGB(220, 220, 220);
    private static final String ROOT_CONTAINER_2D = "$$root";
    private static final String ROOT_CONTAINER_3D = "$$root3D";
    private static final float SAFE_ZONE = 128.0f;
    private static final Logger LOGGER = LogHelper.getLogger(Stage.class);

    public Stage(GraphicsMode graphicsMode, Canvas canvas) {
        this.graphicsMode = graphicsMode;
        this.canvas = canvas;
        this.animationTimer = Timer.infinite();
        this.root = new Container(ROOT_CONTAINER_2D);
        this.backgroundColor = ColorRGB.BLACK;
        this.root3D = new Group(ROOT_CONTAINER_3D);
        this.cameraPosition = new Point3D(0.0f, 20.0f, 10.0f);
        this.cameraFocus = Point3D.ORIGIN;
        this.ambientLightColor = DEFAULT_AMBIENT_LIGHT_COLOR;
    }

    public Container addContainer() {
        Container container = new Container();
        this.root.addChild(container);
        return container;
    }

    public Container addContainer(String name) {
        Container container = new Container(name);
        this.root.addChild(container);
        return container;
    }

    public Group addGroup(String name) {
        Group group = new Group(name);
        this.root3D.addChild(group);
        return group;
    }

    @Deprecated
    public void detach(StageNode2D node) {
        node.detach();
    }

    @Deprecated
    public void detach(StageNode3D node) {
        node.detach();
    }

    public void clear() {
        this.root.getChildren().clear();
        this.root3D.getChildren().clear();
    }

    public void visit(StageVisitor visitor) {
        visitor.prepareStage(this);
        visitor.drawBackground(this.backgroundColor);
        if (this.graphicsMode == GraphicsMode.MODE_3D) {
            this.visitNode3D(this.root3D, this.root3D.getTransform(), visitor);
            visitor.finalize3D(this);
        }
        this.visitNode2D(this.root, this.root.getTransform(), visitor);
        visitor.finalize2D(this);
    }

    private void visitNode2D(StageNode2D node, Transform globalTransform, StageVisitor visitor) {
        node.getGlobalTransform().set(globalTransform);
        if (!this.shouldDraw(node, globalTransform, visitor)) {
            return;
        }
        node.animate(this.animationTimer);
        StageNode2D stageNode2D = node;
        Objects.requireNonNull(stageNode2D);
        StageNode2D stageNode2D2 = stageNode2D;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Container.class, Sprite.class, Primitive.class, Text.class}, (Object)stageNode2D2, n)) {
            case 0: {
                Container container = (Container)stageNode2D2;
                this.visitContainer(container, globalTransform, visitor);
                break;
            }
            case 1: {
                Sprite sprite = (Sprite)stageNode2D2;
                visitor.drawSprite(sprite, (ImageTransform)globalTransform);
                break;
            }
            case 2: {
                Primitive primitive = (Primitive)stageNode2D2;
                this.visitPrimitive(primitive, globalTransform, visitor);
                break;
            }
            case 3: {
                Text text = (Text)stageNode2D2;
                visitor.drawText(text, globalTransform);
                break;
            }
            default: {
                LOGGER.warning("Unknown 2D graphics type: " + String.valueOf(node.getClass()));
            }
        }
    }

    private boolean shouldDraw(StageNode2D node, Transform globalTransform, StageVisitor visitor) {
        if (visitor.shouldVisitAllNodes() || node instanceof Container) {
            return true;
        }
        if (!node.getTransform().isVisible() || !globalTransform.isVisible()) {
            return false;
        }
        Rect safeCanvasBounds = new Rect(this.canvas.getBounds().x() - 128.0f, this.canvas.getBounds().y() - 128.0f, this.canvas.getBounds().width() + 256.0f, this.canvas.getBounds().height() + 256.0f);
        return node.getStageBounds().intersects(safeCanvasBounds);
    }

    private void visitContainer(Container container, Transform globalTransform, StageVisitor visitor) {
        visitor.visitContainer(container, globalTransform);
        for (StageNode2D child : container) {
            Transform childLocalTransform = child.getTransform();
            Transform childGlobalTransform = globalTransform.combine(childLocalTransform);
            this.visitNode2D(child, childGlobalTransform, visitor);
        }
    }

    private void visitPrimitive(Primitive graphic, Transform globalTransform, StageVisitor visitor) {
        Shape displayedShape;
        Shape shape = displayedShape = graphic.getShape().reposition(globalTransform.getPosition());
        Objects.requireNonNull(shape);
        Shape shape2 = shape;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Line.class, SegmentedLine.class, Rect.class, Circle.class, Polygon.class}, (Object)shape2, n)) {
            case 0: {
                Line line = (Line)shape2;
                visitor.drawLine(graphic, line, globalTransform);
                break;
            }
            case 1: {
                SegmentedLine sLine = (SegmentedLine)shape2;
                visitor.drawSegmentedLine(graphic, sLine, globalTransform);
                break;
            }
            case 2: {
                Rect rect = (Rect)shape2;
                visitor.drawRect(graphic, rect, globalTransform);
                break;
            }
            case 3: {
                Circle circle = (Circle)shape2;
                visitor.drawCircle(graphic, circle, globalTransform);
                break;
            }
            case 4: {
                Polygon polygon = (Polygon)shape2;
                visitor.drawPolygon(graphic, polygon, globalTransform);
                break;
            }
            default: {
                LOGGER.warning("Unknown primitive: " + String.valueOf(displayedShape.getClass()));
            }
        }
    }

    private void visitNode3D(StageNode3D node, Transform3D globalTransform, StageVisitor visitor) {
        node.getGlobalTransform().set(globalTransform);
        if (!globalTransform.isVisible() && !visitor.shouldVisitAllNodes()) {
            return;
        }
        node.animate(this.animationTimer);
        StageNode3D stageNode3D = node;
        Objects.requireNonNull(stageNode3D);
        StageNode3D stageNode3D2 = stageNode3D;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Group.class, Mesh.class, Light.class}, (Object)stageNode3D2, n)) {
            case 0: {
                Group group = (Group)stageNode3D2;
                this.visitGroup(group, globalTransform, visitor);
                break;
            }
            case 1: {
                Mesh mesh = (Mesh)stageNode3D2;
                visitor.drawMesh(mesh, globalTransform);
                break;
            }
            case 2: {
                Light light = (Light)stageNode3D2;
                visitor.drawLight(light, globalTransform);
                break;
            }
            default: {
                LOGGER.warning("Unknown 3D graphics type: " + String.valueOf(node.getClass()));
            }
        }
    }

    private void visitGroup(Group group, Transform3D globalTransform, StageVisitor visitor) {
        visitor.visitGroup(group, globalTransform);
        for (StageNode3D child : group) {
            Transform3D childLocalTransform = child.getTransform();
            Transform3D childGlobalTransform = globalTransform.combine(childLocalTransform);
            this.visitNode3D(child, childGlobalTransform, visitor);
        }
    }

    public void subscribe(StageSubscriber subscriber) {
        this.subscribe(this.root, subscriber);
        this.subscribe(this.root3D, subscriber);
    }

    private void subscribe(Container parent, StageSubscriber subscriber) {
        parent.getChildren().getAddedElements().subscribe(child -> {
            subscriber.onNodeAdded(parent, (StageNode2D)child);
            if (child instanceof Container) {
                Container childContainer = (Container)child;
                this.subscribe(childContainer, subscriber);
            }
        });
        parent.getChildren().getRemovedElements().subscribe(child -> subscriber.onNodeRemoved(parent, (StageNode2D)child));
    }

    private void subscribe(Group parent, StageSubscriber subscriber) {
        parent.getChildren().getAddedElements().subscribe(child -> {
            subscriber.onNodeAdded(parent, (StageNode3D)child);
            if (child instanceof Group) {
                Group childGroup = (Group)child;
                this.subscribe(childGroup, subscriber);
            }
        });
        parent.getChildren().getRemovedElements().subscribe(child -> subscriber.onNodeRemoved(parent, (StageNode3D)child));
    }

    public List<StageNode2D> findNodePath(StageNode2D node) {
        LinkedList<StageNode2D> nodePath = new LinkedList<StageNode2D>();
        for (StageNode2D currentNode = node; currentNode != null; currentNode = currentNode.getParent()) {
            nodePath.addFirst(currentNode);
        }
        return nodePath;
    }

    public List<StageNode3D> findNodePath(StageNode3D node) {
        LinkedList<StageNode3D> nodePath = new LinkedList<StageNode3D>();
        for (StageNode3D currentNode = node; currentNode != null; currentNode = currentNode.getParent()) {
            nodePath.addFirst(currentNode);
        }
        return nodePath;
    }

    public void recalculateGlobalTransform(StageNode2D node) {
        List<StageNode2D> nodePath = this.findNodePath(node);
        nodePath.getFirst().getGlobalTransform().set(nodePath.getFirst().getTransform());
        for (int i = 1; i < nodePath.size(); ++i) {
            Transform parentGlobalTransform = nodePath.get(i - 1).getGlobalTransform();
            Transform localTransform = nodePath.get(i).getTransform();
            Transform globalTransform = parentGlobalTransform.combine(localTransform);
            nodePath.get(i).getGlobalTransform().set(globalTransform);
        }
    }

    public void recalculateGlobalTransform(StageNode3D node) {
        List<StageNode3D> nodePath = this.findNodePath(node);
        nodePath.getFirst().getGlobalTransform().set(nodePath.getFirst().getTransform());
        for (int i = 1; i < nodePath.size(); ++i) {
            Transform3D parentGlobalTransform = nodePath.get(i - 1).getGlobalTransform();
            Transform3D localTransform = nodePath.get(i).getTransform();
            Transform3D globalTransform = parentGlobalTransform.combine(localTransform);
            nodePath.get(i).getGlobalTransform().set(globalTransform);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Stage\n");
        this.append(buffer, this.root, 1);
        if (this.graphicsMode == GraphicsMode.MODE_3D) {
            this.append(buffer, this.root3D, 1);
        }
        return buffer.toString();
    }

    private void append(StringBuilder buffer, StageNode2D node, int depth) {
        buffer.append("    ".repeat(depth));
        buffer.append(node.toString());
        buffer.append("\n");
        if (node instanceof Container) {
            Container container = (Container)node;
            for (StageNode2D child : container) {
                this.append(buffer, child, depth + 1);
            }
        }
    }

    private void append(StringBuilder buffer, StageNode3D node, int depth) {
        buffer.append("    ".repeat(depth));
        buffer.append(node.toString());
        buffer.append("\n");
        if (node instanceof Group) {
            Group group = (Group)node;
            for (StageNode3D child : group) {
                this.append(buffer, child, depth + 1);
            }
        }
    }

    @Generated
    public GraphicsMode getGraphicsMode() {
        return this.graphicsMode;
    }

    @Generated
    public Canvas getCanvas() {
        return this.canvas;
    }

    @Generated
    public Timer getAnimationTimer() {
        return this.animationTimer;
    }

    @Generated
    public Container getRoot() {
        return this.root;
    }

    @Generated
    public ColorRGB getBackgroundColor() {
        return this.backgroundColor;
    }

    @Generated
    public Group getRoot3D() {
        return this.root3D;
    }

    @Generated
    public Point3D getCameraPosition() {
        return this.cameraPosition;
    }

    @Generated
    public Point3D getCameraFocus() {
        return this.cameraFocus;
    }

    @Generated
    public ColorRGB getAmbientLightColor() {
        return this.ambientLightColor;
    }

    @Generated
    public void setBackgroundColor(ColorRGB backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Generated
    public void setCameraPosition(Point3D cameraPosition) {
        this.cameraPosition = cameraPosition;
    }

    @Generated
    public void setCameraFocus(Point3D cameraFocus) {
        this.cameraFocus = cameraFocus;
    }

    @Generated
    public void setAmbientLightColor(ColorRGB ambientLightColor) {
        this.ambientLightColor = ambientLightColor;
    }
}

