/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import lombok.Generated;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.stage.Align;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.FontFace;
import nl.colorize.multimedialib.stage.StageNode2D;
import nl.colorize.multimedialib.stage.Transform;

public class Text
implements StageNode2D {
    private Container parent;
    private final Transform transform = new Transform();
    private final Transform globalTransform = new Transform();
    private List<String> lines = Collections.emptyList();
    private FontFace font;
    private Align align;
    private int lineWidth;
    private float lineHeight;
    private static final Splitter LINE_BOUNDARY = Splitter.on((char)'\n');
    private static final Splitter WORD_BOUNDARY = Splitter.on((char)' ');
    private static final float ESTIMATED_CHAR_WIDTH_FACTOR = 0.6f;
    private static final float ESTIMATED_LINE_HEIGHT_FACTOR = 1.7f;

    public Text(String text, FontFace font, Align align, int lineWidth) {
        this.font = font;
        this.align = align;
        this.lineWidth = lineWidth;
        this.lineHeight = font == null ? 10.0f : (float)font.size() * 1.7f;
        this.setText(text);
    }

    public Text(String text, FontFace font, Align align) {
        this(text, font, align, 0);
    }

    public Text(String text, FontFace font) {
        this(text, font, Align.LEFT);
    }

    public void setText(String text) {
        this.setText(List.of(text));
    }

    public void setText(List<String> text) {
        this.lines = text.isEmpty() ? Collections.emptyList() : text.stream().flatMap(line -> LINE_BOUNDARY.splitToStream((CharSequence)line)).flatMap(line -> this.processLine((String)line)).toList();
    }

    private Stream<String> processLine(String line) {
        if (this.lineWidth <= 0 || line.isEmpty()) {
            return Stream.of(line);
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder currentLineBuffer = new StringBuilder();
        int estimatedCharactersPerLine = (int)Math.floor((float)this.lineWidth / this.estimateCharWidth());
        for (String word : WORD_BOUNDARY.split((CharSequence)line)) {
            if (!currentLineBuffer.isEmpty()) {
                if (currentLineBuffer.length() + word.length() + 1 > estimatedCharactersPerLine) {
                    result.add(currentLineBuffer.toString());
                    currentLineBuffer.setLength(0);
                } else {
                    currentLineBuffer.append(" ");
                }
            }
            currentLineBuffer.append(word);
        }
        if (!currentLineBuffer.isEmpty()) {
            result.add(currentLineBuffer.toString());
        }
        return result.stream();
    }

    public void forLines(BiConsumer<Integer, String> callback) {
        for (int i = 0; i < this.lines.size(); ++i) {
            callback.accept(i, this.lines.get(i));
        }
    }

    @Override
    public Rect getStageBounds() {
        Point2D position = this.globalTransform.getPosition();
        int longestLine = this.lines.stream().mapToInt(String::length).max().orElse(1);
        float approximateWidth = (float)longestLine * this.estimateCharWidth();
        float approximateHeight = this.font.size() * this.lines.size();
        return Rect.around(position, approximateWidth, approximateHeight);
    }

    private float estimateCharWidth() {
        return (float)this.font.size() * 0.6f;
    }

    @Override
    public void animate(Timer sceneTime) {
    }

    public String toString() {
        Object preview = "";
        if (!this.lines.isEmpty()) {
            preview = this.lines.getFirst();
        }
        if (((String)preview).length() > 20) {
            preview = ((String)preview).substring(0, 20) + "...";
        }
        return "Text [" + (String)preview + "]";
    }

    @Override
    @Generated
    public Container getParent() {
        return this.parent;
    }

    @Override
    @Generated
    public Transform getTransform() {
        return this.transform;
    }

    @Override
    @Generated
    public Transform getGlobalTransform() {
        return this.globalTransform;
    }

    @Generated
    public List<String> getLines() {
        return this.lines;
    }

    @Generated
    public FontFace getFont() {
        return this.font;
    }

    @Generated
    public Align getAlign() {
        return this.align;
    }

    @Generated
    public int getLineWidth() {
        return this.lineWidth;
    }

    @Generated
    public float getLineHeight() {
        return this.lineHeight;
    }

    @Generated
    public void setLines(List<String> lines) {
        this.lines = lines;
    }

    @Generated
    public void setFont(FontFace font) {
        this.font = font;
    }

    @Generated
    public void setAlign(Align align) {
        this.align = align;
    }

    @Generated
    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    @Generated
    public void setLineHeight(float lineHeight) {
        this.lineHeight = lineHeight;
    }

    @Generated
    protected void setParent(Container parent) {
        this.parent = parent;
    }
}

