/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import lombok.Generated;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.stage.ImageTransform;
import nl.colorize.util.stats.Aggregate;

public class Transform {
    private boolean visible = true;
    private Point2D position = new Point2D(0.0f, 0.0f);
    private float alpha = 100.0f;

    public void setPosition(Point2D position) {
        this.position = position;
    }

    public void setPosition(float x, float y) {
        this.setPosition(new Point2D(x, y));
    }

    public void setX(float x) {
        this.setPosition(new Point2D(x, this.position.y()));
    }

    public void setY(float y) {
        this.setPosition(new Point2D(this.position.x(), y));
    }

    public void addPosition(float deltaX, float deltaY) {
        this.setPosition(this.position.add(deltaX, deltaY));
    }

    public float getX() {
        return this.position.x();
    }

    public float getY() {
        return this.position.y();
    }

    public void setAlpha(float alpha) {
        this.alpha = Math.clamp(alpha, 0.0f, 100.0f);
    }

    public void set(Transform other) {
        this.setVisible(other.visible);
        this.setPosition(other.position.x(), other.position.y());
        this.setAlpha(other.alpha);
    }

    public Transform combine(Transform other) {
        if (other instanceof ImageTransform) {
            ImageTransform imageTransform = new ImageTransform();
            imageTransform.set(this);
            return imageTransform.combine(other);
        }
        Transform combined = new Transform();
        combined.setVisible(this.visible && other.visible);
        combined.setPosition(this.position.add(other.position));
        combined.setAlpha(Aggregate.multiplyPercentage((float)this.alpha, (float)other.alpha));
        return combined;
    }

    @Generated
    public boolean isVisible() {
        return this.visible;
    }

    @Generated
    public Point2D getPosition() {
        return this.position;
    }

    @Generated
    public float getAlpha() {
        return this.alpha;
    }

    @Generated
    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

