/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import lombok.Generated;
import nl.colorize.multimedialib.math.Angle;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.util.stats.Aggregate;

public class Transform3D {
    private boolean visible = true;
    private Point3D position = Point3D.ORIGIN;
    private Angle rotationX = Angle.ORIGIN;
    private Angle rotationY = Angle.ORIGIN;
    private Angle rotationZ = Angle.ORIGIN;
    private float scaleX = 100.0f;
    private float scaleY = 100.0f;
    private float scaleZ = 100.0f;

    public void set(Transform3D source) {
        this.visible = source.isVisible();
        this.position = source.getPosition();
        this.rotationX = source.getRotationX();
        this.rotationY = source.getRotationY();
        this.rotationZ = source.getRotationZ();
        this.scaleX = source.getScaleX();
        this.scaleY = source.getScaleY();
        this.scaleZ = source.getScaleZ();
    }

    public void setPosition(float x, float y, float z) {
        this.position = new Point3D(x, y, z);
    }

    public void addPosition(float deltaX, float deltaY, float deltaZ) {
        this.position = this.position.add(deltaX, deltaY, deltaZ);
    }

    public void setX(float x) {
        this.position = new Point3D(x, this.position.y(), this.position.z());
    }

    public void setY(float y) {
        this.position = new Point3D(this.position.x(), y, this.position.z());
    }

    public void setZ(float z) {
        this.position = new Point3D(this.position.x(), this.position.y(), z);
    }

    public void setRotation(float rotationX, float rotationY, float rotationZ) {
        this.rotationX = new Angle(rotationX);
        this.rotationY = new Angle(rotationY);
        this.rotationZ = new Angle(rotationZ);
    }

    public void addRotation(float degreesX, float degreesY, float degreesZ) {
        this.rotationX = this.rotationX.move(degreesX);
        this.rotationY = this.rotationY.move(degreesY);
        this.rotationZ = this.rotationZ.move(degreesZ);
    }

    public void setScale(float scaleX, float scaleY, float scaleZ) {
        this.setScaleX(scaleX);
        this.setScaleY(scaleY);
        this.setScaleZ(scaleZ);
    }

    public void setScale(float scale) {
        this.setScale(scale, scale, scale);
    }

    public Transform3D combine(Transform3D other) {
        Transform3D combined = new Transform3D();
        combined.setVisible(this.visible && other.visible);
        combined.setPosition(this.position.add(other.position));
        combined.setRotation(this.rotationX.degrees() + other.rotationX.degrees(), this.rotationY.degrees() + other.rotationY.degrees(), this.rotationZ.degrees() + other.rotationZ.degrees());
        combined.setScale(Aggregate.multiplyPercentage((float)this.scaleX, (float)other.scaleX), Aggregate.multiplyPercentage((float)this.scaleY, (float)other.scaleY), Aggregate.multiplyPercentage((float)this.scaleZ, (float)other.scaleZ));
        return combined;
    }

    @Generated
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Generated
    public void setPosition(Point3D position) {
        this.position = position;
    }

    @Generated
    public void setRotationX(Angle rotationX) {
        this.rotationX = rotationX;
    }

    @Generated
    public void setRotationY(Angle rotationY) {
        this.rotationY = rotationY;
    }

    @Generated
    public void setRotationZ(Angle rotationZ) {
        this.rotationZ = rotationZ;
    }

    @Generated
    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
    }

    @Generated
    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
    }

    @Generated
    public void setScaleZ(float scaleZ) {
        this.scaleZ = scaleZ;
    }

    @Generated
    public boolean isVisible() {
        return this.visible;
    }

    @Generated
    public Point3D getPosition() {
        return this.position;
    }

    @Generated
    public Angle getRotationX() {
        return this.rotationX;
    }

    @Generated
    public Angle getRotationY() {
        return this.rotationY;
    }

    @Generated
    public Angle getRotationZ() {
        return this.rotationZ;
    }

    @Generated
    public float getScaleX() {
        return this.scaleX;
    }

    @Generated
    public float getScaleY() {
        return this.scaleY;
    }

    @Generated
    public float getScaleZ() {
        return this.scaleZ;
    }
}

