/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.colorize.multimedialib.math.Box;
import nl.colorize.multimedialib.math.Coordinate;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.math.RandomGenerator;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.renderer.ErrorHandler;
import nl.colorize.multimedialib.renderer.KeyCode;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.Pointer;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.stage.Align;
import nl.colorize.multimedialib.stage.Animation;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.FontFace;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.Light;
import nl.colorize.multimedialib.stage.Mesh;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.SpriteAtlas;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.multimedialib.stage.Transform3D;
import nl.colorize.multimedialib.tool.Demo2D;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.animation.Interpolation;
import nl.colorize.util.animation.Timeline;
import nl.colorize.util.stats.Tuple;
import nl.colorize.util.stats.TupleList;

public class Demo3D
implements Scene,
ErrorHandler {
    private SceneContext context;
    private FontFace font;
    private Map<Coordinate, Mesh> tiles;
    private List<Tuple<Mesh, String>> walkingModels;
    private List<Mesh> spinningModels;
    private Point2D pointerPosition;
    private Container hudContainer;
    private static final ResourceFile CRATE_MODEL_FILE = new ResourceFile("demo/crate.vox.obj");
    private static final ResourceFile LOGO_FILE = new ResourceFile("colorize-logo.png");
    private static final ColorRGB BLACK_TILE_COLOR = new ColorRGB(50, 50, 50);
    private static final int GRID_SIZE = 5;
    private static final int NUM_MODELS = 50;
    private static final float WALK_SPEED = 0.02f;
    private static final float SPIN_SPEED = 30.0f;
    private static final List<String> DIRECTIONS = List.of("north", "east", "south", "west");

    @Override
    public void start(SceneContext context) {
        this.context = context;
        this.pointerPosition = Point2D.ORIGIN;
        MediaLoader mediaLoader = context.getMediaLoader();
        this.font = mediaLoader.loadDefaultFont(12, ColorRGB.WHITE);
        this.createHUD();
        this.createFloor();
        this.createWalkingModels();
        this.createSpinningModels();
        context.getStage().setCameraPosition(new Point3D(0.0f, 6.0f, 8.0f));
        context.getStage().setCameraFocus(Point3D.ORIGIN);
    }

    private void createFloor() {
        this.tiles = new HashMap<Coordinate, Mesh>();
        boolean white = false;
        Image logo = this.context.getMediaLoader().loadImage(LOGO_FILE);
        for (int i = -5; i <= 5; ++i) {
            for (int j = -5; j <= 5; ++j) {
                ColorRGB color = white ? ColorRGB.WHITE : BLACK_TILE_COLOR;
                Mesh tile = this.context.createMesh(Box.around(Point3D.ORIGIN, 1.0f, 0.001f, 1.0f), color);
                if (i == 0 && j == 0) {
                    tile.applyTexture(logo);
                }
                tile.getTransform().setPosition(i, 0.0f, j);
                this.context.getStage().getRoot3D().addChild(tile);
                this.tiles.put(new Coordinate(i, j), tile);
                white = !white;
            }
        }
    }

    private void createWalkingModels() {
        this.walkingModels = new TupleList();
        Sprite sprite = this.createMarioSprite();
        for (int i = 0; i < 50; ++i) {
            Mesh mesh = this.context.createMesh(Box.around(Point3D.ORIGIN, 0.96f, 1.28f, 0.001f), ColorRGB.WHITE);
            mesh.getTransform().setPosition(this.generateRandomModelPosition());
            mesh.applyDynamicTexture(sprite.copy());
            this.context.getStage().getRoot3D().addChild(mesh);
            String direction = RandomGenerator.pick(DIRECTIONS);
            mesh.getDynamicTexture().changeGraphics(direction);
            this.walkingModels.add((Tuple<Mesh, String>)Tuple.of((Object)mesh, (Object)direction));
        }
    }

    private Sprite createMarioSprite() {
        Image image = this.context.getMediaLoader().loadImage(Demo2D.MARIO_SPRITES_FILE);
        SpriteAtlas atlas = new SpriteAtlas();
        Sprite marioSprite = new Sprite();
        int y = 0;
        for (String direction : DIRECTIONS) {
            for (int i = 0; i <= 4; ++i) {
                atlas.add(direction + "_" + i, image, new Region(i * 48, y, 48, 64));
            }
            y += 64;
        }
        for (String direction : DIRECTIONS) {
            List<Image> frames = atlas.get(List.of(direction + "_0", direction + "_1", direction + "_2", direction + "_3", direction + "_4"));
            marioSprite.addGraphics(direction, new Animation(frames, 0.1f, true));
        }
        return marioSprite;
    }

    private Point3D generateRandomModelPosition() {
        float x = RandomGenerator.getFloat(-2.5f, 2.5f);
        float z = RandomGenerator.getFloat(-2.5f, 2.5f);
        return new Point3D(x, 0.64f, z);
    }

    private void createSpinningModels() {
        this.spinningModels = new ArrayList<Mesh>();
        Mesh crateTemplate = this.context.getMediaLoader().loadModel(CRATE_MODEL_FILE);
        List<Point3D> positions = List.of(new Point3D(-5.0f, 1.0f, -5.0f), new Point3D(5.0f, 1.0f, -5.0f), new Point3D(-5.0f, 1.0f, 5.0f), new Point3D(5.0f, 1.0f, 5.0f));
        for (Point3D position : positions) {
            Mesh model = crateTemplate.copy();
            model.getTransform().setPosition(position);
            model.getTransform().setScale(30.0f);
            this.context.getStage().getRoot3D().addChild(model);
            this.spinningModels.add(model);
            this.attachSpinningModelLabel(model);
        }
    }

    private void attachSpinningModelLabel(Mesh model) {
        Text label = new Text("", this.font, Align.CENTER);
        this.hudContainer.addChild(label);
        this.context.attach(() -> {
            Transform3D transform = model.getGlobalTransform();
            Point3D worldPosition = transform.getPosition();
            Point2D canvasPosition = this.context.project(worldPosition);
            String rotation = String.valueOf(transform.getRotationX()) + " " + String.valueOf(transform.getRotationY()) + " " + String.valueOf(transform.getRotationZ());
            label.setText("3D: " + String.valueOf(worldPosition) + "\n2D: " + String.valueOf(canvasPosition) + "\n" + rotation);
            label.getTransform().setPosition(canvasPosition.add(0.0f, -20.0f));
        });
    }

    private void createHUD() {
        Text hudText = new Text("", this.font);
        hudText.getTransform().setPosition(20.0f, 30.0f);
        hudText.setLineHeight(20.0f);
        this.context.attach(() -> this.updateHUD(hudText));
        this.hudContainer = new Container("hud");
        this.hudContainer.addChild(hudText);
        this.context.getStage().getRoot().addChild(this.hudContainer);
        this.createButton("Camera up", Demo2D.ORANGE_BUTTON, 0, () -> this.moveCamera(0, 1, 0));
        this.createButton("Camera down", Demo2D.ORANGE_BUTTON, 1, () -> this.moveCamera(0, -1, 0));
        this.createButton("Camera back", Demo2D.ORANGE_BUTTON, 2, () -> this.moveCamera(0, 0, 1));
        this.createButton("Camera foward", Demo2D.ORANGE_BUTTON, 3, () -> this.moveCamera(0, 0, -1));
        this.createButton("Camera left", Demo2D.ORANGE_BUTTON, 4, () -> this.moveCamera(-1, 0, 0));
        this.createButton("Camera right", Demo2D.ORANGE_BUTTON, 5, () -> this.moveCamera(1, 0, 0));
        this.createButton("Ambient up", Demo2D.BLUE_BUTTON, 6, () -> this.changeAmbientLight(1));
        this.createButton("Ambient down", Demo2D.BLUE_BUTTON, 7, () -> this.changeAmbientLight(-1));
        this.createButton("Add light", Demo2D.BLUE_BUTTON, 8, this::addLight);
    }

    private void updateHUD(Text hudText) {
        List<String> info = this.context.getDebugInformation();
        info.add("Pointer:  " + String.valueOf(this.pointerPosition));
        hudText.setText(info);
    }

    private void createButton(String label, ColorRGB color, int yStep, Runnable click) {
        Primitive bounds = new Primitive(new Rect(0.0f, 0.0f, 100.0f, 25.0f), color);
        bounds.getTransform().setPosition(-52.0f, 2.0f);
        Text text = new Text(label, this.font, Align.CENTER);
        text.getTransform().setY(19.0f);
        Container button = new Container();
        button.addChild(bounds);
        button.addChild(text);
        this.hudContainer.addChild(button);
        this.context.attach(deltaTime -> {
            int buttonX = this.context.getCanvas().getWidth() - 50;
            button.getTransform().setPosition(buttonX, (float)yStep * 30.0f);
        });
        this.context.attachClickHandler(bounds, click);
    }

    private void moveCamera(int stepX, int stepY, int stepZ) {
        Point3D oldCameraPosition = this.context.getStage().getCameraPosition();
        Point3D newCameraPosition = oldCameraPosition.add(stepX, stepY, stepZ);
        this.context.getStage().setCameraPosition(newCameraPosition);
    }

    private void changeAmbientLight(int step) {
        ColorRGB oldAmbient = this.context.getStage().getAmbientLightColor();
        ColorRGB newAmbient = oldAmbient.alter(step * 40, step * 40, step * 40);
        this.context.getStage().setAmbientLightColor(newAmbient);
    }

    private void addLight() {
        List<ColorRGB> colors = List.of(Demo2D.GREEN_BUTTON, Demo2D.ORANGE_BUTTON, Demo2D.PINK_BUTTON, Demo2D.BLUE_BUTTON);
        ColorRGB color = RandomGenerator.pick(colors);
        int x = RandomGenerator.getInt(-5, 5);
        int z = RandomGenerator.getInt(-5, 5);
        Light light = new Light(color, 50.0f);
        light.getTransform().setPosition(x, 5.0f, z);
        this.context.getStage().getRoot3D().addChild(light);
    }

    @Override
    public void update(SceneContext context, float deltaTime) {
        this.updatePointerControls();
        this.updateKeyboardControls();
        this.walkingModels = this.walkingModels.stream().map(this::updateWalkingModel).toList();
        this.spinningModels.get(0).getTransform().addRotation(deltaTime * 30.0f, 0.0f, 0.0f);
        this.spinningModels.get(1).getTransform().addRotation(0.0f, deltaTime * 30.0f, 0.0f);
        this.spinningModels.get(3).getTransform().addRotation(0.0f, 0.0f, deltaTime * 30.0f);
    }

    private void updatePointerControls() {
        for (Pointer pointer : this.context.getInput().getPointers()) {
            if (!pointer.isReleased()) continue;
            this.pointerPosition = pointer.getPosition();
            this.checkPointerIntersection();
        }
    }

    private void checkPointerIntersection() {
        for (int i = -5; i <= 5; ++i) {
            for (int j = -5; j <= 5; ++j) {
                Box tileBounds = Box.around(new Point3D(i, 0.0f, j), 1.0f, 0.001f, 1.0f);
                Mesh tileModel = this.tiles.get(new Coordinate(i, j));
                if (!this.context.castPickRay(this.pointerPosition, tileBounds)) continue;
                tileModel.applyColor(Demo2D.RED_BUTTON);
            }
        }
    }

    private void updateKeyboardControls() {
        if (this.context.getInput().isKeyReleased(KeyCode.N7)) {
            this.manuallySpin(90.0f, 0.0f, 0.0f);
        } else if (this.context.getInput().isKeyReleased(KeyCode.N8)) {
            this.manuallySpin(0.0f, 90.0f, 0.0f);
        }
        if (this.context.getInput().isKeyReleased(KeyCode.N9)) {
            this.manuallySpin(0.0f, 0.0f, 90.0f);
        }
    }

    private void manuallySpin(float deltaX, float deltaY, float deltaZ) {
        Transform3D transform = this.spinningModels.get(2).getTransform();
        float startX = transform.getRotationX().degrees();
        float startY = transform.getRotationY().degrees();
        float startZ = transform.getRotationZ().degrees();
        float endX = startX + deltaX;
        float endY = startY + deltaY;
        float endZ = startZ + deltaZ;
        Timeline timeline = new Timeline(Interpolation.EASE);
        timeline.addKeyFrame(0.0f, 0.0f);
        timeline.addKeyFrame(0.4f, 1.0f);
        this.context.attachTimeline(timeline, delta -> transform.setRotation(startX + delta.floatValue() * deltaX, startY + delta.floatValue() * deltaY, startZ + delta.floatValue() * deltaZ));
    }

    private Tuple<Mesh, String> updateWalkingModel(Tuple<Mesh, String> entry) {
        Mesh model = (Mesh)entry.left();
        String direction = (String)entry.right();
        Point2D walkVector = this.getWalkVector(direction);
        Rect areaBounds = new Rect(-5.0f, -5.0f, 10.0f, 10.0f);
        model.getTransform().addPosition(walkVector.x(), 0.0f, walkVector.y());
        Point3D position = model.getTransform().getPosition();
        if (!areaBounds.contains(position.x(), position.z())) {
            direction = DIRECTIONS.get((DIRECTIONS.indexOf(direction) + 2) % 4);
            model.getDynamicTexture().changeGraphics(direction);
        }
        return Tuple.of((Object)model, (Object)direction);
    }

    private Point2D getWalkVector(String direction) {
        return switch (direction) {
            case "north" -> new Point2D(0.0f, -0.02f);
            case "east" -> new Point2D(0.02f, 0.0f);
            case "south" -> new Point2D(0.0f, 0.02f);
            case "west" -> new Point2D(-0.02f, 0.0f);
            default -> throw new AssertionError();
        };
    }

    @Override
    public void onError(SceneContext context, Exception cause) {
        Text errorText = new Text("Error:\n\n" + cause.getMessage(), this.font, Align.CENTER);
        errorText.getTransform().setPosition(context.getCanvas().getCenter());
        context.getStage().getRoot().addChild(errorText);
    }
}

