/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import nl.colorize.multimedialib.math.Coordinate;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.KeyCode;
import nl.colorize.multimedialib.renderer.Pointer;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.FontFace;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.multimedialib.stage.Transform;

public class DemoIsometric
implements Scene {
    private Container world;
    private Container camera;
    private Map<Coordinate, Container> blocks;
    private Text hud;
    private static final int BLOCK_SIZE = 70;
    private static final ColorRGB RED_BLOCK = new ColorRGB(228, 93, 97);
    private static final ColorRGB LIGHT_BLOCK = new ColorRGB(235, 235, 235);
    private static final ColorRGB HIGHLIGHT = ColorRGB.parseHex("#adadad");
    private static final int DARK_LEFT = -30;
    private static final int DARK_RIGHT = -60;
    private static final float MOVE = 50.0f;
    private static final float ZOOM = 20.0f;
    private static final float SINE_WAVE_SPEED = 2.0f;
    private static final float SINE_WAVE_AMPLITUDE = 10.0f;

    @Override
    public void start(SceneContext context) {
        this.initWorld(context);
        this.initHUD(context);
    }

    private void initWorld(SceneContext context) {
        this.world = context.getStage().addContainer("world");
        this.camera = this.world.addChildContainer();
        this.blocks = new LinkedHashMap<Coordinate, Container>();
        for (int x = -5; x <= 5; ++x) {
            for (int y = -5; y <= 5; ++y) {
                Container block = this.createBlock(x, y);
                this.camera.addChild(block);
                this.blocks.put(new Coordinate(x, y), block);
            }
        }
    }

    private Container createBlock(int x, int y) {
        ColorRGB color = Math.abs(x) % 2 == Math.abs(y) % 2 ? RED_BLOCK : LIGHT_BLOCK;
        Polygon top = Polygon.fromPoints(0.0f, -17.5f, 35.0f, 0.0f, 0.0f, 17.5f, -35.0f, 0.0f);
        Polygon left = Polygon.fromPoints(-35.0f, 0.0f, 0.0f, 17.5f, 0.0f, 52.5f, -35.0f, 35.0f);
        Polygon right = Polygon.fromPoints(0.0f, 17.5f, 35.0f, 0.0f, 35.0f, 35.0f, 0.0f, 52.5f);
        Container block = new Container();
        block.addChild(new Primitive(top, color));
        block.addChild(new Primitive(left, color.alter(-30, -30, -30)));
        block.addChild(new Primitive(right, color.alter(-60, -60, -60)));
        block.getTransform().setX((float)x * 0.5f * 70.0f + (float)y * -0.5f * 70.0f);
        block.getTransform().setY((float)x * 0.25f * 70.0f + (float)y * 0.25f * 70.0f);
        return block;
    }

    private void initHUD(SceneContext context) {
        FontFace hudFont = context.getMediaLoader().loadDefaultFont(12, ColorRGB.WHITE);
        this.hud = new Text("", hudFont);
        this.hud.getTransform().setPosition(20.0f, 30.0f);
        this.hud.setLineHeight(20.0f);
        Container hudContainer = context.getStage().addContainer("hud");
        hudContainer.addChild(this.hud);
    }

    @Override
    public void update(SceneContext context, float deltaTime) {
        this.world.getTransform().setPosition(context.getCanvas().getCenter());
        this.hud.setText(context.getDebugInformation());
        this.updateCameraControls(context);
        this.updatePointerControls(context.getInput());
    }

    private void updateCameraControls(SceneContext context) {
        InputDevice input = context.getInput();
        Transform cameraTransform = this.camera.getTransform();
        if (input.isKeyReleased(KeyCode.LEFT)) {
            cameraTransform.addPosition(50.0f, 0.0f);
        } else if (input.isKeyReleased(KeyCode.RIGHT)) {
            cameraTransform.addPosition(-50.0f, 0.0f);
        } else if (input.isKeyReleased(KeyCode.UP)) {
            cameraTransform.addPosition(0.0f, 50.0f);
        } else if (input.isKeyReleased(KeyCode.DOWN)) {
            cameraTransform.addPosition(0.0f, -50.0f);
        } else if (input.isKeyReleased(KeyCode.SPACEBAR)) {
            this.startSineWave(context, cameraTransform);
        }
    }

    private void updatePointerControls(InputDevice input) {
        Point2D cameraWorldPosition = this.camera.getGlobalTransform().getPosition();
        for (Pointer pointer : input.getPointers()) {
            Point2D worldPosition = pointer.getPosition().add(cameraWorldPosition.negate());
            Coordinate highlighted = this.toBlockCoordinate(worldPosition);
            for (Map.Entry<Coordinate, Container> entry : this.blocks.entrySet()) {
                float alpha = entry.getKey().equals(highlighted) ? 50.0f : 100.0f;
                entry.getValue().getTransform().setAlpha(alpha);
            }
        }
    }

    private Coordinate toBlockCoordinate(Point2D position) {
        float a = 35.0f;
        float b = -35.0f;
        float c = 17.5f;
        float d = 17.5f;
        float det = 1.0f / (a * d - b * c);
        float[] inv = new float[]{det * d, det * -b, det * -c, det * a};
        return new Coordinate(Math.round(position.x() * inv[0] + position.y() * inv[1]), Math.round(position.x() * inv[2] + position.y() * inv[3]));
    }

    private void startSineWave(SceneContext context, Transform cameraTransform) {
        Timer waveTimer = Timer.infinite();
        HashMap<Container, Float> orginalBlockY = new HashMap<Container, Float>();
        for (Container block : this.blocks.values()) {
            orginalBlockY.put(block, Float.valueOf(block.getTransform().getY()));
        }
        context.attach(deltaTime -> {
            waveTimer.update(deltaTime * 2.0f);
            for (Map.Entry<Coordinate, Container> entry : this.blocks.entrySet()) {
                float offset = entry.getKey().x();
                float value = 10.0f * (float)Math.sin(waveTimer.getTime() - offset);
                Container block = entry.getValue();
                block.getTransform().setY(((Float)orginalBlockY.get(block)).floatValue() + value);
            }
        });
    }
}

