/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import com.google.common.base.Preconditions;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.colorize.util.FileUtils;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Platform;
import nl.colorize.util.cli.Arg;
import nl.colorize.util.cli.CommandLineArgumentParser;
import nl.colorize.util.cli.CommandLineInterfaceException;
import nl.colorize.util.swing.Utils2D;

public class IconTool {
    @Arg(name="input", usage="PNG file that acts as input for the icon")
    protected File inputFile;
    @Arg(name="output", usage="Directory where the ICNS file will be generated")
    protected File outputDir;
    private static final List<IconVariant> MAC_ICONS = List.of(new IconVariant("icon_16x16.png", 16, true), new IconVariant("icon_16x16@2x.png", 32, true), new IconVariant("icon_32x32.png", 32, true), new IconVariant("icon_32x32@2x.png", 64, true), new IconVariant("icon_128x128.png", 128, true), new IconVariant("icon_128x128@2x.png", 256, true), new IconVariant("icon_256x256.png", 256, true), new IconVariant("icon_256x256@2x.png", 512, true), new IconVariant("icon_512x512.png", 512, true), new IconVariant("icon_512x512@2x.png", 1024, true));
    private static final List<IconVariant> IOS_ICONS = List.of(new IconVariant("icon-120.png", 120, false), new IconVariant("icon-152.png", 152, false), new IconVariant("icon-167.png", 167, false), new IconVariant("icon-180.png", 180, false), new IconVariant("icon-1024.png", 1024, false));
    private static final List<IconVariant> PWA_ICONS = List.of(new IconVariant("icon-192.png", 192, true), new IconVariant("icon-512.png", 512, true));
    private static final IconVariant WINDOWS_ICON = new IconVariant("icon-48.png", 48, true);
    private static final IconVariant FAVICON = new IconVariant("favicon.png", 32, false);
    private static final IconVariant APPLE_FAVICON = new IconVariant("apple-favicon.png", 180, false);
    private static final Color SHADOW_COLOR = new Color(0, 0, 0, 80);
    private static final int SHADOW_OFFSET = 1;
    private static final int SHADOW_BLUR = 4;
    private static final Logger LOGGER = LogHelper.getLogger(IconTool.class);

    public static void main(String[] argv) {
        CommandLineArgumentParser argParser = new CommandLineArgumentParser("MacIconTool");
        IconTool tool = (IconTool)argParser.parse(argv, IconTool.class);
        tool.run();
    }

    protected void run() {
        try {
            BufferedImage original = Utils2D.loadImage((File)this.inputFile);
            if (original.getWidth() != original.getHeight()) {
                throw new CommandLineInterfaceException("Application icon must be square");
            }
            FileUtils.mkdir((File)this.outputDir);
            this.generateIcons(original);
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.SEVERE, "Failed to generate application icon", e);
        }
    }

    private void generateIcons(BufferedImage original) throws IOException, InterruptedException {
        this.generateMacIconSet(original);
        this.generateAppIconSet(original);
        for (IconVariant pwaIcon : PWA_ICONS) {
            this.generateIcon(original, pwaIcon);
        }
        this.generateIcon(original, WINDOWS_ICON);
        this.generateIcon(original, FAVICON);
        this.generateIcon(original, APPLE_FAVICON);
    }

    private void generateMacIconSet(BufferedImage original) throws IOException, InterruptedException {
        File iconSet = new File(this.outputDir, "icon.iconset");
        FileUtils.mkdir((File)iconSet);
        for (IconVariant variant : MAC_ICONS) {
            BufferedImage image = this.generateIconVariant(original, variant);
            Utils2D.savePNG((BufferedImage)image, (File)new File(iconSet, variant.name));
        }
        if (!Platform.isMac()) {
            LOGGER.warning("ICNS files can only be generated on Mac");
            return;
        }
        int exitCode = new ProcessBuilder("iconutil", "-c", "icns", "icon.iconset").directory(this.outputDir).redirectError(ProcessBuilder.Redirect.PIPE).start().waitFor();
        Preconditions.checkState((exitCode == 0 ? 1 : 0) != 0, (Object)("iconutil failed with exit code " + exitCode));
    }

    private void generateAppIconSet(BufferedImage original) throws IOException {
        File iconSet = new File(this.outputDir, "AppIcon.appiconset");
        FileUtils.mkdir((File)iconSet);
        for (IconVariant variant : IOS_ICONS) {
            BufferedImage image = this.generateIconVariant(original, variant);
            Utils2D.savePNG((BufferedImage)image, (File)new File(iconSet, variant.name));
        }
    }

    private BufferedImage generateIconVariant(BufferedImage original, IconVariant variant) {
        if (variant.maskable) {
            return this.generateMaskIcon(original, variant);
        }
        return this.generateRegularIcon(original, variant);
    }

    private BufferedImage generateRegularIcon(BufferedImage original, IconVariant variant) {
        return Utils2D.scaleImage((Image)original, (int)variant.size, (int)variant.size, (boolean)true);
    }

    private BufferedImage generateMaskIcon(BufferedImage original, IconVariant variant) {
        float factor = (float)variant.size / 512.0f;
        int inset = Math.round(50.0f * factor);
        int size = Math.round(412.0f * factor);
        int radius = Math.round(128.0f * factor);
        BufferedImage image = new BufferedImage(variant.size, variant.size, 2);
        Graphics2D g2 = Utils2D.createGraphics((BufferedImage)image, (boolean)true, (boolean)true);
        g2.setColor(Color.WHITE);
        g2.fillRoundRect(inset, inset, size, size, radius, radius);
        g2.setComposite(AlphaComposite.getInstance(5, 1.0f));
        g2.drawImage((Image)Utils2D.scaleImage((Image)original, (int)size, (int)size, (boolean)true), inset, inset, null);
        g2.dispose();
        return Utils2D.applyDropShadow((BufferedImage)image, (Color)SHADOW_COLOR, (int)1, (int)4);
    }

    private void generateIcon(BufferedImage original, IconVariant variant) throws IOException {
        BufferedImage image = this.generateIconVariant(original, variant);
        Utils2D.savePNG((BufferedImage)image, (File)new File(this.outputDir, variant.name));
    }

    private record IconVariant(String name, int size, boolean maskable) {
    }
}

