/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.colorize.multimedialib.tool.SpriteAtlasPacker;
import nl.colorize.util.FileUtils;
import nl.colorize.util.LogHelper;
import nl.colorize.util.cli.Arg;
import nl.colorize.util.cli.CommandLineArgumentParser;
import nl.colorize.util.swing.Utils2D;

public class ImageManipulationTool {
    @Arg(name="input")
    protected File inputDir;
    @Arg(name="output")
    protected File outputDir;
    @Arg(defaultValue="")
    protected String outputPrefix;
    @Arg(required=false)
    protected int horizontalOffset;
    @Arg(required=false)
    protected int verticalOffset;
    @Arg(required=false)
    protected boolean mirror;
    @Arg(required=false)
    protected int subImageSize;
    @Arg(required=false)
    protected float shear;
    private int counter;
    private static final Logger LOGGER = LogHelper.getLogger(ImageManipulationTool.class);

    public static void main(String[] argv) {
        CommandLineArgumentParser argParser = new CommandLineArgumentParser("ImageManipulationTool");
        ImageManipulationTool tool = (ImageManipulationTool)argParser.parse(argv, ImageManipulationTool.class);
        try {
            tool.run();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "I/O error during image manipulation", e);
        }
    }

    protected void run() throws IOException {
        for (File imageFile : FileUtils.walkFiles((File)this.inputDir, this::isImageFile)) {
            LOGGER.info("Processing " + imageFile.getName());
            BufferedImage image = Utils2D.loadImage((File)imageFile);
            this.processImage(imageFile, image);
        }
    }

    private boolean isImageFile(File file) {
        String ext = FileUtils.getFileExtension((File)file);
        return SpriteAtlasPacker.IMAGE_FILE_EXTENSIONS.contains(ext);
    }

    private void processImage(File imageFile, BufferedImage original) {
        if (this.horizontalOffset > 0) {
            this.applyHorizontalOffset(original);
        }
        if (this.verticalOffset > 0) {
            this.applyVerticalOffset(original);
        }
        if (this.mirror) {
            this.mirrorImage(original);
        }
        if (this.subImageSize > 0) {
            this.extractSubImages(original);
        }
        if (this.shear != 0.0f) {
            this.shearImage(imageFile, original);
        }
    }

    private void applyHorizontalOffset(BufferedImage original) {
        for (int x = 0; x <= original.getWidth(); x += this.horizontalOffset) {
            int offset = x;
            this.generateVariant(original, g2 -> {
                g2.drawImage(original, offset, 0, null);
                g2.drawImage(original, offset - original.getWidth(), 0, null);
            });
        }
    }

    private void applyVerticalOffset(BufferedImage original) {
        for (int y = 0; y <= original.getHeight(); y += this.verticalOffset) {
            int offset = y;
            this.generateVariant(original, g2 -> {
                g2.drawImage(original, 0, offset, null);
                g2.drawImage(original, 0, offset - original.getHeight(), null);
            });
        }
    }

    private void mirrorImage(BufferedImage original) {
        int width = original.getWidth();
        int height = original.getHeight();
        this.generateVariant(original, g2 -> {
            g2.drawImage(original, 0, 0, width / 2, height / 2, 0, 0, width, height, null);
            g2.drawImage(original, width, 0, width / 2, height / 2, 0, 0, width, height, null);
            g2.drawImage(original, 0, height, width / 2, height / 2, 0, 0, width, height, null);
            g2.drawImage(original, width, height, width / 2, height / 2, 0, 0, width, height, null);
        });
    }

    private void extractSubImages(BufferedImage original) {
        for (int y = 0; y < original.getHeight(); y += this.subImageSize) {
            for (int x = 0; x < original.getWidth(); x += this.subImageSize) {
                BufferedImage subimage = original.getSubimage(x, y, this.subImageSize, this.subImageSize);
                this.writePNG(subimage);
            }
        }
    }

    private void shearImage(File imageFile, BufferedImage original) {
        double shearedWidth = original.getWidth();
        double shearedHeight = ((double)this.shear / 90.0 * 1.5 + 1.0) * (double)original.getHeight();
        AffineTransform transform = new AffineTransform();
        transform.setToIdentity();
        transform.translate(0.0, (shearedHeight - (double)original.getHeight()) / 2.0);
        transform.translate(shearedWidth / 2.0, shearedHeight / 2.0);
        transform.shear(0.0, Math.toRadians(this.shear));
        transform.translate(-shearedWidth / 2.0, -shearedHeight / 2.0);
        BufferedImage result = new BufferedImage((int)Math.round(shearedWidth), (int)Math.round(shearedHeight), 2);
        Graphics2D g2 = Utils2D.createGraphics((BufferedImage)result, (boolean)true, (boolean)true);
        g2.drawImage(original, transform, null);
        g2.dispose();
        this.writePNG(result, imageFile.getName());
    }

    private void generateVariant(BufferedImage original, Consumer<Graphics2D> drawCallback) {
        BufferedImage image = new BufferedImage(original.getWidth(), original.getHeight(), 2);
        Graphics2D g2 = Utils2D.createGraphics((BufferedImage)image, (boolean)true, (boolean)true);
        drawCallback.accept(g2);
        g2.dispose();
        this.writePNG(image);
    }

    private void writePNG(BufferedImage image) {
        ++this.counter;
        String outputFileName = this.outputPrefix + this.counter + ".png";
        this.writePNG(image, outputFileName);
    }

    private void writePNG(BufferedImage image, String outputFileName) {
        File outputFile = new File(this.outputDir, outputFileName);
        if (outputFile.exists()) {
            LOGGER.warning(outputFile.getAbsolutePath() + " already exists");
            return;
        }
        try {
            FileUtils.mkdir((File)this.outputDir);
            Utils2D.savePNG((BufferedImage)image, (File)outputFile);
            LOGGER.info("Created " + outputFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write image: " + outputFile.getAbsolutePath());
        }
    }
}

