/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import java.util.logging.Logger;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.RenderConfig;
import nl.colorize.multimedialib.renderer.ScaleStrategy;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.tool.Demo2D;
import nl.colorize.multimedialib.tool.Demo3D;
import nl.colorize.multimedialib.tool.DemoIsometric;
import nl.colorize.util.LogHelper;

public class TeaDemoLauncher {
    private static final int BROWSER_FRAMERATE = 60;
    private static final Logger LOGGER = LogHelper.getLogger(TeaDemoLauncher.class);

    public static void main(String[] args) {
        LOGGER.info("MultimediaLib - TeaVM Demo");
        String demoMode = TeaDemoLauncher.getDemoMode();
        GraphicsMode graphicsMode = demoMode.equals("3d") ? GraphicsMode.MODE_3D : GraphicsMode.MODE_2D;
        Canvas canvas = new Canvas(800, 600, ScaleStrategy.balanced());
        String defaultRenderer = graphicsMode == GraphicsMode.MODE_3D ? "three" : "canvas";
        String rendererName = Browser.getBrowserBridge().getQueryParameter("renderer", defaultRenderer);
        LOGGER.info("Renderer: " + rendererName);
        RenderConfig config = RenderConfig.forBrowser(rendererName, graphicsMode, canvas);
        config.setFramerate(60);
        config.setErrorHandler(TeaDemoLauncher::logError);
        switch (demoMode) {
            case "2d": {
                config.start(new Demo2D());
                break;
            }
            case "3d": {
                config.start(new Demo3D());
                break;
            }
            case "isometric": {
                config.start(new DemoIsometric());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static String getDemoMode() {
        String defaultDemoMode = Browser.getBrowserBridge().getMeta("demo", "2d");
        return Browser.getBrowserBridge().getQueryParameter("demo", defaultDemoMode);
    }

    private static void logError(SceneContext context, Exception cause) {
        LOGGER.info("----");
        LOGGER.info(cause.getMessage());
        LOGGER.info("----");
    }
}

