<p:declare-step xmlns:dedicon="http://www.dedicon.nl" xmlns:p="http://www.w3.org/ns/xproc" xmlns:px="http://www.daisy.org/ns/pipeline/xproc" xmlns:dtb="http://www.daisy.org/z3986/2005/dtbook/" xmlns:pef="http://www.daisy.org/ns/2008/pef" xmlns:c="http://www.w3.org/ns/xproc-step" type="dedicon:dtbook-to-pef" version="1.0" exclude-inline-prefixes="#all" name="main">

    <p:documentation xmlns="http://www.w3.org/1999/xhtml">
        <h1 px:role="name">DTBook to PEF (Dedicon)</h1>
        <p px:role="desc">Transforms a DTBook (DAISY 3 XML) document into a PEF.</p>
    </p:documentation>
    
    <p:input port="source" primary="true" px:name="source" px:media-type="application/x-dtbook+xml"><p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Input DTBook</h2>
        </p:documentation></p:input>
    
    <p:option xmlns:pxd="http://www.daisy.org/ns/pipeline/xproc" name="stylesheet" select="'http://www.dedicon.nl/pipeline/modules/braille/default.scss'" px:sequence="true" required="false" px:type="string" px:media-type="text/css application/xslt+xml" pxd:data-type="px:dtbook-to-pef-stylesheet"><p:documentation xmlns="http://www.w3.org/1999/xhtml" xmlns:d="http://www.daisy.org/ns/pipeline/data">
            <h2 px:role="name">Style sheets</h2>
            <p px:role="desc" xml:space="preserve">A list of XSLT or CSS/SASS style sheets to apply.

Must be a space separated list of URIs, absolute or relative to the input.

Style sheets can also be associated with the source in other ways: linked (using an
['xml-stylesheet' processing instruction](https://www.w3.org/TR/xml-stylesheet) or a ['link'
element](https://www.w3.org/Style/styling-XML#External)), embedded (using a ['style'
element](https://www.w3.org/Style/styling-XML#Embedded)) and/or inlined (using '[style'
attributes](https://www.w3.org/TR/css-style-attr/)).

Style sheets are applied to the document in the following way: XSLT style sheets are applied before
CSS/SASS style sheets. XSLT style sheets are applied one by one, first the ones specified through
this option, then the ones associated with the source document, in the order in which they are
specified.

All CSS/SASS style sheets are applied at once, but the order in which they are specified (first the
ones specified through this option, then the ones associated with the source document) has an
influence on the [cascading order](https://www.w3.org/TR/CSS2/cascade.html#cascading-order).

CSS/SASS style sheets are interpreted according to [braille
CSS](http://braillespecs.github.io/braille-css) rules.

For info on how to use SASS (Syntactically Awesome StyleSheets) see the [SASS
manual](http://sass-lang.com/documentation/file.SASS_REFERENCE.html).</p>
        </p:documentation></p:option>
    <p:option name="include-preview" select="'true'" required="false" px:type="boolean"><p:documentation xmlns="http://www.w3.org/1999/xhtml" xmlns:d="http://www.daisy.org/ns/pipeline/data">
            <h2 px:role="name">Include preview</h2>
            <p px:role="desc" xml:space="preserve">Whether or not to include a preview of the PEF in HTML.</p>
        </p:documentation></p:option>
    <p:option name="include-brf" select="'true'" required="false" px:type="boolean"><p:documentation xmlns="http://www.w3.org/1999/xhtml" xmlns:d="http://www.daisy.org/ns/pipeline/data">
            <h2 px:role="name">Include plain text file (BRF)</h2>
            <p px:role="desc" xml:space="preserve">Whether or not to include a plain text ASCII version of the PEF.</p>
        </p:documentation></p:option>
    <p:option name="include-obfl" select="'false'" required="false" px:type="boolean"><p:documentation xmlns:d="http://www.daisy.org/ns/pipeline/data">
        <h2 px:role="name">Include OBFL</h2>
        <p px:role="desc" xml:space="preserve">Keeps the intermediary OBFL-file for debugging.</p>
      </p:documentation></p:option>
    <p:option name="ascii-file-format" select="'(table:&#34;com_braillo.BrailloTableProvider.TableType.BRAILLO_6DOT_031_01&#34;)(line-breaks:dos)(pad:both)(charset:&#34;IBM00858&#34;)(file-extension:&#34;.brl&#34;)'" required="false" px:type="string" px:data-type="transform-query"><p:documentation xmlns="http://www.w3.org/1999/xhtml" xmlns:d="http://www.daisy.org/ns/pipeline/data">
            <h2 px:role="name">Plain text (BRF) file format</h2>
            <p px:role="desc" xml:space="preserve">The file format to store the plain text version.

If left blank, the locale information in the input document will be used to select a suitable file format.</p>
        </p:documentation></p:option>
    <p:option name="ascii-table" required="false" px:type="string" px:data-type="transform-query" select="''"><p:documentation xmlns="http://www.w3.org/1999/xhtml" xmlns:d="http://www.daisy.org/ns/pipeline/data">
            <h2 px:role="name">ASCII braille table</h2>
            <p px:role="desc" xml:space="preserve">The ASCII braille table, used to render the PEF preview and, if no plain text file format was specified, the plain text version.

If left blank, the locale information in the input document will be used to select a suitable table.</p>
        </p:documentation></p:option>
    <p:option name="add-boilerplate" required="false" px:type="boolean" select="'true'">
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Add boilerplate text</h2>
            <p px:role="desc">When enabled, and when the input has a `docauthor` element, will insert boilerplate text such as a title page.</p>
        </p:documentation>
    </p:option>
    <p:option name="page-width" select="'-1'" required="false" px:type="integer">
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Page layout: Page width

</h2>
            <p px:role="desc" xml:space="preserve">The number of columns available for printing.

Makes the variable `$page-width` available in style sheets and includes the following rule by default:

~~~sass
@page {
  size: $page-width $page-height;
}
~~~

See the CSS specification for more info:

- the [`@page`](http://braillespecs.github.io/braille-css/#h4_the-page-rule) rule
- the [`size`](http://braillespecs.github.io/braille-css/#the-size-property) property


Use `-1` to compute this from metadata.</p>
        </p:documentation>
    </p:option>
    <p:option name="page-height" select="'-1'" required="false" px:type="integer">
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Page layout: Page height

</h2>
            <p px:role="desc" xml:space="preserve">The number of rows available for printing.

Makes the variable `$page-height` available in style sheets and includes the following rule by default:

~~~sass
@page {
  size: $page-width $page-height;
}
~~~

See the CSS specification for more info:

- the [`@page`](http://braillespecs.github.io/braille-css/#h4_the-page-rule) rule
- the [`size`](http://braillespecs.github.io/braille-css/#the-size-property) property


Use `-1` to compute this from metadata.</p>
        </p:documentation>
    </p:option>
    <p:option name="duplex" select="'true'" required="false" px:type="boolean"><p:documentation xmlns="http://www.w3.org/1999/xhtml" xmlns:d="http://www.daisy.org/ns/pipeline/data">
            <h2 px:role="name">Page layout: Duplex</h2>
            <p px:role="desc" xml:space="preserve">When enabled, will print on both sides of the paper.</p>
        </p:documentation></p:option>
    <p:option xmlns:pxd="http://www.daisy.org/ns/pipeline/xproc" name="hyphenation" select="'from-meta'" required="false" px:type="boolean" pxd:data-type="dedicon:dtbook-to-pef-hyphenation"><p:documentation xmlns="http://www.w3.org/1999/xhtml" xmlns:d="http://www.daisy.org/ns/pipeline/data">
            <h2 px:role="name">Translation/formatting of text: Hyphenation</h2>
            <p px:role="desc" xml:space="preserve">When enabled, will automatically hyphenate text.

Makes the variable `$hyphenation` available in style sheets and includes the following rule by
default:

~~~sass
@if $hyphenation {
  :root {
    hyphens: auto;
  }
}
~~~

See the CSS specification for more info:

- the [`hyphens`](http://braillespecs.github.io/braille-css/#the-hyphens-property) property
</p>
        </p:documentation>
        
    </p:option>
    <p:option xmlns:pxd="http://www.daisy.org/ns/pipeline/xproc" name="line-spacing" select="'single'" required="false" pxd:data-type="px:xml-to-pef-line-spacing"><p:documentation xmlns="http://www.w3.org/1999/xhtml" xmlns:d="http://www.daisy.org/ns/pipeline/data">
            <h2 px:role="name">Translation/formatting of text: Line spacing</h2>
            <p px:role="desc" xml:space="preserve">Single or double line spacing.

Makes the variable `$line-spacing` available in style sheets and includes the following rule by
default:

~~~sass
@if $line-spacing == double {
  :root {
    line-height: 2;
  }
}
~~~

See the CSS specification for more info:

- the [`line-height`](http://braillespecs.github.io/braille-css/#h3_the-line-height-property)
  property
</p>
        </p:documentation></p:option>
    <p:option name="capital-letters" select="'true'" required="false" px:type="boolean"><p:documentation xmlns="http://www.w3.org/1999/xhtml" xmlns:d="http://www.daisy.org/ns/pipeline/data">
            <h2 px:role="name">Translation/formatting of text: Capital letters</h2>
            <p px:role="desc" xml:space="preserve">When enabled, will indicate capital letters.

Makes the variable `$capital-letters` available in style sheets and includes the following rule by
default:

~~~sass
@if $capital-letters != true {
  :root {
    text-transform: lowercase;
  }
}
~~~</p>
        </p:documentation></p:option>
    <p:option name="include-captions" select="'true'" required="false" px:type="boolean"><p:documentation xmlns="http://www.w3.org/1999/xhtml" xmlns:d="http://www.daisy.org/ns/pipeline/data">
            <h2 px:role="name">Block elements: Include captions</h2>
            <p px:role="desc" xml:space="preserve">When enabled, will include captions for images, tables, and so on.

Makes the variable `$include-captions` available in style sheets and includes the following rule by
default:

~~~sass
caption {
  display: if($include-captions, block, none);
}
~~~</p>
        </p:documentation></p:option>
    <p:option name="include-images" select="'false'" required="false" px:type="boolean"><p:documentation xmlns="http://www.w3.org/1999/xhtml" xmlns:d="http://www.daisy.org/ns/pipeline/data">
            <h2 px:role="name">Block elements: Include images</h2>
            <p px:role="desc" xml:space="preserve">When enabled, will include the alt text of the images. When disabled, the images will be completely removed.

Makes the variable `$include-images` available in style sheets and includes the following rule by
default:

~~~sass
@if $include-images {
  img::after {
    content: attr(alt);
  }
}
~~~</p>
        </p:documentation></p:option> <!-- displays the alt text -->
    <p:option name="include-image-groups" select="'true'" required="false" px:type="boolean"><p:documentation xmlns="http://www.w3.org/1999/xhtml" xmlns:d="http://www.daisy.org/ns/pipeline/data">
            <h2 px:role="name">Block elements: Include image groups</h2>
            <p px:role="desc" xml:space="preserve">**Not implemented**</p>
        </p:documentation></p:option>
    <p:option name="include-line-groups" select="'true'" required="false" px:type="boolean"><p:documentation xmlns="http://www.w3.org/1999/xhtml" xmlns:d="http://www.daisy.org/ns/pipeline/data">
            <h2 px:role="name">Block elements: Include line groups</h2>
            <p px:role="desc" xml:space="preserve">When disabled, lines in a linegroup are joined together to form one block.

Makes the variable `$include-line-groups` available in style sheets and includes the following rule
by default:

~~~sass
linegroup line {
  display: if($include-line-groups, block, inline);
}
~~~</p>
        </p:documentation></p:option>
    <p:option name="include-production-notes" select="'true'" required="false" px:type="boolean"><p:documentation xmlns="http://www.w3.org/1999/xhtml" xmlns:d="http://www.daisy.org/ns/pipeline/data">
            <h2 px:role="name">Inline elements: Include production notes</h2>
            <p px:role="desc" xml:space="preserve">When enabled, production notes are included in the content.

Makes the variable `$include-production-notes` available in style sheets and includes the following
rule by default:

~~~sass
prodnote {
  display: if($include-production-notes, block, none);
}
~~~</p>
        </p:documentation></p:option>
    <p:option name="show-braille-page-numbers" select="'true'" required="false" px:type="boolean"><p:documentation xmlns="http://www.w3.org/1999/xhtml" xmlns:d="http://www.daisy.org/ns/pipeline/data">
            <h2 px:role="name">Page numbers: Show braille page numbers</h2>
            <p px:role="desc" xml:space="preserve">When enabled, will number braille pages.

Makes the variable `$show-braille-page-numbers` available in style sheets. In order to use the
variable include a rule like the following in your custom style sheet:

~~~sass
@if $show-braille-page-numbers {
  @page {
    @top-right {
      content: counter(page);
    }
  }
}
~~~

This will create a page number in the top right corner of every braille page.

See the CSS specification for more info:

- the [`@page`](http://braillespecs.github.io/braille-css/#h4_the-page-rule) rule
- the
  [`counter()`](http://braillespecs.github.io/braille-css/#printing-counters-the-counter-function)
  function
</p>
        </p:documentation></p:option>
    <p:option name="show-print-page-numbers" select="'true'" required="false" px:type="boolean"><p:documentation xmlns="http://www.w3.org/1999/xhtml" xmlns:d="http://www.daisy.org/ns/pipeline/data">
            <h2 px:role="name">Page numbers: Show print page numbers</h2>
            <p px:role="desc" xml:space="preserve">When enabled, will indicate original page numbers.

Makes the variable `$show-print-page-numbers` available in style sheets and includes the following
rule by default:

~~~sass
@if $show-print-page-numbers {
  pagenum {
    string-set: print-page content();
  }
}
~~~

In order to use the `print-page` string include a rule like the following in your custom style
sheet:

~~~css
@page {
  @bottom-right {
    content: string(print-page);
  }
}
~~~

See the CSS specification for more info:

- the [`string-set`](http://braillespecs.github.io/braille-css/#h4_the-string-set-property) property
- the [`@page`](http://braillespecs.github.io/braille-css/#h4_the-page-rule) rule
- the [`string()`](http://braillespecs.github.io/braille-css/#h4_the-string-function) function
</p>
        </p:documentation></p:option>
    <p:option xmlns:pxd="http://www.daisy.org/ns/pipeline/xproc" name="show-inline-print-page-numbers" select="'from-meta'" pxd:data-type="dedicon:dtbook-to-pef-show-inline-print-page-numbers">
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Show inline print page numbers</h2>
        </p:documentation>
        
    </p:option>
    <p:option name="force-braille-page-break" select="'false'" required="false" px:type="boolean"><p:documentation xmlns="http://www.w3.org/1999/xhtml" xmlns:d="http://www.daisy.org/ns/pipeline/data">
            <h2 px:role="name">Page numbers: Force braille page break</h2>
            <p px:role="desc" xml:space="preserve">Force braille page breaks at print page breaks.

Makes the variable `$force-braille-page-break` available in style sheets and includes the following
rule by default:

~~~sass
@if $force-braille-page-break {
  pagenum {
    page-break-before: always;
  }
}
~~~

See the CSS specification for more info:

- the [`page-break-before`](http://braillespecs.github.io/braille-css/#h4_controlling-page-breaks)
  property
</p>
        </p:documentation></p:option>
    <p:option name="toc-depth" select="'6'" required="false" px:type="integer"><p:documentation xmlns="http://www.w3.org/1999/xhtml" xmlns:d="http://www.daisy.org/ns/pipeline/data">
            <h2 px:role="name">Table of contents: Table of contents depth</h2>
            <p px:role="desc" xml:space="preserve">The depth of the table of contents hierarchy to include. '0' means no table of contents.

A table of contents will be generated from the heading elements present in the document: from `h1`
elements if the specified value for "depth" is 1, from `h1` and `h2` elements if the specified value
is 2, etc. The resulting table of contents has the following nested structure:

~~~xml
&lt;list id="generated-document-toc"&gt;
  &lt;li&gt;
      &lt;a href="#ch_1"&gt;Chapter 1&lt;/a&gt;
      &lt;list&gt;
          &lt;li&gt;
              &lt;a href="#ch_1_1"&gt;1.1&lt;/a&gt;
              ...
          &lt;/li&gt;
          &lt;li&gt;
              &lt;a href="#ch_1_2"&gt;1.2&lt;/a&gt;
              ...
          &lt;/li&gt;
          ...
      &lt;/list&gt;
  &lt;/li&gt;
  ...
&lt;/list&gt;
~~~

Another one of these is generated but with ID `generated-volume-toc`. `ch_1`, `ch_1_2` etc. are the
IDs of the heading elements from which the list was constructed, and the content of the links are
exact copies of the content of the heading elements. By default the list is not rendered. The list
should be styled and positioned with CSS. The following rules are included by default:

~~~css
#generated-document-toc {
  flow: document-toc;
  display: -obfl-toc;
  -obfl-toc-range: document;
}

#generated-volume-toc {
  flow: volume-toc;
  display: -obfl-toc;
  -obfl-toc-range: volume;
}
~~~

This means that a document range table of contents is added to the named flow called "document-toc",
and a volume range table of contents is added to the named flow called "volume-toc". In order to
consume these named flows use the function `flow()`. For example, to position the document range
table of contents at the beginning of the first volume, and to repeat the volume range table of
content at the beginning of every other volume, include the following additional rules:

~~~css
@volume {
  @begin {
    content: flow(volume-toc);
  }
}

@volume:first {
  @begin {
    content: flow(document-toc);
  }
}
~~~

See the CSS specification for more info:

- the [`display:
  obfl-toc`](http://braillespecs.github.io/braille-css/obfl#extending-the-display-property-with--obfl-toc)
  value
- the [`flow`](http://braillespecs.github.io/braille-css/#the-flow-property) property
- the [`flow()`](http://braillespecs.github.io/braille-css/#h4_the-flow-function) function
- the [`@volume`](http://braillespecs.github.io/braille-css/#h3_the-volume-rule) rule
- the [`@begin`](http://braillespecs.github.io/braille-css/#h3_the-begin-and-end-rules) rule
</p>
        </p:documentation></p:option>
    <p:option xmlns:pxd="http://www.daisy.org/ns/pipeline/xproc" name="include-document-toc-in-last-volume" required="false" px:type="boolean" select="'from-meta'" pxd:data-type="dedicon:dtbook-to-pef-include-document-toc-in-last-volume">
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Include document TOC</h2>
            <p px:role="desc" xml:space="preserve">Whether or not to include a document-level TOC in the last volume.</p>
        </p:documentation>
        
    </p:option>
    <p:option name="include-symbols-list" required="false" px:type="boolean" select="'true'">
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Include symbols list</h2>
            <p px:role="desc" xml:space="preserve">When enabled, a list of symbols and their descriptions is included in the first volume.</p>
        </p:documentation>
    </p:option>
    <p:option name="symbols-code" select="'http://www.dedicon.nl/pipeline/modules/braille/symbols_code.xml'">
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Symbols list</h2>
            <p px:role="desc" xml:space="preserve">If left unchanged, the default symbols list will be used.</p>
        </p:documentation>
    </p:option>
    <p:option name="symbols-list-header" required="false" px:type="string" select="'Symbolenlijst'">
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Symbols list header</h2>
        </p:documentation>
    </p:option>
    <p:option name="move-print-cover-to-first-volume" required="false" px:type="boolean" select="'true'">
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Move print cover to first volume</h2>
            <p px:role="desc">When enabled, and when the input has a `level1` element with class `flap`, will move that cover to the first volume.</p>
        </p:documentation>
    </p:option>
    <p:option xmlns:pxd="http://www.daisy.org/ns/pipeline/xproc" name="move-print-colophon-to-last-volume" required="false" px:type="boolean" select="'from-meta'" pxd:data-type="dedicon:dtbook-to-pef-move-print-colophon-to-last-volume">
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Move print colophon to last volume</h2>
            <p px:role="desc">When enabled, and when the input has a `level1` element with class `colophon`, will move that colophon to the last volume.</p>
        </p:documentation>
        
    </p:option>
    <p:option name="maximum-number-of-sheets" select="'-1'" required="false" px:type="integer">
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Volumes: Maximum number of sheets

</h2>
            <p px:role="desc" xml:space="preserve">The maximum number of sheets in a volume.

Makes the variable `$maximum-number-of-sheets` available in style sheets and includes the following
rule by default:

~~~sass
@volume {
  max-length: $maximum-number-of-sheets;
}
~~~

See the CSS specification for more info:

- the [`@volume`](http://braillespecs.github.io/braille-css/#h3_the-volume-rule) rule
- the [`max-length`](http://braillespecs.github.io/braille-css/#h3_the-length-properties) property


Use `-1` to compute this from metadata.</p>
        </p:documentation>
    </p:option>
    <p:option name="pef-output-dir" required="true" px:output="result" px:type="anyDirURI" px:media-type="application/x-pef+xml"><p:documentation xmlns="http://www.w3.org/1999/xhtml" xmlns:d="http://www.daisy.org/ns/pipeline/data">
            <h2 px:role="name">PEF</h2>
            <p px:role="desc">The PEF.</p>
        </p:documentation></p:option>
    <p:option name="brf-output-dir" select="''" required="false" px:output="result" px:type="anyDirURI" px:media-type="text"><p:documentation xmlns="http://www.w3.org/1999/xhtml" xmlns:d="http://www.daisy.org/ns/pipeline/data">
            <h2 px:role="name">BRF</h2>
            <p px:role="desc">A plain text ASCII version of the PEF.</p>
        </p:documentation></p:option>
    <p:option name="preview-output-dir" select="''" required="false" px:output="result" px:type="anyDirURI" px:media-type="text/html"><p:documentation xmlns="http://www.w3.org/1999/xhtml" xmlns:d="http://www.daisy.org/ns/pipeline/data">
            <h2 px:role="name">Preview</h2>
            <p px:role="desc">An HTML preview of the PEF.</p>
        </p:documentation></p:option>
    <p:option name="temp-dir" select="''" required="false" px:output="temp" px:type="anyDirURI"><p:documentation xmlns="http://www.w3.org/1999/xhtml" xmlns:d="http://www.daisy.org/ns/pipeline/data">
            <h2 px:role="name">Temporary directory</h2>
            <p px:role="desc">Directory for storing temporary files during conversion.</p>
        </p:documentation></p:option>
    
    <p:import href="http://www.daisy.org/pipeline/modules/braille/dtbook-to-pef/library.xpl"/>
    <p:import href="http://www.daisy.org/pipeline/modules/braille/xml-to-pef/library.xpl"/>
    <p:import href="http://www.daisy.org/pipeline/modules/braille/pef-utils/library.xpl"/>
    <p:import href="http://www.daisy.org/pipeline/modules/file-utils/library.xpl"/>
    <p:import href="http://www.daisy.org/pipeline/modules/common-utils/library.xpl"/>
    <p:import href="http://www.dedicon.nl/pipeline/modules/braille/library.xpl"/>
    
    <p:in-scope-names name="in-scope-names"/>
    <px:merge-parameters>
        <p:input port="source">
            <p:pipe port="result" step="in-scope-names"/>
        </p:input>
    </px:merge-parameters>
    <px:delete-parameters parameter-names="stylesheet                                     symbols-code                                     ascii-table                                     include-brf                                     include-preview                                     pef-output-dir                                     brf-output-dir                                     preview-output-dir                                     temp-dir"/>
    <px:add-parameters>
      <p:with-param name="skip-margin-top-of-page" select="true()"/>
      <p:with-param name="page-width" select="if ($page-width='-1')                                then if (//dtb:meta[@name='prod:docType']/@content='ro') then '28'                                     else if (//dtb:meta[@name='prod:docType']/@content='sv') then '33' else ''                                else $page-width">
        <p:pipe step="main" port="source"/>
      </p:with-param>
      <p:with-param name="page-height" select="if ($page-height='-1')                                then if (//dtb:meta[@name='prod:docType']/@content='ro') then '26'                                     else if (//dtb:meta[@name='prod:docType']/@content='sv') then '27' else ''                                else $page-height">
        <p:pipe step="main" port="source"/>
      </p:with-param>
      <p:with-param name="maximum-number-of-sheets" select="if ($maximum-number-of-sheets='-1')                                then if (//dtb:meta[@name='prod:docType']/@content='ro') then '35'                                     else if (//dtb:meta[@name='prod:docType']/@content='sv') then '37' else ''                                else $maximum-number-of-sheets">
        <p:pipe step="main" port="source"/>
      </p:with-param>
      <p:with-param name="hyphenation" select="if ($hyphenation='from-meta')                                then (//dtb:meta[@name='prod:docHyphenate']/@content,'Y')[1]='Y'                                else $hyphenation='true'">
        <p:pipe step="main" port="source"/>
      </p:with-param>
      <p:with-param name="show-inline-print-page-numbers" select="if ($show-inline-print-page-numbers='from-meta')                                then //dtb:meta[@name='prod:docType']/@content='sv'                                else $show-inline-print-page-numbers='true'">
        <p:pipe step="main" port="source"/>
      </p:with-param>
      <p:with-param name="include-document-toc-in-last-volume" select="if ($include-document-toc-in-last-volume='from-meta')                                then //dtb:meta[@name='prod:docType']/@content='ro'                                else $include-document-toc-in-last-volume='true'">
        <p:pipe step="main" port="source"/>
      </p:with-param>
      <p:with-param name="move-print-colophon-to-last-volume" select="if ($move-print-colophon-to-last-volume='from-meta')                                then //dtb:meta[@name='prod:docType']/@content='sv'                                else $move-print-colophon-to-last-volume='true'">
        <p:pipe step="main" port="source"/>
      </p:with-param>
    </px:add-parameters>
    <p:identity name="input-options"/>
    <p:sink/>
    
    <!-- =============== -->
    <!-- CREATE TEMP DIR -->
    <!-- =============== -->
    <px:tempdir name="temp-dir">
        <p:with-option name="href" select="if ($temp-dir!='') then $temp-dir else $pef-output-dir"/>
    </px:tempdir>
    <p:sink/>
    
    <!-- ==================== -->
    <!-- DTBOOK PREPROCESSING -->
    <!-- ==================== -->
    <p:identity>
        <p:input port="source">
            <p:pipe step="main" port="source"/>
        </p:input>
    </p:identity>
    <dedicon:src-backslash-fix/>
    <p:choose>
        <p:when test="$include-symbols-list='true'">
            <dedicon:symbols-list>
                <p:with-option name="symbols-code" select="$symbols-code"/>
                <p:with-option name="symbols-list-header" select="$symbols-list-header"/>
            </dedicon:symbols-list>
        </p:when>
        <p:otherwise>
            <px:message message="Skipping symbols list"/>
        </p:otherwise>
    </p:choose>
    <p:choose>
        <p:when test="$add-boilerplate='true'">
            <dedicon:pre-processing>
                <p:input port="parameters">
                    <p:pipe step="input-options" port="result"/>
                </p:input>
            </dedicon:pre-processing>
        </p:when>
        <p:otherwise>
            <px:message message="Skipping Dedicon-specific pre-processing steps"/>
        </p:otherwise>
    </p:choose>
    
    <!-- ============= -->
    <!-- DTBOOK TO PEF -->
    <!-- ============= -->
    <px:dtbook-to-pef.convert default-stylesheet="http://www.daisy.org/pipeline/modules/braille/dtbook-to-pef/css/default.css" transform="(formatter:dotify)(translator:dedicon)">
        <p:with-option name="temp-dir" select="string(/c:result)">
            <p:pipe step="temp-dir" port="result"/>
        </p:with-option>
        <p:with-option name="stylesheet" select="$stylesheet"/>
        <p:input port="parameters">
            <p:pipe port="result" step="input-options"/>
        </p:input>
    </px:dtbook-to-pef.convert>
    
    <!-- ========= -->
    <!-- STORE PEF -->
    <!-- ========= -->
    <p:group>
        <p:variable name="name" select="if (//dtb:meta[@name='dc:Identifier']/@content)                                 then //dtb:meta[@name='dc:Identifier']/@content                                 else replace(p:base-uri(/),'^.*/([^/]*)\.[^/\.]*$','$1')">
            <p:pipe step="main" port="source"/>
        </p:variable>
        <pef:store>
            <p:with-option name="href" select="concat($pef-output-dir,'/',$name,'.pef')"/>
            <p:with-option name="preview-href" select="if ($include-preview='true' and $preview-output-dir!='')                                                        then concat($preview-output-dir,'/',$name,'.pef.html')                                                        else ''"/>
            <!-- <p:with-option name="brf-table" select="if ($ascii-table!='') then $ascii-table
                                                    else concat('(locale:',(/*/@xml:lang,'und')[1],')')"/> -->
            <p:with-option name="brf-dir-href" select="                 if ($include-brf='true')                 then                     if ($brf-output-dir!='')                     then $brf-output-dir                     else                         if ($pef-output-dir!='')                         then $pef-output-dir                         else ''                 else ''             "/>
            <p:with-option name="brf-file-format" select="$ascii-file-format"/>
            <p:with-option name="brf-name-pattern" select="concat('p',$name,'_{}')"/>
            <p:with-option name="brf-number-width" select="'3'"/>
        </pef:store>
    </p:group>
    
</p:declare-step>