/*
 * Decompiled with CFR 0.152.
 */
package nl.dedicon.pipeline.braille.symbolslist;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Utils {
    public static Document convertToDocument(XdmNode node) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(node.toString())));
        return document;
    }

    public static XdmNode convertToXdmNode(Document document, net.sf.saxon.s9api.DocumentBuilder documentBuilder, boolean useFile) throws IOException, SaxonApiException {
        XdmNode node;
        String xml = documentBuilder.wrap((Object)document).toString();
        if (useFile) {
            String className = new Object(){}.getClass().getName();
            File tempFile = File.createTempFile(className, ".tmp");
            tempFile.deleteOnExit();
            Files.write(tempFile.toPath(), xml.getBytes(), new OpenOption[0]);
            node = documentBuilder.build(tempFile);
        } else {
            node = documentBuilder.build((Source)new StreamSource(new StringReader(xml)));
        }
        return node;
    }

    public static Node getChild(Node node, String name) {
        if (node == null) {
            return null;
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!name.equals(child.getNodeName())) continue;
            return child;
        }
        return null;
    }

    public static Element addChild(Node parent, String name) {
        Element child = parent.getOwnerDocument().createElement(name);
        parent.appendChild(child);
        return child;
    }

    public static String getValue(XdmNode node, QName childName) {
        XdmSequenceIterator childIterator = node.axisIterator(Axis.CHILD, childName);
        if (!childIterator.hasNext()) {
            return null;
        }
        return childIterator.next().getStringValue();
    }

    public static boolean isBraille(char c) {
        return '\u2800' <= c && c <= '\u283f';
    }
}

