package org.daisy.pipeline.modules.impl;

import java.io.File;
import java.net.URI;

import org.daisy.pipeline.modules.AbstractModuleBuilder;
import org.daisy.pipeline.modules.JarModuleBuilder;
import org.daisy.pipeline.modules.Module;
import org.daisy.pipeline.modules.ModuleRef;
import org.daisy.pipeline.xmlcatalog.XmlCatalogParser;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(
    name = "org.daisy.pipeline.modules.impl.Module_braille_module",
    service = { ModuleRef.class },
    immediate = true
)
public class Module_braille_module implements ModuleRef {
    
    private Module instance;
    private XmlCatalogParser catalogParser;
    
    public Module get() {
        if (instance == null) {
            AbstractModuleBuilder builder
            = AbstractModuleBuilder.fromContainedClass(Module_braille_module.class)
                                   .withCatalogParser(catalogParser);
            if (builder instanceof JarModuleBuilder) {
                // name, version and title not set yet
                builder.withName("braille-module")
                       .withVersion("1.6.5")
                       .withTitle("DP2 Braille Modules :: mod-dedicon");
            }
            instance = builder.build();
        }
        return instance;
    }
    
    @Reference(
        name = "XmlCatalogParser",
        unbind = "-",
        service = XmlCatalogParser.class,
        cardinality = ReferenceCardinality.MANDATORY,
        policy = ReferencePolicy.STATIC
    )
    public void setParser(XmlCatalogParser parser) {
        catalogParser = parser;
    }
}
