/*
 * Decompiled with CFR 0.152.
 */
package nl.dedicon.pipeline.braille.calabash.impl;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.core.XProcStep;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import nl.dedicon.pipeline.braille.step.BrailleToText;
import nl.dedicon.pipeline.braille.step.Utils;
import org.daisy.common.xproc.calabash.XProcStepProvider;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ModifyPreviewStep
extends DefaultStep {
    private static final Logger logger = LoggerFactory.getLogger(ModifyPreviewStep.class);
    private static final QName _preview_uri = new QName("preview-uri");

    private ModifyPreviewStep(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    public void reset() {
    }

    public void run() throws SaxonApiException {
        super.run();
        try {
            String previewUri = this.getOption(_preview_uri, "");
            Processor processor = this.runtime.getProcessor();
            Path previewPath = new File(new URI(previewUri)).toPath();
            String sourceHtml = new String(Files.readAllBytes(previewPath), "UTF-8");
            int htmlStartIndex = sourceHtml.indexOf("<html ");
            String header = sourceHtml.substring(0, htmlStartIndex);
            String sourceXml = sourceHtml.substring(htmlStartIndex);
            Document document = Utils.convertToDocument(sourceXml);
            new BrailleToText().convert(document);
            String resultXml = Utils.toString(document, processor.newDocumentBuilder());
            String resultHtml = header.concat(Utils.convertXmlEndtagsToHtmlEndtags(resultXml));
            Files.write(previewPath, resultHtml.getBytes("UTF-8"), new OpenOption[0]);
        }
        catch (Exception e) {
            logger.error("dedicon:modify-preview failed", (Throwable)e);
            throw new XProcException(this.step.getNode(), (Throwable)e);
        }
    }

    @Component(name="dedicon:modify-preview", service={XProcStepProvider.class}, property={"type:String={http://www.dedicon.nl}modify-preview"})
    public static class Provider
    implements XProcStepProvider {
        public XProcStep newStep(XProcRuntime runtime, XAtomicStep step) {
            return new ModifyPreviewStep(runtime, step);
        }
    }
}

