/*
 * Decompiled with CFR 0.152.
 */
package nl.dedicon.pipeline.braille.impl;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.daisy.common.file.URIs;
import org.daisy.common.file.URLs;
import org.daisy.pipeline.braille.common.AbstractBrailleTranslator;
import org.daisy.pipeline.braille.common.AbstractTransformProvider;
import org.daisy.pipeline.braille.common.BrailleTranslator;
import org.daisy.pipeline.braille.common.BrailleTranslatorProvider;
import org.daisy.pipeline.braille.common.CSSStyledText;
import org.daisy.pipeline.braille.common.Hyphenator;
import org.daisy.pipeline.braille.common.HyphenatorProvider;
import org.daisy.pipeline.braille.common.Query;
import org.daisy.pipeline.braille.common.Transform;
import org.daisy.pipeline.braille.common.TransformProvider;
import org.daisy.pipeline.braille.liblouis.LiblouisTranslator;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

public interface DediconTranslator {

    @Component(name="nl.dedicon.pipeline.braille.impl.DediconTranslator.Provider", service={TransformProvider.class, BrailleTranslatorProvider.class})
    public static class Provider
    extends AbstractTransformProvider<BrailleTranslator>
    implements BrailleTranslatorProvider<BrailleTranslator> {
        private URI href;
        private static final AbstractTransformProvider.Iterable<BrailleTranslator> empty = AbstractTransformProvider.util.Iterables.empty();
        private static final List<String> supportedInput = ImmutableList.of((Object)"css", (Object)"text-css", (Object)"dtbook", (Object)"html");
        private static final List<String> supportedOutput = ImmutableList.of((Object)"css", (Object)"braille");
        private final List<TransformProvider<LiblouisTranslator>> liblouisTranslatorProviders = new ArrayList<TransformProvider<LiblouisTranslator>>();
        private final TransformProvider.util.MemoizingProvider<LiblouisTranslator> liblouisTranslatorProvider = TransformProvider.util.memoize((TransformProvider)TransformProvider.util.dispatch(this.liblouisTranslatorProviders));
        private final List<TransformProvider<Hyphenator>> hyphenatorProviders = new ArrayList<TransformProvider<Hyphenator>>();
        private final TransformProvider.util.MemoizingProvider<Hyphenator> hyphenatorProvider = TransformProvider.util.memoize((TransformProvider)TransformProvider.util.dispatch(this.hyphenatorProviders));

        @Activate
        void activate(Map<?, ?> properties) {
            this.href = URIs.asURI((Object)URLs.getResourceFromJAR((String)"/xml/xproc/block-translate.xpl", DediconTranslator.class));
        }

        protected final AbstractTransformProvider.Iterable<BrailleTranslator> _get(Query query) {
            final Query liblouisTable = Query.util.query((String)"(locale:nl_NL)");
            Query.MutableQuery hyphenationLocale = null;
            Query.MutableQuery q = Query.util.mutableQuery((Query)query);
            for (Query.Feature f : q.removeAll("input")) {
                if (supportedInput.contains(f.getValue().get())) continue;
                return empty;
            }
            for (Query.Feature f : q.removeAll("output")) {
                if (supportedOutput.contains(f.getValue().get())) continue;
                return empty;
            }
            if (q.containsKey("locale")) {
                hyphenationLocale = Query.util.mutableQuery().addAll(q.removeAll("locale"));
            }
            if (hyphenationLocale == null) {
                return empty;
            }
            if (q.containsKey("translator") && "dedicon".equals(q.removeOnly("translator").getValue().get()) && q.isEmpty()) {
                Query.MutableQuery hyphenTable = Query.util.mutableQuery((Query)hyphenationLocale).add("hyphenator", "hyphen");
                Query.MutableQuery fallbackHyphenationTable = Query.util.mutableQuery((Query)hyphenationLocale).add("hyphenator", "tex");
                AbstractTransformProvider.Iterable hyphenators = AbstractTransformProvider.util.Iterables.concat((AbstractTransformProvider.Iterable)AbstractTransformProvider.util.logSelect((Query)hyphenTable, this.hyphenatorProvider), (AbstractTransformProvider.Iterable)AbstractTransformProvider.util.logSelect((Query)fallbackHyphenationTable, this.hyphenatorProvider));
                return AbstractTransformProvider.util.Iterables.concat((AbstractTransformProvider.Iterable)AbstractTransformProvider.util.Iterables.transform((AbstractTransformProvider.Iterable)AbstractTransformProvider.util.Iterables.concat((AbstractTransformProvider.Iterable)AbstractTransformProvider.util.Iterables.transform((AbstractTransformProvider.Iterable)hyphenators, (AbstractTransformProvider.util.Function)new AbstractTransformProvider.util.Function<Hyphenator, String>(){

                    public String _apply(Hyphenator h) {
                        return h.getIdentifier();
                    }
                }), (Object)"liblouis"), (AbstractTransformProvider.util.Function)new AbstractTransformProvider.util.Function<String, AbstractTransformProvider.Iterable<BrailleTranslator>>(){

                    public AbstractTransformProvider.Iterable<BrailleTranslator> _apply(String hyphenator) {
                        Query.MutableQuery translatorQuery = Query.util.mutableQuery((Query)liblouisTable).add("hyphenator", hyphenator);
                        return AbstractTransformProvider.util.Iterables.transform((AbstractTransformProvider.Iterable)AbstractTransformProvider.util.logSelect((Query)translatorQuery, (TransformProvider)liblouisTranslatorProvider), (AbstractTransformProvider.util.Function)new AbstractTransformProvider.util.Function<LiblouisTranslator, BrailleTranslator>((Query)translatorQuery){
                            final /* synthetic */ Query val$translatorQuery;
                            {
                                this.val$translatorQuery = query;
                            }

                            public BrailleTranslator _apply(LiblouisTranslator translator) {
                                return (BrailleTranslator)this.__apply((Function)AbstractTransformProvider.util.logCreate((Transform)new TransformImpl(this.val$translatorQuery.toString(), translator)));
                            }
                        });
                    }
                }));
            }
            return empty;
        }

        @Reference(name="LiblouisTranslatorProvider", unbind="unbindLiblouisTranslatorProvider", service=LiblouisTranslator.Provider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
        protected void bindLiblouisTranslatorProvider(LiblouisTranslator.Provider provider) {
            this.liblouisTranslatorProviders.add((TransformProvider<LiblouisTranslator>)provider);
        }

        protected void unbindLiblouisTranslatorProvider(LiblouisTranslator.Provider provider) {
            this.liblouisTranslatorProviders.remove(provider);
            this.liblouisTranslatorProvider.invalidateCache();
        }

        @Reference(name="HyphenatorProvider", unbind="unbindHyphenatorProvider", service=HyphenatorProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
        protected void bindHyphenatorProvider(HyphenatorProvider<?> provider) {
            this.hyphenatorProviders.add((TransformProvider<Hyphenator>)provider);
        }

        protected void unbindHyphenatorProvider(HyphenatorProvider<?> provider) {
            this.hyphenatorProviders.remove(provider);
            this.hyphenatorProvider.invalidateCache();
        }

        private class TransformImpl
        extends AbstractBrailleTranslator {
            private final BrailleTranslator.FromStyledTextToBraille translator;
            private final Transform.XProc xproc;
            private final BrailleTranslator.FromStyledTextToBraille fromStyledTextToBraille = new BrailleTranslator.FromStyledTextToBraille(){

                public Iterable<String> transform(Iterable<CSSStyledText> styledText, int from, int to) {
                    return TransformImpl.this.translator.transform(styledText, from, to);
                }
            };

            private TransformImpl(String translatorQuery, LiblouisTranslator translator) {
                ImmutableMap options = ImmutableMap.of((Object)"text-transform", (Object)Query.util.mutableQuery().add("id", this.getIdentifier()).toString());
                this.xproc = new Transform.XProc(Provider.this.href, null, (Map)options);
                this.translator = translator.fromStyledTextToBraille();
            }

            public Transform.XProc asXProc() {
                return this.xproc;
            }

            public BrailleTranslator.FromStyledTextToBraille fromStyledTextToBraille() {
                return this.fromStyledTextToBraille;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)DediconTranslator.class.getSimpleName()).add("id", (Object)this.getIdentifier()).add("liblouisTranslator", (Object)this.translator).toString();
            }
        }
    }
}

