/*
 * Decompiled with CFR 0.152.
 */
package nl.dedicon.pipeline.braille.calabash.impl;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.core.XProcStep;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import org.apache.commons.lang3.StringUtils;
import org.daisy.common.xproc.calabash.XProcStepProvider;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrlMustStartWithNewlineStep
extends DefaultStep {
    private static final Logger logger = LoggerFactory.getLogger(BrlMustStartWithNewlineStep.class);
    private static final QName _brl_uri = new QName("brl-uri");

    private BrlMustStartWithNewlineStep(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    public void reset() {
    }

    public void run() throws SaxonApiException {
        block5: {
            super.run();
            try {
                String brlUri = this.getOption(_brl_uri, "");
                if (!StringUtils.isNotBlank((CharSequence)brlUri)) break block5;
                try {
                    Path path = new File(new URI(brlUri)).toPath();
                    byte[] bytes = Files.readAllBytes(path);
                    if (bytes.length > 1 && bytes[0] != 13 && bytes[1] != 10) {
                        byte[] newLine = new byte[]{13, 10};
                        Files.write(path, newLine, new OpenOption[0]);
                        Files.write(path, bytes, StandardOpenOption.APPEND);
                    }
                }
                catch (IOException | URISyntaxException e) {
                    logger.error(String.format("Failed to insert a newline in file %s due to %s", brlUri, e.getMessage()));
                    throw e;
                }
            }
            catch (Exception e) {
                logger.error("dedicon:brl-must-start-with-newline failed", (Throwable)e);
                throw new XProcException(this.step.getNode(), (Throwable)e);
            }
        }
    }

    @Component(name="dedicon:brl-must-start-with-newline", service={XProcStepProvider.class}, property={"type:String={http://www.dedicon.nl}brl-must-start-with-newline"})
    public static class Provider
    implements XProcStepProvider {
        public XProcStep newStep(XProcRuntime runtime, XAtomicStep step) {
            return new BrlMustStartWithNewlineStep(runtime, step);
        }
    }
}

