/*
 * Decompiled with CFR 0.152.
 */
package nl.dedicon.pipeline.braille.calabash.impl;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.core.XProcStep;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import nl.dedicon.pipeline.braille.calabash.impl.MetadataStep;
import org.daisy.braille.api.embosser.FileFormat;
import org.daisy.common.xproc.calabash.XProcStepProvider;
import org.daisy.pipeline.braille.common.Provider;
import org.daisy.pipeline.braille.common.Query;
import org.daisy.pipeline.braille.pef.FileFormatProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrlUrisStep
extends DefaultStep {
    private static final String DEDICON_NAMESPACE = "http://www.dedicon.nl";
    private static final Logger logger = LoggerFactory.getLogger(MetadataStep.class);
    private static final QName _xquery = new QName("xquery");
    private static final QName _brf_dir_href = new QName("brf-dir-href");
    private static final QName _brf_file_extension = new QName("brf-file-extension");
    private static final QName _brf_file_format = new QName("brf-file-format");
    private static final QName _brf_name_pattern = new QName("brf-name-pattern");
    private static final QName _brf_number_width = new QName("brf-number-width");
    private final Provider.util.MemoizingProvider<Query, FileFormat> fileFormatProvider;
    private ReadablePipe source = null;
    private WritablePipe result = null;

    private BrlUrisStep(XProcRuntime runtime, XAtomicStep step, Provider.util.MemoizingProvider<Query, FileFormat> fileFormatProvider) {
        super(runtime, step);
        this.fileFormatProvider = fileFormatProvider;
    }

    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    public void run() throws SaxonApiException {
        super.run();
        try {
            XdmNode pef = this.source.read();
            String xquery = this.getOption(_xquery, "");
            String brfDirHref = this.getOption(_brf_dir_href, "");
            String brfFileFormat = this.getOption(_brf_file_format, "");
            String brfNamePattern = this.getOption(_brf_name_pattern, "");
            int brfNumberWidth = this.getOption(_brf_number_width, 0);
            String brfFileExtension = this.getFileExtension(brfFileFormat);
            InputStream query = new URL(xquery).openConnection().getInputStream();
            XQueryCompiler xqCompiler = this.runtime.getProcessor().newXQueryCompiler();
            XQueryExecutable xqExecutable = xqCompiler.compile(query);
            XQueryEvaluator xqEvaluator = xqExecutable.load();
            xqEvaluator.setSource(pef.asSource());
            xqEvaluator.setExternalVariable(_brf_dir_href, (XdmValue)new XdmAtomicValue(brfDirHref));
            xqEvaluator.setExternalVariable(_brf_name_pattern, (XdmValue)new XdmAtomicValue(brfNamePattern));
            xqEvaluator.setExternalVariable(_brf_number_width, (XdmValue)new XdmAtomicValue(brfNumberWidth));
            xqEvaluator.setExternalVariable(_brf_file_extension, (XdmValue)new XdmAtomicValue(brfFileExtension));
            XdmValue xqResult = xqEvaluator.evaluate();
            for (XdmValue xqValue : xqResult) {
                if (!(xqValue instanceof XdmNode)) continue;
                this.result.write((XdmNode)xqValue);
            }
        }
        catch (Exception e) {
            logger.error("dedicon:brl-uris failed", (Throwable)e);
            throw new XProcException(this.step.getNode(), (Throwable)e);
        }
    }

    private String getFileExtension(String fileFormatQuery) {
        String fileExtension;
        block0: {
            Query.MutableQuery q = Query.util.mutableQuery((Query)Query.util.query((String)fileFormatQuery));
            Iterable fileFormats = this.fileFormatProvider.get((Object)q);
            fileExtension = "";
            Iterator iterator = fileFormats.iterator();
            if (!iterator.hasNext()) break block0;
            FileFormat fileFormat = (FileFormat)iterator.next();
            fileExtension = fileFormat.getFileExtension();
        }
        return fileExtension;
    }

    @Component(name="dedicon:brl-uris", service={XProcStepProvider.class}, property={"type:String={http://www.dedicon.nl}brl-uris"})
    public static class Provider
    implements XProcStepProvider {
        private List<FileFormatProvider> fileFormatProviders = new ArrayList<FileFormatProvider>();
        private Provider.util.MemoizingProvider<Query, FileFormat> fileFormatProvider = Provider.util.memoize((org.daisy.pipeline.braille.common.Provider)Provider.util.dispatch(this.fileFormatProviders));

        public XProcStep newStep(XProcRuntime runtime, XAtomicStep step) {
            return new BrlUrisStep(runtime, step, this.fileFormatProvider);
        }

        @Reference(name="FileFormatProvider", unbind="unbindFileFormatProvider", service=FileFormatProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
        protected void bindFileFormatProvider(FileFormatProvider provider) {
            this.fileFormatProviders.add(provider);
        }

        protected void unbindFileFormatProvider(FileFormatProvider provider) {
            this.fileFormatProviders.remove(provider);
            this.fileFormatProvider.invalidateCache();
        }
    }
}

