/*
 * Decompiled with CFR 0.152.
 */
package nl.dedicon.pipeline.braille.step;

import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NotesMover {
    private static final String NOTE = "note";
    private static final String NOTEREF = "noteref";
    private static final String ID = "id";
    private static final String IDREF = "idref";
    private final Map<String, Element> notes = new HashMap<String, Element>();
    private final Map<String, Element> noterefs = new HashMap<String, Element>();

    public void collectNotesAndNoterefs(Document document) {
        NotesMover.collect(document, this.notes, NOTE, ID, s -> s);
        NotesMover.collect(document, this.noterefs, NOTEREF, IDREF, s -> s.replaceFirst("^#", ""));
    }

    private static void collect(Document document, Map map, String nodeName, String attributeName, UnaryOperator<String> attributeFormatter) {
        String namespace = document.getDocumentElement().getNamespaceURI();
        NodeList nodeList = document.getElementsByTagNameNS(namespace, nodeName);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String attributeValue = element.getAttribute(attributeName);
            if (attributeValue == null || attributeValue.length() <= 0) continue;
            map.put(attributeFormatter.apply(attributeValue), element);
        }
    }

    public void moveNotes() {
        this.notes.entrySet().stream().forEach(e -> {
            String id = (String)e.getKey();
            Element note = (Element)e.getValue();
            Element noteref = this.noterefs.get(id);
            if (noteref == null) {
                return;
            }
            Node parent = noteref.getParentNode();
            if (parent == null) {
                return;
            }
            Node grandParent = parent.getParentNode();
            if (grandParent == null) {
                return;
            }
            grandParent.insertBefore(note, parent.getNextSibling());
        });
    }
}

