/*
 * Decompiled with CFR 0.152.
 */
package nl.dedicon.pipeline.braille.calabash.impl;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import nl.dedicon.pipeline.braille.step.JacketManager;
import nl.dedicon.pipeline.braille.step.Utils;
import org.daisy.common.xproc.calabash.XProcStep;
import org.daisy.common.xproc.calabash.XProcStepProvider;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class JacketStep
extends DefaultStep
implements XProcStep {
    private static final Logger logger = LoggerFactory.getLogger(JacketStep.class);
    private static final QName _jacket_header = new QName("jacket-header");
    private ReadablePipe source = null;
    private WritablePipe result = null;

    private JacketStep(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    public void run() throws SaxonApiException {
        super.run();
        try {
            XdmNode book = this.source.read();
            String header = this.getOption(_jacket_header, "");
            Document document = Utils.convertToDocument(book);
            JacketManager jacketManager = new JacketManager();
            jacketManager.collect(document);
            jacketManager.setHeader(header);
            jacketManager.move();
            XdmNode newBook = Utils.convertToXdmNode(document, this.runtime.getProcessor(), true);
            this.result.write(newBook);
        }
        catch (Exception e) {
            logger.error("dedicon:jacket failed", (Throwable)e);
            throw new XProcException(this.step.getNode(), (Throwable)e);
        }
    }

    @Component(name="dedicon:jacket", service={XProcStepProvider.class}, property={"type:String={http://www.dedicon.nl}jacket"})
    public static class Provider
    implements XProcStepProvider {
        public XProcStep newStep(XProcRuntime runtime, XAtomicStep step) {
            return new JacketStep(runtime, step);
        }
    }
}

