/*
 * Decompiled with CFR 0.152.
 */
package nl.dedicon.pipeline.braille.calabash.impl;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import java.io.StringReader;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import nl.dedicon.pipeline.braille.model.Book;
import nl.dedicon.pipeline.braille.model.Page;
import nl.dedicon.pipeline.braille.model.Section;
import nl.dedicon.pipeline.braille.model.Volume;
import org.apache.commons.lang3.StringUtils;
import org.daisy.braille.api.embosser.FileFormat;
import org.daisy.common.xproc.calabash.XProcStep;
import org.daisy.common.xproc.calabash.XProcStepProvider;
import org.daisy.pipeline.braille.common.Provider;
import org.daisy.pipeline.braille.common.Query;
import org.daisy.pipeline.braille.pef.FileFormatProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataStep
extends DefaultStep
implements XProcStep {
    private static final Logger logger = LoggerFactory.getLogger(MetadataStep.class);
    private static final QName _xquery = new QName("xquery");
    private static final QName _identifier = new QName("identifier");
    private static final QName _brf_file_extension = new QName("brf-file-extension");
    private static final QName _brf_file_format = new QName("brf-file-format");
    private static final QName _brf_name_pattern = new QName("brf-name-pattern");
    private static final QName _brf_number_width = new QName("brf-number-width");
    private static final QName _optional_date = new QName("optional-date");
    private static final String PEF_NAMESPACE = "http://www.daisy.org/ns/2008/pef";
    private static final String BRAILLE_DIGITS = "\u281a\u2801\u2803\u2809\u2819\u2811\u280b\u281b\u2813\u280a";
    private static final Pattern HEADER = Pattern.compile("[\u2800\\s]+(\u283c[\u281a\u2801\u2803\u2809\u2819\u2811\u280b\u281b\u2813\u280a]+|)([\u2800\\s]?\u2824[\u2800\\s]?\u283c[\u281a\u2801\u2803\u2809\u2819\u2811\u280b\u281b\u2813\u280a]+|)[\u2800\\s]+(\u283c[\u281a\u2801\u2803\u2809\u2819\u2811\u280b\u281b\u2813\u280a]+|)");
    private static final DateTimeFormatter DAY_MONTH_YEAR = DateTimeFormatter.ofPattern("d-M-Y");
    private final Provider.util.MemoizingProvider<Query, FileFormat> fileFormatProvider;
    private ReadablePipe source = null;
    private WritablePipe result = null;

    private MetadataStep(XProcRuntime runtime, XAtomicStep step, Provider.util.MemoizingProvider<Query, FileFormat> fileFormatProvider) {
        super(runtime, step);
        this.fileFormatProvider = fileFormatProvider;
    }

    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    public void run() throws SaxonApiException {
        super.run();
        try {
            XdmNode pef = this.source.read();
            String identifier = this.getOption(_identifier, "");
            String brfFileFormat = this.getOption(_brf_file_format, "");
            String brfNamePattern = this.getOption(_brf_name_pattern, "");
            int brfNumberWidth = this.getOption(_brf_number_width, 0);
            String optionalDate = this.getOption(_optional_date, "");
            String brfFileExtension = this.getFileExtension(brfFileFormat);
            Book book = this.parsePEF(pef);
            String metadataXml = this.createMetadataXml(book, identifier, brfNamePattern, brfNumberWidth, brfFileExtension, optionalDate);
            DocumentBuilder documentBuilder = this.runtime.getProcessor().newDocumentBuilder();
            XdmNode metadata = documentBuilder.build((Source)new StreamSource(new StringReader(metadataXml)));
            this.result.write(metadata);
        }
        catch (Exception e) {
            logger.error("dedicon:metadata failed", (Throwable)e);
            throw new XProcException(this.step.getNode(), (Throwable)e);
        }
    }

    private String getFileExtension(String fileFormatQuery) {
        String fileExtension;
        block0: {
            Query.MutableQuery q = Query.util.mutableQuery((Query)Query.util.query((String)fileFormatQuery));
            Iterable fileFormats = this.fileFormatProvider.get((Object)q);
            fileExtension = "";
            Iterator iterator = fileFormats.iterator();
            if (!iterator.hasNext()) break block0;
            FileFormat fileFormat = (FileFormat)iterator.next();
            fileExtension = fileFormat.getFileExtension();
        }
        return fileExtension;
    }

    private Book parsePEF(XdmNode pef) {
        Book book = new Book();
        this.getChildren(pef, PEF_NAMESPACE, "pef").forEach(pefRoot -> this.getChildren((XdmNode)pefRoot, PEF_NAMESPACE, "body").forEach(pefBody -> this.getChildren((XdmNode)pefBody, PEF_NAMESPACE, "volume").forEach(pefVolume -> {
            Volume volume = new Volume();
            book.getVolumes().add(volume);
            String pefDuplex = pefVolume.getAttributeValue(new QName("duplex"));
            volume.setDuplex("true".equalsIgnoreCase(pefDuplex));
            this.getChildren((XdmNode)pefVolume, PEF_NAMESPACE, "section").forEach(pefSection -> {
                Section section = new Section();
                volume.getSections().add(section);
                this.getChildren((XdmNode)pefSection, PEF_NAMESPACE, "page").forEach(pefPage -> {
                    Page page = new Page();
                    this.setPageNumbers(page, (XdmNode)pefPage);
                    section.getPages().add(page);
                });
            });
        })));
        this.determineVolumeMetadata(book);
        return book;
    }

    private void setPageNumbers(Page page, XdmNode pefPage) {
        block0: {
            Iterator<XdmNode> iterator = this.getChildren(pefPage, PEF_NAMESPACE, "row").iterator();
            if (!iterator.hasNext()) break block0;
            XdmNode pefRow = iterator.next();
            String header = pefRow.getStringValue();
            this.setPageNumbers(page, header);
        }
    }

    private List<XdmNode> getChildren(XdmNode parent, String namespace, String child) {
        ArrayList<XdmNode> children = new ArrayList<XdmNode>();
        XdmSequenceIterator iterator = parent.axisIterator(Axis.CHILD, new QName(namespace, child));
        while (iterator.hasNext()) {
            XdmItem item = iterator.next();
            if (!(item instanceof XdmNode)) continue;
            children.add((XdmNode)item);
        }
        return children;
    }

    private void setPageNumbers(Page page, String header) {
        Matcher pageNumbersMatcher = HEADER.matcher(header);
        if (pageNumbersMatcher.find()) {
            String fromPrintPageNumber = this.afterNumberSign(pageNumbersMatcher.group(1));
            String untilPrintPageNumber = this.afterNumberSign(pageNumbersMatcher.group(2));
            String pageNumber = this.afterNumberSign(pageNumbersMatcher.group(3));
            if (fromPrintPageNumber.length() > 0 && untilPrintPageNumber.length() == 0) {
                untilPrintPageNumber = fromPrintPageNumber;
            }
            if (fromPrintPageNumber.length() == 0 && untilPrintPageNumber.length() > 0) {
                fromPrintPageNumber = untilPrintPageNumber;
            }
            page.setFromPrintPageNumber(this.getNumber(fromPrintPageNumber));
            page.setUntilPrintPageNumber(this.getNumber(untilPrintPageNumber));
            page.setPageNumber(this.getNumber(pageNumber));
        }
    }

    private String afterNumberSign(String brailleNumber) {
        int index = brailleNumber.indexOf(10300);
        if (index >= 0) {
            return brailleNumber.substring(index + 1);
        }
        return "";
    }

    private Integer getNumber(String brailleNumber) {
        if (brailleNumber.length() == 0) {
            return null;
        }
        int number = 0;
        for (int i = 0; i < brailleNumber.length(); ++i) {
            char brailleDigit = brailleNumber.charAt(i);
            int digit = BRAILLE_DIGITS.indexOf(brailleDigit);
            number = number * 10 + digit;
        }
        return number;
    }

    private void determineVolumeMetadata(Book book) {
        Volume previousVolume = null;
        int expectedFirstPageNumber = 1;
        for (Volume volume : book.getVolumes()) {
            volume.setFirstPrintPageNumber(this.getFirstPrintPageNumber(volume));
            volume.setLastPrintPageNumber(this.getLastPrintPageNumber(volume));
            expectedFirstPageNumber = this.setPageNumbers(volume, expectedFirstPageNumber);
            if (previousVolume != null) {
                previousVolume.setLastPageNumber(volume.getFirstPageNumber() - 1);
            }
            previousVolume = volume;
        }
    }

    private Integer getFirstPrintPageNumber(Volume volume) {
        return volume.getSections().stream().map(Section::getPages).flatMap(Collection::stream).map(Page::getFromPrintPageNumber).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private Integer getLastPrintPageNumber(Volume volume) {
        return volume.getSections().stream().map(Section::getPages).flatMap(Collection::stream).map(Page::getUntilPrintPageNumber).filter(Objects::nonNull).sorted(Collections.reverseOrder()).findFirst().orElse(null);
    }

    private int setPageNumbers(Volume volume, int expectedFirstPageNumber) {
        volume.setFirstPageNumber(expectedFirstPageNumber);
        volume.setLastPageNumber(expectedFirstPageNumber);
        int lastPageNumber = expectedFirstPageNumber;
        boolean pageNumberFound = false;
        for (Section section : volume.getSections()) {
            int pagesInThisSection = 0;
            for (Page page : section.getPages()) {
                if (page.getPageNumber() != null) {
                    if (!pageNumberFound) {
                        volume.setFirstPageNumber(volume.getFirstPageNumber() + page.getPageNumber() - lastPageNumber);
                        pageNumberFound = true;
                    }
                    lastPageNumber = page.getPageNumber();
                }
                volume.setLastPageNumber(lastPageNumber);
                ++lastPageNumber;
                ++pagesInThisSection;
            }
            if (!volume.getDuplex().booleanValue()) continue;
            lastPageNumber += pagesInThisSection % 2;
        }
        return lastPageNumber;
    }

    private String createMetadataXml(Book book, String identifier, String brfNamePattern, int brfNumberWidth, String brfFileExtension, String optionalDate) throws SaxonApiException {
        String date = optionalDate;
        if (StringUtils.isBlank((CharSequence)date)) {
            date = LocalDate.now().format(DAY_MONTH_YEAR);
        }
        StringBuilder xml = new StringBuilder();
        xml.append("<lois_id>").append(identifier).append("</lois_id>");
        int volumeIndex = 0;
        for (Volume volume : book.getVolumes()) {
            xml.append("<volume>");
            xml.append("<filename>").append(this.getFilename(++volumeIndex, brfNamePattern, brfNumberWidth, brfFileExtension)).append("</filename>");
            xml.append("<vtype>br</vtype>");
            xml.append("<volumenumber>").append(volumeIndex).append("</volumenumber>");
            xml.append("<fromip>");
            if (volume.getFirstPrintPageNumber() != null) {
                xml.append(volume.getFirstPrintPageNumber());
            }
            xml.append("</fromip>");
            xml.append("<tillip>");
            if (volume.getLastPrintPageNumber() != null) {
                xml.append(volume.getLastPrintPageNumber());
            }
            xml.append("</tillip>");
            xml.append("<ippages>");
            if (volume.getFirstPrintPageNumber() != null && volume.getLastPrintPageNumber() != null) {
                xml.append(volume.getLastPrintPageNumber() - volume.getFirstPrintPageNumber() + 1);
            }
            xml.append("</ippages>");
            xml.append("<fromcp>");
            if (volume.getFirstPageNumber() != null) {
                xml.append(volume.getFirstPageNumber());
            }
            xml.append("</fromcp>");
            xml.append("<tillcp>");
            if (volume.getLastPageNumber() != null) {
                xml.append(volume.getLastPageNumber());
            }
            xml.append("</tillcp>");
            xml.append("<amount>");
            if (volume.getFirstPageNumber() != null && volume.getLastPageNumber() != null) {
                xml.append(volume.getLastPageNumber() - volume.getFirstPageNumber() + 1);
            }
            xml.append("</amount>");
            xml.append("<last>").append(volumeIndex == book.getVolumes().size() ? "Y" : "N").append("</last>");
            xml.append("<vreadydate>").append(date).append("</vreadydate>");
            xml.append("</volume>");
        }
        String document = "<document>".concat(xml.toString()).concat("</document>");
        return document;
    }

    private String getFilename(int volumeIndex, String brfNamePattern, int brfNumberWidth, String brfFileExtension) {
        String brfNumber = String.valueOf(volumeIndex);
        while (brfNumber.length() < brfNumberWidth) {
            brfNumber = "0" + brfNumber;
        }
        return brfNamePattern.replace("{}", brfNumber) + brfFileExtension;
    }

    @Component(name="dedicon:metadata", service={XProcStepProvider.class}, property={"type:String={http://www.dedicon.nl}metadata"})
    public static class Provider
    implements XProcStepProvider {
        private List<FileFormatProvider> fileFormatProviders = new ArrayList<FileFormatProvider>();
        private Provider.util.MemoizingProvider<Query, FileFormat> fileFormatProvider = Provider.util.memoize((org.daisy.pipeline.braille.common.Provider)Provider.util.dispatch(this.fileFormatProviders));

        public XProcStep newStep(XProcRuntime runtime, XAtomicStep step) {
            return new MetadataStep(runtime, step, this.fileFormatProvider);
        }

        @Reference(name="FileFormatProvider", unbind="unbindFileFormatProvider", service=FileFormatProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
        protected void bindFileFormatProvider(FileFormatProvider provider) {
            this.fileFormatProviders.add(provider);
        }

        protected void unbindFileFormatProvider(FileFormatProvider provider) {
            this.fileFormatProviders.remove(provider);
            this.fileFormatProvider.invalidateCache();
        }
    }
}

