/*
 * Decompiled with CFR 0.152.
 */
package nl.dedicon.pipeline.braille.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyService {
    private static final String APPLICATION_PROPERTIES = "org.daisy.pipeline.dedicon.application.properties";
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyService.class);
    private static Properties properties = null;

    public static String getProperty(String key, String defaultValue) {
        if (properties == null) {
            properties = PropertyService.loadProperties();
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)properties.getProperty(key), (CharSequence)defaultValue);
    }

    private static Properties loadProperties() {
        Properties result = new Properties();
        String applicationPropertiesLocation = org.daisy.common.properties.Properties.getProperty((String)APPLICATION_PROPERTIES);
        if (StringUtils.isNotBlank((CharSequence)applicationPropertiesLocation)) {
            File applicationPropertiesFile = new File(applicationPropertiesLocation);
            if (applicationPropertiesFile.isFile()) {
                try {
                    result.load(new FileInputStream(applicationPropertiesFile));
                    String message = String.format("Loaded application properties from location %s", applicationPropertiesLocation);
                    LOGGER.info(message);
                }
                catch (IOException ex) {
                    String message = String.format("Failed to load application properties from location %s", applicationPropertiesLocation);
                    LOGGER.error(message, (Throwable)ex);
                }
            } else {
                String message = String.format("Couldn't find application properties location %s", applicationPropertiesLocation);
                LOGGER.warn(message);
            }
        } else {
            String message = "No application properties location supplied. Using default properties.";
            LOGGER.info(message);
        }
        return result;
    }
}

