/*
 * Decompiled with CFR 0.152.
 */
package nl.dedicon.pipeline.braille.step;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Emphasis {
    public static final String[] EMPHASIS_CLASSES = new String[]{"emph-bxx-brl", "bold", "emph-xix-brl", "italic", "emph-xxu-brl", "underline"};
    public static final char[] EMPHASIS_SYMBOLS = new char[]{'\u2838', '\u2838', '\u2810', '\u2810', '\u2808', '\u2808'};
    public static final char RECOVERY_SIGN = '\u2820';
    public static final char[] HYPHEN_SIGNS = new char[]{'-', '\u2824'};
    private static final String CLASS = "class";

    public static void apply(Document document) {
        Emphasis.apply(document.getDocumentElement());
    }

    private static void apply(Element element) {
        String classValue = element.getAttribute(CLASS);
        if (classValue != null && classValue.length() > 0) {
            for (int i = 0; i < EMPHASIS_CLASSES.length; ++i) {
                if (!EMPHASIS_CLASSES[i].equalsIgnoreCase(classValue)) continue;
                Emphasis.addEmphasis(element, EMPHASIS_SYMBOLS[i]);
                break;
            }
        }
        for (Node childNode = element.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (childNode.getNodeType() != 1) continue;
            Emphasis.apply((Element)childNode);
        }
    }

    private static void addEmphasis(Element element, char emphasisSymbol) {
        boolean hasEmphasis = false;
        for (Node childNode = element.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (childNode.getNodeType() != 3 || !Emphasis.addEmphasis(childNode, emphasisSymbol)) continue;
            hasEmphasis = true;
        }
        if (hasEmphasis) {
            Emphasis.insertRecoverySignIfNeeded(element);
        }
    }

    private static boolean addEmphasis(Node textNode, char emphasisSymbol) {
        String textContent = textNode.getTextContent();
        if (textContent == null || textContent.length() == 0) {
            return false;
        }
        String[] words = textContent.trim().split(" ");
        StringBuffer newTextContent = new StringBuffer();
        boolean atStart = true;
        if (words.length > 3) {
            int i;
            newTextContent.append(emphasisSymbol).append(emphasisSymbol);
            for (i = 0; i < words.length - 1; ++i) {
                if (atStart) {
                    atStart = false;
                } else {
                    newTextContent.append(' ');
                }
                newTextContent.append(words[i]);
            }
            newTextContent.append(' ').append(emphasisSymbol).append(words[i]);
        } else {
            for (String word : words) {
                if (atStart) {
                    atStart = false;
                } else {
                    newTextContent.append(' ');
                }
                newTextContent.append(emphasisSymbol).append(word);
            }
        }
        textNode.setTextContent(newTextContent.toString());
        return true;
    }

    private static void insertRecoverySignIfNeeded(Element element) {
        Node parent;
        for (parent = element; parent != null && parent.getNextSibling() == null; parent = parent.getParentNode()) {
        }
        if (parent == null) {
            return;
        }
        Node nextSibling = parent.getNextSibling();
        if (nextSibling.getNodeType() != 3) {
            return;
        }
        String textContent = nextSibling.getTextContent();
        if (textContent == null || textContent.length() == 0) {
            return;
        }
        char firstChar = textContent.charAt(0);
        if (("" + firstChar).trim().isEmpty()) {
            return;
        }
        for (char hyphen : HYPHEN_SIGNS) {
            if (firstChar != hyphen) continue;
            return;
        }
        nextSibling.setTextContent('\u2820' + textContent);
    }
}

