/*
 * Decompiled with CFR 0.152.
 */
package nl.dedicon.pipeline.braille.step;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NotesMover {
    private static final String NOTE = "note";
    private static final String NOTEREF = "noteref";
    private static final String ID = "id";
    private static final String IDREF = "idref";

    public void moveNotes(Document document) {
        String namespace = document.getDocumentElement().getNamespaceURI();
        NodeList noteRefList = document.getElementsByTagNameNS(namespace, NOTEREF);
        Map<String, Element> idRef2noteRefMap = NotesMover.getIdRef2noteRefMap(noteRefList);
        NodeList noteList = document.getElementsByTagNameNS(namespace, NOTE);
        ArrayList<Element> notes = new ArrayList<Element>();
        for (int i = noteList.getLength() - 1; i >= 0; --i) {
            notes.add((Element)noteList.item(i));
        }
        notes.forEach(note -> NotesMover.moveNote(note, idRef2noteRefMap));
    }

    private static Map<String, Element> getIdRef2noteRefMap(NodeList noteRefList) {
        HashMap<String, Element> idRef2noteRefMap = new HashMap<String, Element>();
        for (int i = 0; i < noteRefList.getLength(); ++i) {
            Element noteRef = (Element)noteRefList.item(i);
            String idRef = noteRef.getAttribute(IDREF);
            if (idRef == null || (idRef = idRef.replaceFirst("^#", "")).length() <= 0) continue;
            idRef2noteRefMap.put(idRef, noteRef);
        }
        return idRef2noteRefMap;
    }

    private static void moveNote(Element note, Map<String, Element> idRef2noteRefMap) {
        String id = note.getAttribute(ID);
        if (id == null || id.length() == 0) {
            return;
        }
        Element noteRef = idRef2noteRefMap.get(id);
        if (noteRef == null) {
            return;
        }
        Node parent = noteRef.getParentNode();
        if (parent == null) {
            return;
        }
        Node grandParent = parent.getParentNode();
        if (grandParent == null) {
            return;
        }
        grandParent.insertBefore(note, parent.getNextSibling());
    }
}

