/*
 * Decompiled with CFR 0.152.
 */
package nl.dedicon.pipeline.braille.step;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import nl.dedicon.pipeline.braille.step.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProcessingInstructionsHandler {
    private static final String DEDICON_NAMESPACE = "http://www.dedicon.nl";
    private static final String DEDICON_PREFIX = "dedicon";

    public static void replaceProcessingInstructions(Document document) {
        ProcessingInstructionsHandler.addDediconNamespace(document);
        List<Node> processingInstructions = ProcessingInstructionsHandler.findProcessingInstructions(document);
        Set<Node> volumeBreakProcessingInstructions = processingInstructions.stream().filter(processingInstruction -> "VolumeBreak".equals(processingInstruction.getNodeName())).collect(Collectors.toSet());
        Set<Element> volumeBreakNextElements = volumeBreakProcessingInstructions.stream().map(ProcessingInstructionsHandler::nextElement).filter(Objects::nonNull).collect(Collectors.toSet());
        volumeBreakNextElements.forEach(ProcessingInstructionsHandler::setVolumeBreakBefore);
        Utils.removeNodes(volumeBreakProcessingInstructions);
    }

    private static void addDediconNamespace(Document document) {
        document.getDocumentElement().setAttribute("xmlns:dedicon", DEDICON_NAMESPACE);
    }

    private static List<Node> findProcessingInstructions(Node node) {
        ArrayList<Node> processingInstructions = new ArrayList<Node>();
        if (node.getNodeType() == 7) {
            processingInstructions.add(node);
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            processingInstructions.addAll(ProcessingInstructionsHandler.findProcessingInstructions(child));
        }
        return processingInstructions;
    }

    private static Element nextElement(Node node) {
        while (node != null) {
            Node nextElement;
            for (nextElement = node.getNextSibling(); nextElement != null && nextElement.getNodeType() != 1; nextElement = nextElement.getNextSibling()) {
            }
            if (nextElement != null) {
                return (Element)nextElement;
            }
            node = node.getParentNode();
        }
        return null;
    }

    private static void setVolumeBreakBefore(Element element) {
        element.setAttributeNS(DEDICON_NAMESPACE, "dedicon:break-before", "volume");
    }
}

