/*
 * Decompiled with CFR 0.152.
 */
package nl.dedicon.pipeline.braille.step;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import nl.dedicon.pipeline.braille.model.Context;
import nl.dedicon.pipeline.braille.model.Replace;
import nl.dedicon.pipeline.braille.model.Symbol;
import nl.dedicon.pipeline.braille.step.DediconBrl;
import nl.dedicon.pipeline.braille.step.NumericMode;
import nl.dedicon.pipeline.braille.step.Utils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SymbolsReplacer {
    private static final QName _addleadingspace = new QName("addleadingspace");
    private static final QName _addtrailingspace = new QName("addtrailingspace");
    private static final QName _braille = new QName("braille");
    private static final QName _char = new QName("char");
    private static final QName _close = new QName("close");
    private static final QName _context = new QName("context");
    private static final QName _description = new QName("description");
    private static final QName _language = new QName("language");
    private static final QName _open = new QName("open");
    private static final QName _removeleadingspace = new QName("removeleadingspace");
    private static final QName _removetrailingspace = new QName("removetrailingspace");
    private static final QName _replace = new QName("replace");
    private static final QName _symbol = new QName("symbol");
    private static final QName _symbols = new QName("symbols");
    private final Map<String, Symbol> symbolsMap;
    private final Integer[] symbolLengthsDescending;
    private final Set<Replace> symbolsListReplaces = new HashSet<Replace>();

    public SymbolsReplacer(XdmNode symbolsCodeNode) {
        this.symbolsMap = SymbolsReplacer.filterSymbols(symbolsCodeNode);
        this.symbolLengthsDescending = SymbolsReplacer.determineSymbolLengths(this.symbolsMap);
    }

    private static Map<String, Symbol> filterSymbols(XdmNode symbolsCodeNode) {
        HashMap<String, Symbol> symbolsMap = new HashMap<String, Symbol>();
        XdmSequenceIterator symbolsIterator = symbolsCodeNode.axisIterator(Axis.CHILD, _symbols);
        while (symbolsIterator.hasNext()) {
            XdmNode symbolsNode = (XdmNode)symbolsIterator.next();
            XdmSequenceIterator symbolIterator = symbolsNode.axisIterator(Axis.CHILD, _symbol);
            while (symbolIterator.hasNext()) {
                XdmNode symbolNode = (XdmNode)symbolIterator.next();
                String character = Utils.getValue(symbolNode, _char);
                String language = Utils.getValue(symbolNode, _language);
                ArrayList<Replace> replaces = new ArrayList<Replace>();
                XdmSequenceIterator replaceIterator = symbolNode.axisIterator(Axis.CHILD, _replace);
                while (replaceIterator.hasNext()) {
                    XdmNode replaceNode = (XdmNode)replaceIterator.next();
                    Context context = Context.get(replaceNode.getAttributeValue(_context));
                    String braille = Utils.getValue(replaceNode, _braille);
                    String description = Utils.getChildNode(replaceNode, _description).getStringValue();
                    if (context == null || !StringUtils.isNotBlank((CharSequence)braille)) continue;
                    XdmNode brailleNode = Utils.getChildNode(replaceNode, _braille);
                    boolean brailleAddLeadingSpace = StringUtils.isNotBlank((CharSequence)brailleNode.getAttributeValue(_addleadingspace));
                    boolean brailleRemoveLeadingSpace = StringUtils.isNotBlank((CharSequence)brailleNode.getAttributeValue(_removeleadingspace));
                    boolean brailleAddTrailingSpace = StringUtils.isNotBlank((CharSequence)brailleNode.getAttributeValue(_addtrailingspace));
                    boolean brailleRemoveTrailingSpace = StringUtils.isNotBlank((CharSequence)brailleNode.getAttributeValue(_removetrailingspace));
                    String brailleOpen = brailleNode.getAttributeValue(_open);
                    String brailleClose = brailleNode.getAttributeValue(_close);
                    Replace replace = new Replace();
                    replace.setContext(context);
                    replace.setBraille(DediconBrl.convert(braille));
                    replace.setBrailleAddLeadingSpace(brailleAddLeadingSpace);
                    replace.setBrailleRemoveLeadingSpace(brailleRemoveLeadingSpace);
                    replace.setBrailleAddTrailingSpace(brailleAddTrailingSpace);
                    replace.setBrailleRemoveTrailingSpace(brailleRemoveTrailingSpace);
                    replace.setBrailleOpen(brailleOpen);
                    replace.setBrailleClose(brailleClose);
                    replace.setDescription(description);
                    replaces.add(replace);
                }
                if (!StringUtils.isNotBlank((CharSequence)character) || replaces.isEmpty()) continue;
                Symbol symbol = new Symbol();
                symbol.setCharacter(character);
                symbol.setLanguage(language);
                symbol.setReplaces(replaces);
                replaces.stream().forEach(r -> r.setParent(symbol));
                symbolsMap.put(SymbolsReplacer.entirelyUppercaseOrLowercase(character), symbol);
            }
        }
        return symbolsMap;
    }

    private static Integer[] determineSymbolLengths(Map<String, Symbol> symbolsMap) {
        HashSet symbolLengths = new HashSet();
        symbolsMap.keySet().stream().map(String::length).forEach(symbolLengths::add);
        Integer[] symbolLengthsDescending = symbolLengths.toArray(new Integer[symbolLengths.size()]);
        Arrays.sort(symbolLengthsDescending, (i, j) -> j.compareTo((Integer)i));
        return symbolLengthsDescending;
    }

    protected Set<Replace> getSymbolsListReplaces() {
        return this.symbolsListReplaces;
    }

    private String replace(String source, Context context) {
        if (source == null) {
            return null;
        }
        NumericMode numericMode = NumericMode.no;
        String target = source;
        block5: for (int index = 0; index < target.length(); ++index) {
            char c = target.charAt(index);
            if (Utils.isDigit(c)) {
                numericMode = NumericMode.yes;
            } else {
                switch (numericMode) {
                    case yes: {
                        if (Utils.isDecimalSeparator(c)) {
                            numericMode = NumericMode.decimalSign;
                            break;
                        }
                        if (Utils.isDigit(c)) break;
                        numericMode = NumericMode.no;
                        break;
                    }
                    case decimalSign: {
                        if (Utils.isDigit(c)) {
                            numericMode = NumericMode.yes;
                            break;
                        }
                        if (Utils.isMoneyZeros(c)) {
                            numericMode = NumericMode.moneyZeros;
                            break;
                        }
                        numericMode = NumericMode.no;
                        break;
                    }
                    case moneyZeros: {
                        if (Utils.isMoneyZeros(c)) break;
                        numericMode = NumericMode.no;
                        break;
                    }
                }
            }
            if (numericMode != NumericMode.no) continue;
            for (Integer symbolLength : this.symbolLengthsDescending) {
                if (index + symbolLength > target.length()) continue;
                String substring = target.substring(index, index + symbolLength);
                Replace replaceBook = this.determineReplace(substring, context, ReplaceTarget.book);
                if (replaceBook == null && context != Context.Default) {
                    replaceBook = this.determineReplace(substring, Context.Default, ReplaceTarget.book);
                }
                if (replaceBook == null) continue;
                numericMode = NumericMode.no;
                Replace replaceSymbolsList = this.determineReplace(substring, context, ReplaceTarget.symbolsList);
                if (replaceSymbolsList == null && context != Context.Default) {
                    replaceSymbolsList = this.determineReplace(substring, Context.Default, ReplaceTarget.symbolsList);
                }
                if (replaceSymbolsList != null && StringUtils.isNotBlank((CharSequence)replaceSymbolsList.getDescription())) {
                    this.symbolsListReplaces.add(replaceSymbolsList);
                }
                String before = target.substring(0, index);
                String braille = replaceBook.getBraille();
                String after = target.substring(index + symbolLength);
                if (StringUtils.isNotBlank((CharSequence)replaceBook.getBrailleOpen()) || StringUtils.isNotBlank((CharSequence)replaceBook.getBrailleClose())) {
                    int endIndex = StringUtils.indexOf((CharSequence)after, (int)251);
                    if (SymbolsReplacer.startsWithBlank(after) && endIndex > 1) {
                        after = StringUtils.join((Object[])new String[]{replaceBook.getBrailleOpen(), after.substring(1, endIndex), replaceBook.getBrailleClose(), after.substring(endIndex + 1)});
                    } else {
                        while (SymbolsReplacer.startsWithBlank(after)) {
                            after = after.substring(1);
                        }
                        for (endIndex = 0; endIndex < after.length() && StringUtils.isNotBlank((CharSequence)after.substring(endIndex, endIndex + 1)); ++endIndex) {
                        }
                        after = StringUtils.join((Object[])new String[]{replaceBook.getBrailleOpen(), after.substring(0, endIndex), replaceBook.getBrailleClose(), after.substring(endIndex)});
                    }
                }
                if (replaceBook.getBrailleAddLeadingSpace().booleanValue() && !SymbolsReplacer.endsWithBlank(before)) {
                    before = before.concat(" ");
                    ++index;
                }
                if (replaceBook.getBrailleRemoveLeadingSpace().booleanValue()) {
                    while (SymbolsReplacer.endsWithBlank(before)) {
                        before = StringUtils.chop((String)before);
                        --index;
                    }
                }
                if (replaceBook.getBrailleAddTrailingSpace().booleanValue() && !SymbolsReplacer.startsWithBlank(after)) {
                    after = " ".concat(after);
                    ++index;
                }
                if (replaceBook.getBrailleRemoveTrailingSpace().booleanValue()) {
                    while (SymbolsReplacer.startsWithBlank(after)) {
                        after = after.substring(1);
                    }
                }
                target = StringUtils.join((Object[])new String[]{before, braille, after});
                index += braille.length() - 1;
                continue block5;
            }
        }
        return target;
    }

    private Replace determineReplace(String substring, Context context, ReplaceTarget replaceTarget) {
        String key = SymbolsReplacer.entirelyUppercaseOrLowercase(substring);
        Symbol symbol = null;
        switch (replaceTarget) {
            case book: {
                if (SymbolsReplacer.isUpperCase(key)) {
                    symbol = this.symbolsMap.get(key);
                    if (symbol != null) break;
                    symbol = this.symbolsMap.get(key.toLowerCase());
                    break;
                }
                symbol = this.symbolsMap.get(key);
                break;
            }
            case symbolsList: {
                if (SymbolsReplacer.isUpperCase(key)) {
                    symbol = this.symbolsMap.get(key.toLowerCase());
                    if (symbol != null) break;
                    symbol = this.symbolsMap.get(key);
                    break;
                }
                symbol = this.symbolsMap.get(key);
            }
        }
        if (symbol == null) {
            return null;
        }
        return symbol.getReplaces().stream().filter(r -> r.getContext() == context).findFirst().orElse(null);
    }

    public void replaceSymbols(Node node) {
        if (node.getNodeType() == 3) {
            String text = node.getTextContent();
            if (text != null && text.length() > 0) {
                Context context = this.determineContext(node);
                String replacement = this.replace(text, context);
                node.setTextContent(replacement);
            }
        } else {
            for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                this.replaceSymbols(childNode);
            }
        }
    }

    private Context determineContext(Node textNode) {
        String attributeValue;
        Node parentNode = textNode.getParentNode();
        if (parentNode != null && "dummy-formula".equals(attributeValue = ((Element)parentNode).getAttribute("class"))) {
            return Context.Formula;
        }
        return Context.Default;
    }

    public void insertSymbolsList(Document document, String header) {
        String headerWithSymbolsReplaced = this.replace(header, Context.Default);
        Element dtbook = document.getDocumentElement();
        Node book = Utils.getChild(dtbook, "book");
        if (book == null || this.getSymbolsListReplaces().isEmpty()) {
            return;
        }
        Node frontMatter = Utils.getChild(book, "frontmatter");
        if (frontMatter == null) {
            frontMatter = Utils.addChild(book, "frontmatter");
        }
        Element level1 = Utils.addChildBefore(frontMatter, frontMatter.getFirstChild(), "level1");
        level1.setAttribute("class", "symbols_list");
        Element pagenum = Utils.addChild(level1, "pagenum");
        pagenum.setAttribute("id", "page-symbolslist");
        if (StringUtils.isNotBlank((CharSequence)headerWithSymbolsReplaced)) {
            Element h1 = Utils.addChild(level1, "h1");
            h1.setTextContent(headerWithSymbolsReplaced);
        }
        Element list = Utils.addChild(level1, "list");
        list.setAttribute("type", "pl");
        this.getSymbolsListReplaces().stream().sorted((r1, r2) -> r1.getParent().getCharacter().compareTo(r2.getParent().getCharacter())).map(r -> String.format("\u283f%s\u00a0 %s", r.getBraille(), r.getDescription())).distinct().forEachOrdered(text -> {
            Element li = Utils.addChild(list, "li");
            li.setTextContent((String)text);
        });
    }

    private static boolean startsWithBlank(String s) {
        return StringUtils.length((CharSequence)s) > 0 && StringUtils.isBlank((CharSequence)StringUtils.left((String)s, (int)1));
    }

    private static boolean endsWithBlank(String s) {
        return StringUtils.length((CharSequence)s) > 0 && StringUtils.isBlank((CharSequence)StringUtils.right((String)s, (int)1));
    }

    private static String entirelyUppercaseOrLowercase(String symbol) {
        if (symbol == null) {
            return null;
        }
        return symbol.toUpperCase().equals(symbol) ? symbol : symbol.toLowerCase();
    }

    private static boolean isUpperCase(String entirelyUpperCaseOrLowercaseString) {
        if (entirelyUpperCaseOrLowercaseString == null) {
            return false;
        }
        return !entirelyUpperCaseOrLowercaseString.toLowerCase().equals(entirelyUpperCaseOrLowercaseString);
    }

    private static enum ReplaceTarget {
        book,
        symbolsList;

    }
}

