/*
 * Decompiled with CFR 0.152.
 */
package nl.dedicon.pipeline.braille.step;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.dedicon.pipeline.braille.step.Utils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JacketManager {
    public static final String[] JACKET_CLASSES = new String[]{"flap", "jacket_copy", "jacketcopy"};
    private static final String CLASS = "class";
    private static final String LEVEL1 = "level1";
    private static final String H1 = "h1";
    private static final String P = "p";
    private final List<Element> jackets = new ArrayList<Element>();

    public void collect(Document document) {
        String namespace = document.getDocumentElement().getNamespaceURI();
        NodeList level1List = document.getElementsByTagNameNS(namespace, LEVEL1);
        for (int i = 0; i < level1List.getLength(); ++i) {
            Element level1 = (Element)level1List.item(i);
            String classValue = level1.getAttribute(CLASS);
            if (!Arrays.asList(JACKET_CLASSES).contains(classValue)) continue;
            this.jackets.add(level1);
        }
    }

    public void setHeader(String header) {
        if (StringUtils.isBlank((CharSequence)header)) {
            return;
        }
        for (Element jacket : this.jackets) {
            Node headerNode = Utils.getChild(jacket, H1);
            if (headerNode != null) {
                Utils.renameNode(headerNode, P);
            }
            Element newHeaderNode = Utils.addChildBefore(jacket, jacket.getFirstChild(), H1);
            newHeaderNode.setTextContent(header);
        }
    }

    public void move(String moveLocation) {
        if (this.jackets.isEmpty()) {
            return;
        }
        Location location = Location.valueOf(moveLocation.toUpperCase());
        if (location == null) {
            throw new IllegalArgumentException("Cannot move jackets to location '" + moveLocation + "'");
        }
        Document document = this.jackets.get(0).getOwnerDocument();
        Element dtbook = document.getDocumentElement();
        Node book = Utils.getChild(dtbook, "book");
        if (book == null) {
            return;
        }
        switch (location) {
            case FRONT: {
                this.insertFront(this.jackets, book);
                break;
            }
            case REAR: {
                this.insertRear(this.jackets, book);
            }
        }
    }

    private void insertFront(List<Element> jackets, Node book) {
        Node frontMatter = Utils.getChild(book, "frontmatter");
        if (frontMatter == null) {
            frontMatter = Utils.addChild(book, "frontmatter");
        }
        Node refChild = frontMatter.getFirstChild();
        for (Element jacket : jackets) {
            frontMatter.insertBefore(jacket, refChild);
            refChild = jacket.getNextSibling();
        }
    }

    private void insertRear(List<Element> jackets, Node book) {
        Node rearMatter = Utils.getChild(book, "rearmatter");
        if (rearMatter == null) {
            rearMatter = Utils.addChild(book, "rearmatter");
        }
        for (Element jacket : jackets) {
            rearMatter.appendChild(jacket);
        }
    }

    private static enum Location {
        FRONT,
        REAR;

    }
}

