<p:declare-step xmlns:dedicon="http://www.dedicon.nl" xmlns:p="http://www.w3.org/ns/xproc" xmlns:px="http://www.daisy.org/ns/pipeline/xproc" xmlns:dtb="http://www.daisy.org/z3986/2005/dtbook/" xmlns:pef="http://www.daisy.org/ns/2008/pef" xmlns:c="http://www.w3.org/ns/xproc-step" type="dedicon:dtbook-to-pef" version="1.0" exclude-inline-prefixes="#all" name="main">

    <p:documentation xmlns="http://www.w3.org/1999/xhtml">
        <h1 px:role="name">DTBook to PEF (Dedicon)</h1>
        <p px:role="desc">Transforms a DTBook (DAISY 3 XML) document into a PEF.</p>
    </p:documentation>
    
    <p:input port="source" primary="true" px:name="source" px:media-type="application/x-dtbook+xml"><p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Input DTBook</h2>
        </p:documentation></p:input>
    
    <p:option name="stylesheet" select="'http://www.dedicon.nl/pipeline/modules/braille/default.scss'" required="false" px:type="xs:anyURI" px:sequence="true" px:separator=" " px:media-type="text/css application/xslt+xml"><p:documentation xmlns="http://www.w3.org/1999/xhtml"><h2 px:role="name">Style sheets</h2>
          <p px:role="desc" xml:space="preserve">A list of CSS/Sass style sheets to apply.

DEPRECATION WARNING: XSLT style sheets are also supported, but this feature might be removed in the
future. It is recommended to apply any XSLT style sheets during pre-processing of the document.

Must be a space separated list of URIs, absolute or relative to the input.

Style sheets specified through this option are called "[user style
sheets](https://www.w3.org/TR/CSS2/cascade.html#cascade)". Style sheets can also be attached to the
source document. These are referred to as "[author style
sheets](https://www.w3.org/TR/CSS2/cascade.html#cascade)". They can be linked (using an
['xml-stylesheet' processing instruction](https://www.w3.org/TR/xml-stylesheet) or a ['link'
element](https://www.w3.org/Style/styling-XML#External)), embedded (using a ['style'
element](https://www.w3.org/Style/styling-XML#Embedded)) and/or inlined (using '[style'
attributes](https://www.w3.org/TR/css-style-attr/)).

Style sheets are applied to the document in the following way: XSLT style sheets are applied before
CSS/Sass style sheets. XSLT style sheets are applied one by one, first the user style sheets, then
the author style sheets, in the order in which they are specified.

All CSS/Sass style sheets are applied at once, but the order in which they are specified (first user
style sheets, then author style sheets) has an influence on the [cascading
order](https://www.w3.org/TR/CSS2/cascade.html#cascading-order).

CSS/Sass style sheets are interpreted according to [braille
CSS](http://braillespecs.github.io/braille-css) rules.

For info on how to use Sass (Syntactically Awesome StyleSheets) see the [Sass
manual](http://sass-lang.com/documentation/file.SASS_REFERENCE.html).



A number of [partials](https://sass-lang.com/documentation/at-rules/import#partials) (helper style
sheet modules) are available for use in Sass style sheets:

- [http://www.daisy.org/pipeline/modules/braille/dtbook-to-pef/_tables.scss](http://daisy.github.io/pipeline/modules/braille/dtbook-to-pef/src/main/resources/css/tables):
  for styling tables
- [http://www.daisy.org/pipeline/modules/braille/dtbook-to-pef/_definition-lists.scss](http://daisy.github.io/pipeline/modules/braille/dtbook-to-pef/src/main/resources/css/definition-lists):
  for styling definition lists
</p>
        </p:documentation></p:option>
    <p:option name="include-preview" select="'true'" required="false" px:type="boolean"><p:documentation xmlns="http://www.w3.org/1999/xhtml">
			<h2 px:role="name">Include preview</h2>
			<p px:role="desc" xml:space="preserve">Whether or not to include a HTML preview of the braille result.</p>
		</p:documentation></p:option>
    <p:option name="include-brf" select="'true'"/>
    <p:option name="include-metadata" required="false" px:type="boolean" select="'true'">
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Include metadata file</h2>
        </p:documentation>
    </p:option>
    <p:option name="metadata-date" select="''"/>
    <p:option name="include-obfl" select="'false'" required="false" px:type="boolean"><p:documentation>
			<h2 px:role="name">Include OBFL</h2>
			<p px:role="desc" xml:space="preserve">Whether or not the keep the intermediary OBFL file (for debugging).</p>
		</p:documentation></p:option>
    <!--
        These options have been disabled because of a bug in pipeline-webui.
        It seems impossible to enter a valid query string in pipeline-webui.
        See variable file-format below.
    -->
    <!--<p:option name="ascii-file-format" select="'(table:&quot;com_braillo.BrailloTableProvider.TableType.BRAILLO_6DOT_031_01&quot;)(line-breaks:dos)(pad:both)(charset:&quot;IBM00858&quot;)(file-extension:&quot;.brl&quot;)'"/>-->
    <!--<p:option name="ascii-table"/>-->
    <p:option name="add-boilerplate" required="false" px:type="boolean" select="'true'">
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Add boilerplate text</h2>
            <p px:role="desc">When enabled, and when the input has a `docauthor` element, will insert boilerplate text such as a title page.</p>
        </p:documentation>
    </p:option>
    <p:option name="page-width" select="'-1'" required="false" px:type="integer">
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Page layout: Page width

</h2>
            <p px:role="desc" xml:space="preserve">The number of columns available for printing.

Sets the default page width (this can be overwritten with `@page` rules), affects media queries that
use the 'width' feature, and makes the variable `$page-width` available in style sheets.

See the CSS specification for more info:

- the [`@page`](http://braillespecs.github.io/braille-css/#h4_the-page-rule) rule
- the [`size`](http://braillespecs.github.io/braille-css/#the-size-property) property
- the [page dimensions media features](https://www.w3.org/TR/mediaqueries-4/#mf-dimensions)


Use `-1` to compute this from metadata.</p>
        </p:documentation>
    </p:option>
    <p:option name="page-height" select="'-1'" required="false" px:type="integer">
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Page layout: Page height

</h2>
            <p px:role="desc" xml:space="preserve">The number of rows available for printing.

Sets the default page height (this can be overwritten with `@page` rules), affects media queries
that use the 'height' feature, and makes the variable `$page-height` available in style sheets.

See the CSS specification for more info:

- the [`@page`](http://braillespecs.github.io/braille-css/#h4_the-page-rule) rule
- the [`size`](http://braillespecs.github.io/braille-css/#the-size-property) property
- the [page dimensions media features](https://www.w3.org/TR/mediaqueries-4/#mf-dimensions)


Use `-1` to compute this from metadata.</p>
        </p:documentation>
    </p:option>
    <p:option xmlns:pxd="http://www.daisy.org/ns/pipeline/xproc" name="printing" select="'duplex'" pxd:type="dedicon:dtbook-to-pef-printing">
        <!--
            This option must be recorded in the POM under properties > expose-services
            as org.daisy.pipeline.datatypes.impl.Datatype_dedicon_dtbook_to_pef_printing
        -->
        <!-- @todo 
            In case of 'simplex-form-feeds', the PEF should be modified such that every section with an odd number of pages gets an extra empty page
        -->
        
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Page layout: Printing</h2>
            <p px:role="desc" xml:space="preserve">Option `Simplex with extra form feeds` adds extra form feeds to the braille files to enforce single sided printing.</p>
        </p:documentation>
    </p:option>
    <p:option xmlns:pxd="http://www.daisy.org/ns/pipeline/xproc" name="hyphenation" select="'from-meta'" required="false" pxd:type="dedicon:dtbook-to-pef-hyphenation"><p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Translation/formatting of text: Hyphenation</h2>
            <p px:role="desc" xml:space="preserve">Hyphenation policy.

Makes the variable `$hyphenation` available in style sheets and includes the following rule by
default:

~~~sass
:root {
  hyphens: $hyphenation;
}
~~~

This means that words are hyphenated according to the specified policy, except where overridden by
more specific CSS rules. See the CSS specification for more info:

- the [`hyphens`](http://braillespecs.github.io/braille-css/#the-hyphens-property) property

In addition, special rules may apply at page boundaries, see the "Hyphenation at page boundaries"
option.
</p>
        </p:documentation>
        <!--
            This option must be recorded in the POM under properties > expose-services
            as org.daisy.pipeline.datatypes.impl.Datatype_dedicon_dtbook_to_pef_hyphenation
        -->
        
    </p:option>
    <p:option xmlns:pxd="http://www.daisy.org/ns/pipeline/xproc" name="line-spacing" select="'single'" required="false" pxd:type="px:dtbook-to-pef.script-line-spacing"><p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Translation/formatting of text: Line spacing</h2>
            <p px:role="desc" xml:space="preserve">Single or double line spacing.

Makes the variable `$line-spacing` available in style sheets and includes the following rule by
default:

~~~sass
@if $line-spacing == double {
  :root {
    line-height: 2;
  }
}
~~~

See the CSS specification for more info:

- the [`line-height`](http://braillespecs.github.io/braille-css/#h3_the-line-height-property)
  property
</p>
        </p:documentation></p:option>
    <p:option name="capital-letters" select="'true'" required="false" px:type="boolean"><p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Translation/formatting of text: Capital letters</h2>
            <p px:role="desc" xml:space="preserve">When enabled, will indicate capital letters.

Makes the variable `$capital-letters` available in style sheets and includes the following rule by
default:

~~~sass
@if $capital-letters != true {
  :root {
    text-transform: lowercase;
  }
}
~~~</p>
        </p:documentation></p:option>
    <p:option name="include-captions" select="'true'" required="false" px:type="boolean"><p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Block elements: Include captions</h2>
            <p px:role="desc" xml:space="preserve">When enabled, will include captions for images, tables, and so on.

Makes the variable `$include-captions` available in style sheets and includes the following rule by
default:

~~~sass
caption {
  display: if($include-captions, block, none);
}
~~~</p>
        </p:documentation></p:option>
    <p:option name="include-images" select="'false'" required="false" px:type="boolean"><p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Block elements: Include images</h2>
            <p px:role="desc" xml:space="preserve">When enabled, will include the alt text of the images. When disabled, the images will be completely removed.

Makes the variable `$include-images` available in style sheets and includes the following rule by
default:

~~~sass
@if $include-images {
  img::after {
    content: attr(alt);
  }
}
~~~</p>
        </p:documentation></p:option> <!-- displays the alt text -->
    <p:option name="include-image-groups" select="'true'"/>
    <p:option name="include-line-groups" select="'true'" required="false" px:type="boolean"><p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Block elements: Include line groups</h2>
            <p px:role="desc" xml:space="preserve">When disabled, lines in a linegroup are joined together to form one block.

Makes the variable `$include-line-groups` available in style sheets and includes the following rule
by default:

~~~sass
linegroup line {
  display: if($include-line-groups, block, inline);
}
~~~</p>
        </p:documentation></p:option>
    <p:option name="include-production-notes" select="'true'" required="false" px:type="boolean"><p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Inline elements: Include production notes</h2>
            <p px:role="desc" xml:space="preserve">When enabled, production notes are included in the content.

Makes the variable `$include-production-notes` available in style sheets and includes the following
rule by default:

~~~sass
prodnote {
  display: if($include-production-notes, block, none);
}
~~~</p>
        </p:documentation></p:option>
    <p:option name="show-braille-page-numbers" select="'true'" required="false" px:type="boolean"><p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Page numbers: Show braille page numbers</h2>
            <p px:role="desc" xml:space="preserve">When enabled, will number braille pages.

Makes the variable `$show-braille-page-numbers` available in style sheets. In order to use the
variable include a rule like the following in your custom style sheet:

~~~sass
@if $show-braille-page-numbers {
  @page {
    @top-right {
      content: counter(page);
    }
  }
}
~~~

This will create a page number in the top right corner of every braille page.

See the CSS specification for more info:

- the [`@page`](http://braillespecs.github.io/braille-css/#h4_the-page-rule) rule
- the
  [`counter()`](http://braillespecs.github.io/braille-css/#printing-counters-the-counter-function)
  function
</p>
        </p:documentation></p:option>
    <p:option name="show-print-page-numbers" select="'true'" required="false" px:type="boolean"><p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Page numbers: Show print page numbers</h2>
            <p px:role="desc" xml:space="preserve">When enabled, will indicate original page numbers.

Makes the variable `$show-print-page-numbers` available in style sheets and includes the following
rule by default:

~~~sass
@if $show-print-page-numbers {
  pagenum {
    string-set: print-page content();
  }
}
~~~

In order to use the `print-page` string include a rule like the following in your custom style
sheet:

~~~css
@page {
  @bottom-right {
    content: string(print-page);
  }
}
~~~

See the CSS specification for more info:

- the [`string-set`](http://braillespecs.github.io/braille-css/#h4_the-string-set-property) property
- the [`@page`](http://braillespecs.github.io/braille-css/#h4_the-page-rule) rule
- the [`string()`](http://braillespecs.github.io/braille-css/#h4_the-string-function) function
</p>
        </p:documentation></p:option>
    <p:option xmlns:pxd="http://www.daisy.org/ns/pipeline/xproc" name="show-inline-print-page-numbers" select="'from-meta'" pxd:type="dedicon:dtbook-to-pef-show-inline-print-page-numbers">
        <!--
            This option must be recorded in the POM under properties > expose-services
            as org.daisy.pipeline.datatypes.impl.Datatype_dedicon_dtbook_to_pef_show_inline_print_page_numbers
        -->
        
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Page numbers: Show inline print page numbers</h2>
        </p:documentation>
    </p:option>
    <p:option name="force-braille-page-break" select="'false'" required="false" px:type="boolean"><p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Page numbers: Force braille page break</h2>
            <p px:role="desc" xml:space="preserve">Force braille page breaks at print page breaks.

Makes the variable `$force-braille-page-break` available in style sheets and includes the following
rule by default:

~~~sass
@if $force-braille-page-break {
  pagenum {
    page-break-before: always;
  }
}
~~~

See the CSS specification for more info:

- the [`page-break-before`](http://braillespecs.github.io/braille-css/#h4_controlling-page-breaks)
  property
</p>
        </p:documentation></p:option>
    <p:option name="toc-depth" select="'6'" required="false" px:type="integer"><p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Table of contents: Table of contents depth</h2>
            <p px:role="desc" xml:space="preserve">The depth of the table of contents hierarchy to include. '0' means no table of contents.

A table of contents will be generated from the heading elements present in the document: from `h1`
elements if the specified value for the depth is 1, from `h1` and `h2` elements if the specified
value is 2, etc. The resulting table of contents has the following nested structure:

~~~xml
&lt;list id="generated-document-toc"&gt;
  &lt;li&gt;
      &lt;a href="#ch_1" title="Chapter 1"&gt;Chapter 1&lt;/a&gt;
      &lt;list&gt;
          &lt;li&gt;
              &lt;a href="#ch_1_1" title="1.1"&gt;1.1&lt;/a&gt;
              ...
          &lt;/li&gt;
          &lt;li&gt;
              &lt;a href="#ch_1_2" title="1.2"&gt;1.2&lt;/a&gt;
              ...
          &lt;/li&gt;
          ...
      &lt;/list&gt;
  &lt;/li&gt;
  ...
&lt;/list&gt;
~~~

Another one of these is generated but with ID `generated-volume-toc`. `ch_1`, `ch_1_2` etc. are the
IDs of the heading elements from which the list was constructed, and the content of the links are
exact copies of the content of the heading elements. By default the lists are not rendered. The
lists should be styled and positioned with CSS. The following rules are included by default:

~~~css
#generated-document-toc {
  flow: document-toc;
  display: -obfl-toc;
  -obfl-toc-range: document;
}

#generated-volume-toc {
  flow: volume-toc;
  display: -obfl-toc;
  -obfl-toc-range: volume;
}
~~~

This means that a document range table of contents is added to the named flow called "document-toc",
and a volume range table of contents is added to the named flow called "volume-toc". In order to
consume these named flows use the function `flow()`. For example, to position the document range
table of contents at the beginning of the first volume, and to repeat the volume range table of
content at the beginning of every other volume, include the following additional rules:

~~~css
@volume {
  @begin {
    content: flow(volume-toc, document);
  }
}

@volume:first {
  @begin {
    content: flow(document-toc, document);
  }
}
~~~

By default, the table of contents is styled as a normal unordered list, only including the text of
the headings. Including the braille page numbers of the headings can be done using the
`target-counter` function. For example, to place the page number after the heading title, with a
space in between:

~~~css
#generated-document-toc li &gt; a,
#generated-volume-toc li &gt; a {
  content: ' ' target-counter(attr(href), page);
}
~~~

Note that there is only a single "depth" setting for both lists. If you wish to include less levels
of headings in the document TOC, you have to achieve it through CSS styling. For example, to get
only one level of headings in the document TOC, make all nested `list` elements invisible:

~~~css
#generated-document-toc &gt; li &gt; list {
  display: none;
}
~~~

See the CSS specification for more info:

- the [`display:
  -obfl-toc`](http://braillespecs.github.io/braille-css/obfl#extending-the-display-property-with--obfl-toc)
  value
- the [`flow`](http://braillespecs.github.io/braille-css/#the-flow-property) property
- the [`flow()`](http://braillespecs.github.io/braille-css/#h4_the-flow-function) function
- the [`@volume`](http://braillespecs.github.io/braille-css/#h3_the-volume-rule) rule
- the [`@begin`](http://braillespecs.github.io/braille-css/#h3_the-begin-and-end-rules) rule
- the [`target-counter()`](http://braillespecs.github.io/braille-css/#h4_the-target-counter-function) function
- the [`page`](http://braillespecs.github.io/braille-css/#h4_creating-and-inheriting-counters) counter
</p>
        </p:documentation></p:option>
    <p:option name="include-document-toc-in-last-volume" required="false" px:type="boolean" select="'true'">
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Table of contents: Include document TOC</h2>
            <p px:role="desc" xml:space="preserve">Whether or not to include a document-level TOC in the last volume.</p>
        </p:documentation>
    </p:option>
    <p:option name="include-print-toc" required="false" px:type="boolean" select="'true'">
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Table of contents: Include print TOC</h2>
            <p px:role="desc" xml:space="preserve">Whether or not to include a print TOC.</p>
        </p:documentation>
    </p:option>
    <p:option name="include-symbols-list" required="false" px:type="boolean" select="'true'">
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Include symbols list</h2>
            <p px:role="desc" xml:space="preserve">When enabled, a list of symbols and their descriptions is included in the first volume.</p>
        </p:documentation>
    </p:option>
    <p:option name="symbols-code" select="''">
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Symbols list location</h2>
            <p px:role="desc" xml:space="preserve">When empty, the default symbols list will be used.</p>
        </p:documentation>
    </p:option>
    <p:option name="symbols-list-header" required="false" px:type="string" select="'Symbolenlijst'">
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Symbols list header</h2>
        </p:documentation>
    </p:option>
    <p:option name="jacket-header" required="false" px:type="string" select="'(default)'">
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Volumes: Jacket header</h2>
            <p px:role="desc" xml:space="preserve">Header of the print cover.

If `(default)` then the value is computed from meta-data:
For non-educational books 'Flaptekst' will be used and for educational books no jacket header will be applied.
</p>
        </p:documentation>
    </p:option>
    <p:option xmlns:pxd="http://www.daisy.org/ns/pipeline/xproc" name="move-print-cover" required="false" select="'from-meta'" pxd:type="dedicon:dtbook-to-pef-move-print-cover">
        <!--
            This option must be recorded in the POM under properties > expose-services
            as org.daisy.pipeline.datatypes.impl.Datatype_dedicon_dtbook_to_pef_move_print_cover
        -->
        
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Volumes: Move print cover</h2>
            <p px:role="desc" xml:space="preserve">Location to which the jacket will be moved.

When the input has a `level1` element with class `flap`, `jacket_copy` or `jacketcopy`, will move that cover to the indicated location.
In case this is computed from meta-data: If it is an educational book, the cover will be moved to the rear, otherwise to the front.
</p>
        </p:documentation>
    </p:option>
    <p:option xmlns:pxd="http://www.daisy.org/ns/pipeline/xproc" name="move-print-colophon-to-last-volume" required="false" select="'from-meta'" pxd:type="dedicon:dtbook-to-pef-move-print-colophon-to-last-volume">
        <!--
            This option must be recorded in the POM under properties > expose-services
            as org.daisy.pipeline.datatypes.impl.Datatype_dedicon_dtbook_to_pef_move_print_colophon_to_last_volume
        -->
        
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Volumes: Move print colophon to last volume</h2>
            <p px:role="desc">When enabled, and when the input has a `level1` element with class `colophon`, will move that colophon to the last volume.</p>
        </p:documentation>
    </p:option>
    <p:option name="maximum-number-of-sheets" select="'-1'" required="false" px:type="integer">
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Volumes: Maximum number of sheets

</h2>
            <p px:role="desc" xml:space="preserve">The maximum number of sheets in a volume.

Makes the variable `$maximum-number-of-sheets` available in style sheets and includes the following
rule by default:

~~~sass
@volume {
  max-length: $maximum-number-of-sheets;
}
~~~

See the CSS specification for more info:

- the [`@volume`](http://braillespecs.github.io/braille-css/#h3_the-volume-rule) rule
- the [`max-length`](http://braillespecs.github.io/braille-css/#h3_the-length-properties) property


Use `-1` to compute this from metadata.</p>
        </p:documentation>
    </p:option>
    <p:option name="volume-back-cover-empty" required="false" px:type="boolean" select="'true'">
        <p:documentation xmlns="http://www.w3.org/1999/xhtml">
            <h2 px:role="name">Volumes: The back cover must be empty</h2>
            <p px:role="desc" xml:space="preserve">Applies to duplex printing. When enabled, the last page of a printed volume will contain no text and can have pits only. If the number of pages of a volume is a 4-fold and the last page is not empty, an extra page will be appended.</p>
        </p:documentation>
    </p:option>
    <p:option name="pef-output-dir" required="false" px:output="result" px:type="anyDirURI" px:media-type="application/x-pef+xml" select="''"><p:documentation xmlns="http://www.w3.org/1999/xhtml">
			<h2 px:role="name">PEF</h2>
			<p px:role="desc">The intermediary PEF file.</p>
		</p:documentation></p:option>
    <p:option name="output-dir" required="false" select="''" px:output="result" px:type="anyDirURI" px:media-type="text"><p:documentation xmlns="http://www.w3.org/1999/xhtml">
			<h2 px:role="name">Output file</h2>
			<p px:role="desc">The output braille file.</p>
		</p:documentation></p:option>
    <p:option name="preview-output-dir" select="''" required="false" px:output="result" px:type="anyDirURI" px:media-type="text/html"><p:documentation xmlns="http://www.w3.org/1999/xhtml">
			<h2 px:role="name">Preview</h2>
			<p px:role="desc">An HTML preview of the braille result.</p>
		</p:documentation></p:option>
    <p:option name="temp-dir" required="false" select="''" px:output="temp" px:type="anyDirURI"/>
    
    <p:variable name="file-format" px:type="string" select="'(table:&#34;com_braillo.BrailloTableProvider.TableType.BRAILLO_6DOT_031_01&#34;)(line-breaks:dos)(pad:both)(charset:&#34;IBM00858&#34;)(file-extension:&#34;.brl&#34;)'"/>
    <p:variable name="actual-page-width" select="         if ($page-width = '-1')         then if (//dtb:meta[@name='prod:docType']/@content='ro') then 28              else if (//dtb:meta[@name='prod:docType']/@content='sv') then 33              else 28         else xs:integer($page-width)     "/>
    <p:variable name="actual-page-height" select="         if ($page-height='-1')         then if (//dtb:meta[@name='prod:docType']/@content='ro') then 26              else if (//dtb:meta[@name='prod:docType']/@content='sv') then 27 else 26         else xs:integer($page-height)     "/>
    <p:variable name="actual-jacket-header" select="         if ($jacket-header = '(default)')         then if (//dtb:meta[@name='prod:docType']/@content='sv') then ''              else 'Flaptekst'         else $jacket-header     "/>
    <p:variable name="actual-move-print-cover" select="         if ($move-print-cover = 'from-meta')         then if (//dtb:meta[@name='prod:docType']/@content='sv') then 'rear'              else 'front'         else $move-print-cover     "/>
    <!--
        The footer of the title page must be positioned at the bottom of the page.
        The code below uses that this footer consists of two lines of text.
        See generate-boilerplate.xsl, div id="generated-title-page-footer"
    -->
    <p:variable name="vertical-position-title-page-footer" select="         let $title-page-footer-height := 2         return $actual-page-height - $title-page-footer-height         - ($title-page-footer-height - 1) * xs:integer($line-spacing = 'double')         - xs:integer(xs:boolean($show-print-page-numbers) or xs:boolean($show-braille-page-numbers))     "/>
    <!--
        Workaround for issue https://dedicon.atlassian.net/browse/PIP-151
        Currently, it is not possible to remove a resumed entry from the TOC
        if there is a <level1> without a <h1>. So we disable the resumed
        functionality in the TOC if the body has a <level1> without <h1>.
    -->
    <p:variable name="use-resumed-functionality-in-toc" px:type="boolean" select="empty(//dtb:bodymatter/dtb:level1[not(dtb:h1)])"/>
    
    <p:import href="http://www.daisy.org/pipeline/modules/braille/dtbook-to-pef/library.xpl"/>
    <p:import href="http://www.daisy.org/pipeline/modules/braille/common-utils/library.xpl"/>
    <p:import href="http://www.daisy.org/pipeline/modules/braille/pef-utils/library.xpl"/>
    <p:import href="http://www.daisy.org/pipeline/modules/file-utils/library.xpl"/>
    <p:import href="http://www.daisy.org/pipeline/modules/common-utils/library.xpl"/>
    <p:import href="http://www.daisy.org/pipeline/modules/dtbook-utils/library.xpl"/>
    <p:import href="http://www.dedicon.nl/pipeline/modules/braille/library.xpl"/>

    <p:in-scope-names name="in-scope-names"/>
    <px:merge-parameters>
        <p:input port="source">
            <p:pipe port="result" step="in-scope-names"/>
        </p:input>
    </px:merge-parameters>
    <px:delete-parameters parameter-names="stylesheet                                     symbols-code                                     ascii-table                                     include-brf                                     include-preview                                     include-obfl                                     pef-output-dir                                     output-dir                                     preview-output-dir                                     temp-dir"/>
    <px:add-parameters>

      <p:with-param name="toc-exclude-class" select="''"/>

      <p:with-param name="skip-margin-top-of-page" select="true()"/>
      <p:with-param name="page-width" select="string($actual-page-width)">
        <p:pipe step="main" port="source"/>
      </p:with-param>
      <p:with-param name="page-height" select="string($actual-page-height)">
        <p:pipe step="main" port="source"/>
      </p:with-param>
	  <p:with-param name="maximum-number-of-sheets" select="if ($maximum-number-of-sheets='-1')                                then if (//dtb:meta[@name='prod:docType']/@content='ro') then '35'                                     else if (//dtb:meta[@name='prod:docType']/@content='sv') then '37' else '35'                                else $maximum-number-of-sheets">
        <p:pipe step="main" port="source"/>
      </p:with-param>
      <p:with-param name="hyphenation" select="if ($hyphenation='from-meta')                                then if ((//dtb:meta[@name='prod:docHyphenate']/@content,'Y')[1]='Y')                                     then 'auto'                                     else 'manual'                                else $hyphenation">
        <p:pipe step="main" port="source"/>
      </p:with-param>
      <p:with-param name="show-inline-print-page-numbers" select="if ($show-inline-print-page-numbers='from-meta')                                then //dtb:meta[@name='prod:docType']/@content='sv'                                else $show-inline-print-page-numbers='true'">
        <p:pipe step="main" port="source"/>
      </p:with-param>
      <p:with-param name="include-document-toc-in-last-volume" select="$include-document-toc-in-last-volume='true'">
        <p:pipe step="main" port="source"/>
      </p:with-param>
      <p:with-param name="move-print-colophon-to-last-volume" select="if ($move-print-colophon-to-last-volume='from-meta')                                then //dtb:meta[@name='prod:docType']/@content='sv'                                else $move-print-colophon-to-last-volume='true'">
        <p:pipe step="main" port="source"/>
      </p:with-param>
      <p:with-param name="duplex" select="$printing='duplex'">
        <p:pipe step="main" port="source"/>
      </p:with-param>
      <p:with-param name="ascii-file-format" select="$file-format">
        <p:pipe step="main" port="source"/>
      </p:with-param>
      <p:with-param name="allow-volume-break-inside-leaf-section-factor" select="'9'"/>
      <p:with-param name="prefer-volume-break-before-higher-level-factor" select="'0'"/>
      <p:with-param name="notes-placement" select="'custom'"/>
    </px:add-parameters>
    <p:identity name="input-options"/>
    <p:sink/>
    
    <!-- =============== -->
    <!-- CREATE TEMP DIR -->
    <!-- =============== -->
    <px:tempdir name="temp-dir">
        <p:with-option name="href" select="if ($temp-dir!='') then $temp-dir else $pef-output-dir"/>
    </px:tempdir>
    <p:sink/>
    
    <!-- ==================== -->
    <!-- DTBOOK PREPROCESSING -->
    <!-- ==================== -->
    <dedicon:message reset="true" message="Start Dedicon pre-processing">
        <p:input port="source">
            <p:pipe step="main" port="source"/>
        </p:input>
    </dedicon:message>
    <dedicon:message message="Applying emphasis"/>
    <dedicon:emphasis/>
    <dedicon:message message="Applying processing instructions"/>
    <dedicon:processing-instructions/>
    <p:choose>
        <p:when test="$include-print-toc = 'false'">
            <dedicon:message message="Removing print TOC"/>
            <dedicon:remove-print-toc/>
        </p:when>
        <p:otherwise>
            <dedicon:message severity="TRACE" message="Keeping print TOC"/>
        </p:otherwise>
    </p:choose>
    <dedicon:message message="Applying fix for backslashes in attribute src"/>
    <dedicon:src-backslash-fix/>
    <!--    
    <dedicon:message message="Flattening sidebars"/>
    <dedicon:flatten-sidebars/>
    -->
    <dedicon:message message="Moving notes after their noteref"/>
    <dedicon:move-notes/>
    <p:choose>
        <p:when test="$add-boilerplate='true'">
            <dedicon:message message="Adding boilerplate"/>
            <dedicon:add-boilerplate>
                <p:input port="parameters">
                    <p:pipe step="input-options" port="result"/>
                </p:input>
            </dedicon:add-boilerplate>
        </p:when>
        <p:otherwise>
             <dedicon:message severity="TRACE" message="Skipping boilerplate"/>
        </p:otherwise>
    </p:choose>
    <p:choose>
        <p:when test="$actual-move-print-cover != 'no'">
            <dedicon:message message="Managing jacket"/>
            <dedicon:jacket>
                <p:with-option name="jacket-header" select="$actual-jacket-header"/>
                <p:with-option name="move-print-cover" select="$actual-move-print-cover"/>
            </dedicon:jacket>
        </p:when>
        <p:otherwise>
            <dedicon:message severity="TRACE" message="Skipping jacket"/>
        </p:otherwise>
    </p:choose>
    <p:choose>
        <p:when test="$include-symbols-list='true'">
            <dedicon:message message="Including symbols list"/>
            <dedicon:symbols-list>
                <p:with-option name="symbols-code" select="$symbols-code"/>
                <p:with-option name="symbols-code-default" select="'http://www.dedicon.nl/pipeline/modules/braille/symbols_code.xml'"/>
                <p:with-option name="symbols-list-header" select="$symbols-list-header"/>
            </dedicon:symbols-list>
        </p:when>
        <p:otherwise>
            <dedicon:message severity="TRACE" message="Skipping symbols list"/>
        </p:otherwise>
    </p:choose>
    <dedicon:message message="End Dedicon pre-processing"/>
    
    <!--
        FIXME: The pre-processing steps above set the base URI to a temporary file either (or the
        empty string if `useFile` would be set to false), which for some reason makes the conversion
        fail further down in the process. Setting the base URI to this dummy string works around the
        issue, but is not such a nice solution. Better would be make the pre-processing steps
        preserve the base URI of the input document.
    -->
    <px:set-base-uri base-uri="file:/irrelevant.xml"/>
        
    <!-- ============= -->
    <!-- DTBOOK TO PEF -->
    <!-- ============= -->
    <px:dtbook-load name="load"/>
    
    <px:dtbook-to-pef transform="(formatter:dotify)(type:literary)(dots-for-undefined-char:'⠢')" name="convert">
        <p:input port="source.in-memory">
            <p:pipe step="load" port="result.in-memory"/>
        </p:input>
        <p:with-option name="temp-dir" select="string(/c:result)">
            <p:pipe step="temp-dir" port="result"/>
        </p:with-option>
        <p:with-option name="stylesheet" select="$stylesheet"/>
        <p:with-option name="include-obfl" select="$include-obfl"/>
        <p:input port="parameters">
            <p:pipe port="result" step="input-options"/>
        </p:input>
    </px:dtbook-to-pef>
    
    <p:group>
        <p:variable name="identifier" select="//dtb:meta[@name='dc:Identifier']/@content">
            <p:pipe step="main" port="source"/>
        </p:variable>
        <p:variable name="name" select="if ($identifier) then $identifier                                         else replace(p:base-uri(/),'^.*/([^/]*)\.[^/\.]*$','$1')">
            <p:pipe step="main" port="source"/>
        </p:variable>
        <p:variable name="title" select="//dtb:meta[@name='dc:Title']/@content">
            <p:pipe step="main" port="source"/>
        </p:variable>
        
        <p:for-each>
            <!-- Make sure the PEF ends with an EMPTY BACK COVER -->
            <p:choose>
                <p:when test="$volume-back-cover-empty='true'">
                    <dedicon:message message="Volume back cover will be empty"/>
                    <dedicon:empty-back-cover>
                        <p:with-option name="xquery" select="resolve-uri('../../xquery/empty-back-cover.xql')"/>
                    </dedicon:empty-back-cover>
                </p:when>
                <p:otherwise>
                    <dedicon:message severity="TRACE" message="Skipping ''volume back cover will be empty''"/>
                </p:otherwise>
            </p:choose>

            <p:identity name="pef"/>

            <!-- ===== -->
            <!-- STORE -->
            <!-- ===== -->
            <p:group>
                <p:variable name="preview-href" select="                     if ($include-preview='true' and $preview-output-dir!='')                     then concat($preview-output-dir,'/',$name,'.pef.html')                     else ''                 "/>
                <!--<p:variable name="brf-file-format" select="$ascii-file-format"/>-->
                <p:variable name="brf-file-format" select="$file-format"/>
                <p:variable name="brf-name-pattern" select="concat('p',$name,'_{}')"/>
                <p:variable name="brf-number-width" select="3"/>
                <p:variable name="brf-dir-href" select="                     if ($include-brf='true')                     then                         if ($output-dir!='')                         then $output-dir                         else                             if ($pef-output-dir!='')                             then $pef-output-dir                             else ''                     else ''                 "/>

                <!-- Store PEF, BRLs -->
                <px:pef-store>
                    <p:with-option name="pef-href" select="concat($pef-output-dir,'/',$name,'.pef')"/>
                    <p:with-option name="preview-href" select="$preview-href"/>
                    <!-- <p:with-option name="preview-table" select="if ($ascii-table!='') then $ascii-table
                                                            else concat('(locale:',(/*/@xml:lang,'und')[1],')')"/> -->
                    <p:with-option name="output-dir" select="$brf-dir-href"/>
                    <p:with-option name="file-format" select="$brf-file-format"/>
                    <p:with-option name="name-pattern" select="$brf-name-pattern"/>
                    <p:with-option name="number-width" select="$brf-number-width"/>
                </px:pef-store>

                <!-- Make sure each BRL starts with a NEWLINE -->
                <dedicon:message message="Inserting newline in BRL files">
                    <p:input port="source">
                        <p:pipe port="result" step="pef"/>
                    </p:input>
                </dedicon:message>
                <dedicon:brl-uris name="brl-uris">
                    <p:with-option name="xquery" select="resolve-uri('../../xquery/brl-uris.xql')"/>
                    <p:with-option name="brf-dir-href" select="$brf-dir-href"/>
                    <p:with-option name="brf-file-format" select="$brf-file-format"/>
                    <p:with-option name="brf-name-pattern" select="$brf-name-pattern"/>
                    <p:with-option name="brf-number-width" select="$brf-number-width"/>
                </dedicon:brl-uris>
                <p:for-each>
                    <dedicon:brl-must-start-with-newline>
                        <p:with-option name="brl-uri" select="."/>
                    </dedicon:brl-must-start-with-newline>
                </p:for-each>

                <!-- Replace DOUBLE FORM FEEDS in BRL -->
                <p:choose>
                    <p:when test="$printing='simplex'">
                        <dedicon:message message="Replacing double form feeds in BRL files">
                            <p:input port="source">
                                <p:empty/>
                            </p:input>
                        </dedicon:message>
                        <p:for-each>
                            <p:iteration-source>
                                <p:pipe step="brl-uris" port="result"/>
                            </p:iteration-source>
                            <dedicon:brl-replace-double-form-feeds>
                                <p:with-option name="brl-uri" select="."/>
                            </dedicon:brl-replace-double-form-feeds>
                        </p:for-each>
                    </p:when>
                    <p:otherwise>
                        <p:sink>
                            <p:input port="source">
                                <p:empty/>
                            </p:input>
                        </p:sink>
                    </p:otherwise>
                </p:choose>

                <!-- Store METADATA -->
                <p:choose>
                    <p:when test="$include-metadata='true'">
                        <dedicon:message message="Storing metadata">
                            <p:input port="source">
                                <p:pipe port="result" step="pef"/>
                            </p:input>
                        </dedicon:message>
                        <dedicon:metadata>
                            <p:with-option name="xquery" select="resolve-uri('../../xquery/metadata.xql')"/>
                            <p:with-option name="identifier" select="$identifier"/>
                            <p:with-option name="brf-file-format" select="$brf-file-format"/>
                            <p:with-option name="brf-name-pattern" select="$brf-name-pattern"/>
                            <p:with-option name="brf-number-width" select="$brf-number-width"/>
                            <p:with-option name="optional-date" select="$metadata-date"/>
                        </dedicon:metadata>
                        <p:store>
                            <p:with-option name="href" select="concat($pef-output-dir, '/m', $name, '_001.xml')"/>
                        </p:store>
                    </p:when>
                    <p:otherwise>
                        <dedicon:message severity="TRACE" message="Skipping metadata">
                            <p:input port="source">
                                <p:empty/>
                            </p:input>
                        </dedicon:message>
                        <p:sink/>
                    </p:otherwise>
                </p:choose>

                <!-- Modify PREVIEW -->
                <p:choose>
                    <p:when test="$preview-href != ''">
                        <dedicon:message message="Modifying preview">
                            <p:input port="source">
                                <p:empty/>
                            </p:input>
                        </dedicon:message>
                        <dedicon:modify-preview>
                            <p:with-option name="preview-uri" select="$preview-href"/>
                        </dedicon:modify-preview>
                    </p:when>
                    <p:otherwise>
                        <p:sink>
                            <p:input port="source">
                                <p:empty/>
                            </p:input>
                        </p:sink>
                    </p:otherwise>
                </p:choose>
            </p:group>
        </p:for-each>
            
        <!-- Store OBFL -->
        <p:for-each>
            <p:iteration-source>
                <p:pipe step="convert" port="obfl"/>
            </p:iteration-source>
            <dedicon:message message="Storing OBFL"/>
            <p:store>
                <p:with-option name="href" select="concat($pef-output-dir,'/',$name,'.obfl')"/>
            </p:store>
        </p:for-each>
        
        <!-- Final message -->
        <!-- @todo let this be the last message -->
        <dedicon:message>
            <p:with-option name="message" select="concat('Finished ''', $title, '''')"/>
            <p:input port="source">
                <p:empty/>
            </p:input>
        </dedicon:message>
        <p:sink/>
    </p:group>

</p:declare-step>