package org.daisy.pipeline.modules.impl;

import org.daisy.pipeline.modules.Module;
import org.daisy.pipeline.xmlcatalog.XmlCatalogParser;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(
    name = "org.daisy.pipeline.modules.impl.Module_braille_module",
    service = { Module.class }
)
public class Module_braille_module extends Module {

    private XmlCatalogParser catalogParser;

    public Module_braille_module() {
        super("braille-module",
              "2.0.1",
              "Daisy Pipeline 2: Dedicon Braille module");
    }

    @Activate
    public void activate() {
        super.init(catalogParser);
    }

    @Reference(
        name = "XmlCatalogParser",
        unbind = "-",
        service = XmlCatalogParser.class,
        cardinality = ReferenceCardinality.MANDATORY,
        policy = ReferencePolicy.STATIC
    )
    public void setParser(XmlCatalogParser parser) {
        catalogParser = parser;
    }
}
