/*
 * Decompiled with CFR 0.152.
 */
package nl.dedicon.pipeline.braille.step;

import nl.dedicon.pipeline.braille.step.CapitalMode;
import nl.dedicon.pipeline.braille.step.NumericMode;
import nl.dedicon.pipeline.braille.step.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BrailleToText {
    private static final char BRAILLE_CAPITAL = '\u2828';
    private static final char BRAILLE_CAPITAL_PERMANENT = '\u2818';
    private static final char BRAILLE_DIGIT = '\u283c';
    private static final char BRAILLE_HYPHEN = '\u2824';
    private static final char BRAILLE_RESTORE = '\u2820';
    private static final char BRAILLE_SPACE = '\u2800';
    private static final char SPACE = ' ';
    private CapitalMode capitalMode = CapitalMode.lowercase;
    private NumericMode numericMode = NumericMode.no;
    private boolean endsWithHyphen = false;

    public void convert(Document document) {
        Node body = Utils.getChild(document.getDocumentElement(), "body");
        Node main = Utils.getFirstChildWithAttribute(body, "div", "id", "main");
        while (main != null) {
            Node volume = Utils.getFirstChildWithAttribute(main, "div", "class", "volume");
            while (volume != null) {
                Node page = Utils.getFirstChildWithAttribute(volume, "div", "class", "page");
                while (page != null) {
                    Node braillePage = Utils.getFirstChildWithAttribute(page, "div", "class", "braille-page");
                    Node textPage = Utils.getFirstChildWithAttribute(page, "div", "class", "text-page");
                    Node brailleRow = Utils.getFirstChildWithAttribute(braillePage, "div", "class", "row");
                    Node textRow = Utils.getFirstChildWithAttribute(textPage, "div", "class", "row");
                    while (brailleRow != null && textRow != null) {
                        String braille = brailleRow.getTextContent();
                        String text = this.convert(braille);
                        textRow.setTextContent(text);
                        brailleRow = Utils.getNextSiblingWithAttribute(brailleRow, "div", "class", "row");
                        textRow = Utils.getNextSiblingWithAttribute(textRow, "div", "class", "row");
                    }
                    page = Utils.getNextSiblingWithAttribute(page, "div", "class", "page");
                }
                volume = Utils.getNextSiblingWithAttribute(volume, "div", "class", "volume");
            }
            main = Utils.getNextSiblingWithAttribute(main, "div", "id", "main");
        }
    }

    private String convert(String braille) {
        StringBuilder text = new StringBuilder();
        for (char b : braille.toCharArray()) {
            char t;
            if (this.numericMode != NumericMode.no) {
                t = Utils.convertBrailleNumeric(b);
            } else {
                t = Utils.convertBraille(b);
                if (this.capitalMode != CapitalMode.lowercase) {
                    t = String.valueOf(t).toUpperCase().charAt(0);
                }
            }
            text.append(t);
            if (b == '\u283c') {
                this.numericMode = NumericMode.start;
            } else {
                switch (this.numericMode) {
                    case start: {
                        if (!Utils.isBrailleMinus(b) && !Utils.isBrailleDigit(b)) break;
                        this.numericMode = NumericMode.yes;
                        break;
                    }
                    case yes: {
                        if (Utils.isBrailleDecimalSeparator(b)) {
                            this.numericMode = NumericMode.decimalSign;
                            break;
                        }
                        if (Utils.isBrailleDigit(b)) break;
                        this.numericMode = NumericMode.no;
                        break;
                    }
                    case decimalSign: {
                        if (Utils.isBrailleDigit(b)) {
                            this.numericMode = NumericMode.yes;
                            break;
                        }
                        if (Utils.isBrailleMoneyZeros(b)) {
                            this.numericMode = NumericMode.moneyZeros;
                            break;
                        }
                        this.numericMode = NumericMode.no;
                        break;
                    }
                    case moneyZeros: {
                        if (Utils.isBrailleMoneyZeros(b)) break;
                        this.numericMode = NumericMode.no;
                        break;
                    }
                }
            }
            if (b == '\u2828') {
                this.capitalMode = CapitalMode.letter;
            } else if (b == '\u2818') {
                switch (this.capitalMode) {
                    case lowercase: {
                        this.capitalMode = CapitalMode.word;
                    }
                    case letter: {
                        this.capitalMode = CapitalMode.word;
                    }
                    case word: {
                        this.capitalMode = CapitalMode.permanent;
                    }
                    case permanent: {
                        this.capitalMode = CapitalMode.word;
                    }
                }
            } else if (b == '\u2820') {
                this.numericMode = NumericMode.no;
                this.capitalMode = CapitalMode.lowercase;
            } else if (BrailleToText.isSpace(b)) {
                this.numericMode = NumericMode.no;
                if (this.capitalMode != CapitalMode.permanent) {
                    this.capitalMode = CapitalMode.lowercase;
                }
            } else if (this.capitalMode == CapitalMode.letter) {
                this.capitalMode = CapitalMode.lowercase;
            }
            if (b == '\u2824') {
                this.endsWithHyphen = true;
                continue;
            }
            if (BrailleToText.isSpace(b)) continue;
            this.endsWithHyphen = false;
        }
        this.numericMode = NumericMode.no;
        if (!this.endsWithHyphen && this.capitalMode != CapitalMode.permanent) {
            this.capitalMode = CapitalMode.lowercase;
        }
        return text.toString();
    }

    private static boolean isSpace(char b) {
        return b == '\u2800' || b == ' ';
    }
}

