/*
 * Decompiled with CFR 0.152.
 */
package nl.dedicon.pipeline.braille.step;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import nl.dedicon.pipeline.braille.calabash.impl.SymbolsListStep;
import nl.dedicon.pipeline.braille.step.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DediconBrl {
    private static final Map<Character, Character> brlToUnicodeMap = new HashMap<Character, Character>();
    private static final Logger logger = LoggerFactory.getLogger(SymbolsListStep.class);

    private static void map(char brlChar, int unicodeChar) {
        brlToUnicodeMap.put(Character.valueOf(brlChar), Character.valueOf((char)unicodeChar));
    }

    public static String convert(String braille) {
        StringWriter result = new StringWriter();
        for (int i = 0; i < braille.length(); ++i) {
            char brailleChar = braille.charAt(i);
            if (Character.isLetterOrDigit(brailleChar)) {
                result.append(brailleChar);
                continue;
            }
            Character unicodeChar = brlToUnicodeMap.get(Character.valueOf(brailleChar));
            if (unicodeChar != null) {
                result.append(unicodeChar.charValue());
                continue;
            }
            result.append(brailleChar);
            if (Utils.isBraille(brailleChar)) continue;
            logger.warn("Unknown BRL character: '{}'", (Object)Character.valueOf(brailleChar));
        }
        return result.toString();
    }

    static {
        DediconBrl.map(' ', 10240);
        DediconBrl.map('1', 10241);
        DediconBrl.map('A', 10241);
        DediconBrl.map('a', 10241);
        DediconBrl.map(',', 10242);
        DediconBrl.map('2', 10243);
        DediconBrl.map('B', 10243);
        DediconBrl.map('b', 10243);
        DediconBrl.map('\'', 10244);
        DediconBrl.map('K', 10245);
        DediconBrl.map('k', 10245);
        DediconBrl.map(';', 10246);
        DediconBrl.map('L', 10247);
        DediconBrl.map('l', 10247);
        DediconBrl.map('&', 10248);
        DediconBrl.map('3', 10249);
        DediconBrl.map('C', 10249);
        DediconBrl.map('c', 10249);
        DediconBrl.map('9', 10250);
        DediconBrl.map('I', 10250);
        DediconBrl.map('i', 10250);
        DediconBrl.map('6', 10251);
        DediconBrl.map('F', 10251);
        DediconBrl.map('f', 10251);
        DediconBrl.map('/', 10252);
        DediconBrl.map('\u00ec', 10252);
        DediconBrl.map('\u00ed', 10252);
        DediconBrl.map('M', 10253);
        DediconBrl.map('m', 10253);
        DediconBrl.map('S', 10254);
        DediconBrl.map('s', 10254);
        DediconBrl.map('P', 10255);
        DediconBrl.map('p', 10255);
        DediconBrl.map('|', 10256);
        DediconBrl.map('5', 10257);
        DediconBrl.map('E', 10257);
        DediconBrl.map('e', 10257);
        DediconBrl.map(':', 10258);
        DediconBrl.map('8', 10259);
        DediconBrl.map('H', 10259);
        DediconBrl.map('h', 10259);
        DediconBrl.map('*', 10260);
        DediconBrl.map('O', 10261);
        DediconBrl.map('o', 10261);
        DediconBrl.map('!', 10262);
        DediconBrl.map('+', 10262);
        DediconBrl.map('\u00a1', 10262);
        DediconBrl.map('R', 10263);
        DediconBrl.map('r', 10263);
        DediconBrl.map(']', 10264);
        DediconBrl.map('4', 10265);
        DediconBrl.map('D', 10265);
        DediconBrl.map('d', 10265);
        DediconBrl.map('0', 10266);
        DediconBrl.map('J', 10266);
        DediconBrl.map('j', 10266);
        DediconBrl.map('7', 10267);
        DediconBrl.map('G', 10267);
        DediconBrl.map('g', 10267);
        DediconBrl.map('\u00c4', 10268);
        DediconBrl.map('\u00e4', 10268);
        DediconBrl.map('\u00c5', 10268);
        DediconBrl.map('\u00e5', 10268);
        DediconBrl.map('N', 10269);
        DediconBrl.map('n', 10269);
        DediconBrl.map('T', 10270);
        DediconBrl.map('t', 10270);
        DediconBrl.map('Q', 10271);
        DediconBrl.map('q', 10271);
        DediconBrl.map('@', 10272);
        DediconBrl.map('\\', 10273);
        DediconBrl.map('\u00c2', 10273);
        DediconBrl.map('\u00e2', 10273);
        DediconBrl.map('?', 10274);
        DediconBrl.map('\u00bf', 10274);
        DediconBrl.map('\u00ca', 10275);
        DediconBrl.map('\u00ea', 10275);
        DediconBrl.map('-', 10276);
        DediconBrl.map('U', 10277);
        DediconBrl.map('u', 10277);
        DediconBrl.map('<', 10278);
        DediconBrl.map('}', 10278);
        DediconBrl.map('V', 10279);
        DediconBrl.map('v', 10279);
        DediconBrl.map('{', 10280);
        DediconBrl.map('\u00ce', 10281);
        DediconBrl.map('\u00ee', 10281);
        DediconBrl.map('\u00d6', 10282);
        DediconBrl.map('\u00f6', 10282);
        DediconBrl.map('\u00cb', 10283);
        DediconBrl.map('\u00eb', 10283);
        DediconBrl.map('\u00d2', 10284);
        DediconBrl.map('\u00f2', 10284);
        DediconBrl.map('\u00d3', 10284);
        DediconBrl.map('\u00f3', 10284);
        DediconBrl.map('X', 10285);
        DediconBrl.map('x', 10285);
        DediconBrl.map('\u00c8', 10286);
        DediconBrl.map('\u00e8', 10286);
        DediconBrl.map('\u00df', 10286);
        DediconBrl.map('#', 10287);
        DediconBrl.map('\u00c7', 10287);
        DediconBrl.map('\u00e7', 10287);
        DediconBrl.map('~', 10288);
        DediconBrl.map('\u00db', 10289);
        DediconBrl.map('\u00fb', 10289);
        DediconBrl.map('$', 10290);
        DediconBrl.map('.', 10290);
        DediconBrl.map('\u00dc', 10291);
        DediconBrl.map('\u00fc', 10291);
        DediconBrl.map('\"', 10292);
        DediconBrl.map('>', 10292);
        DediconBrl.map('Z', 10293);
        DediconBrl.map('z', 10293);
        DediconBrl.map('(', 10294);
        DediconBrl.map(')', 10294);
        DediconBrl.map('=', 10294);
        DediconBrl.map('\u00c0', 10295);
        DediconBrl.map('\u00e0', 10295);
        DediconBrl.map('\u00c1', 10295);
        DediconBrl.map('\u00e1', 10295);
        DediconBrl.map('[', 10296);
        DediconBrl.map('\u00d4', 10297);
        DediconBrl.map('\u00f4', 10297);
        DediconBrl.map('W', 10298);
        DediconBrl.map('w', 10298);
        DediconBrl.map('\u00cf', 10299);
        DediconBrl.map('\u00ef', 10299);
        DediconBrl.map('\u00d1', 10299);
        DediconBrl.map('\u00f1', 10299);
        DediconBrl.map('%', 10300);
        DediconBrl.map('Y', 10301);
        DediconBrl.map('y', 10301);
        DediconBrl.map('\u00d9', 10302);
        DediconBrl.map('\u00f9', 10302);
        DediconBrl.map('\u00da', 10302);
        DediconBrl.map('\u00fa', 10302);
        DediconBrl.map('\u00c9', 10303);
        DediconBrl.map('\u00e9', 10303);
    }
}

