/*
 * Decompiled with CFR 0.152.
 */
package nl.dedicon.pipeline.braille.calabash.impl;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import org.apache.commons.lang3.StringUtils;
import org.daisy.common.xproc.XProcMonitor;
import org.daisy.common.xproc.calabash.XProcStep;
import org.daisy.common.xproc.calabash.XProcStepProvider;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrlReplaceDoubleFormFeedsStep
extends DefaultStep
implements XProcStep {
    private static final Logger logger = LoggerFactory.getLogger(BrlReplaceDoubleFormFeedsStep.class);
    private static final QName _brl_uri = new QName("brl-uri");

    private BrlReplaceDoubleFormFeedsStep(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    public void reset() {
    }

    public void run() throws SaxonApiException {
        block6: {
            super.run();
            try {
                String brlUri = this.getOption(_brl_uri, "");
                if (!StringUtils.isNotBlank((CharSequence)brlUri)) break block6;
                try {
                    Path path = new File(new URI(brlUri)).toPath();
                    byte[] inBytes = Files.readAllBytes(path);
                    byte[] outBytes = new byte[inBytes.length];
                    int inIndex = 0;
                    int outIndex = 0;
                    while (inIndex < inBytes.length) {
                        int doubleFormFeedLength = this.findDoubleFormFeed(inBytes, inIndex);
                        if (doubleFormFeedLength > 0) {
                            outBytes[outIndex] = 12;
                            inIndex += doubleFormFeedLength;
                            ++outIndex;
                            continue;
                        }
                        outBytes[outIndex] = inBytes[inIndex];
                        ++inIndex;
                        ++outIndex;
                    }
                    Files.write(path, Arrays.copyOfRange(outBytes, 0, outIndex), new OpenOption[0]);
                }
                catch (IOException | URISyntaxException e) {
                    logger.error(String.format("Failed to replace double form feeds in file %s due to %s", brlUri, e.getMessage()));
                    throw e;
                }
            }
            catch (Exception e) {
                logger.error("dedicon:brl-replace-double-form-feeds failed", (Throwable)e);
                throw new XProcException(this.step.getNode(), (Throwable)e);
            }
        }
    }

    private int findDoubleFormFeed(byte[] bytes, int index) {
        int length = 0;
        if (index + length < bytes.length && bytes[index + length] == 12) {
            ++length;
            while (index + length < bytes.length + 1 && bytes[index + length] == 13 && bytes[index + length + 1] == 10) {
                length += 2;
            }
            if (index + length < bytes.length && bytes[index + length] == 12) {
                return ++length;
            }
        }
        return -1;
    }

    @Component(name="dedicon-brl-replace-double-form-feeds", service={XProcStepProvider.class}, property={"type:String={http://www.dedicon.nl}brl-replace-double-form-feeds"})
    public static class Provider
    implements XProcStepProvider {
        public XProcStep newStep(XProcRuntime runtime, XAtomicStep step, XProcMonitor monitor, Map<String, String> map) {
            return new BrlReplaceDoubleFormFeedsStep(runtime, step);
        }
    }
}

