/*
 * Decompiled with CFR 0.152.
 */
package nl.dedicon.pipeline.braille.calabash.impl;

import com.xmlcalabash.core.XProcRunnable;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import java.util.Map;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import nl.dedicon.pipeline.braille.step.MessageContainer;
import org.daisy.common.xproc.XProcMonitor;
import org.daisy.common.xproc.calabash.XProcStep;
import org.daisy.common.xproc.calabash.XProcStepProvider;
import org.osgi.service.component.annotations.Component;

public class MessageStep
extends DefaultStep
implements XProcStep {
    private static final QName _message = new QName("message");
    private static final QName _severity = new QName("severity");
    private static final QName _reset = new QName("reset");
    private static final MessageContainer messageContainer = new MessageContainer();
    private ReadablePipe source = null;
    private WritablePipe result = null;

    private MessageStep(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    public void run() throws SaxonApiException {
        super.run();
        XdmNode node = this.source.read();
        if (node != null) {
            this.result.write(node);
            this.result.close();
        }
        String severity = this.getOption(_severity, "INFO");
        String message = this.getOption(_message, null);
        boolean reset = this.getOption(_reset, false);
        if (reset) {
            messageContainer.reset();
        }
        message = messageContainer.getElapsedTime().concat(" ").concat(message);
        if ("WARN".equals(severity)) {
            this.warning(this.step.getNode(), message);
        } else if ("DEBUG".equals(severity)) {
            this.runtime.getMessageListener().fine((XProcRunnable)this, this.step.getNode(), message);
        } else {
            this.info(this.step.getNode(), message);
        }
    }

    @Component(name="dedicon-message", service={XProcStepProvider.class}, property={"type:String={http://www.dedicon.nl}message"})
    public static class Provider
    implements XProcStepProvider {
        public XProcStep newStep(XProcRuntime runtime, XAtomicStep step, XProcMonitor monitor, Map<String, String> map) {
            return new MessageStep(runtime, step);
        }
    }
}

