/*
 * Decompiled with CFR 0.152.
 */
package nl.dedicon.pipeline.braille.calabash.impl;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import java.util.Map;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import nl.dedicon.pipeline.braille.service.PropertyService;
import nl.dedicon.pipeline.braille.step.SymbolsReplacer;
import nl.dedicon.pipeline.braille.step.Utils;
import org.apache.commons.lang3.StringUtils;
import org.daisy.common.xproc.XProcMonitor;
import org.daisy.common.xproc.calabash.XProcStep;
import org.daisy.common.xproc.calabash.XProcStepProvider;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SymbolsListStep
extends DefaultStep
implements XProcStep {
    private static final Logger logger = LoggerFactory.getLogger(SymbolsListStep.class);
    private static final QName _symbols_code = new QName("symbols-code");
    private static final QName _symbols_code_default = new QName("symbols-code-default");
    private static final QName _symbols_list_header = new QName("symbols-list-header");
    private ReadablePipe source = null;
    private WritablePipe result = null;

    private SymbolsListStep(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    public void run() throws SaxonApiException {
        super.run();
        try {
            XdmNode book = this.source.read();
            String symbolsCode = this.getOption(_symbols_code, "");
            String symbolsCodeDefault = this.getOption(_symbols_code_default, "");
            String header = this.getOption(_symbols_list_header, "");
            if (StringUtils.isBlank((CharSequence)symbolsCode)) {
                symbolsCode = PropertyService.getProperty("symbols-code", symbolsCodeDefault);
            }
            XdmNode symbolsCodeNode = this.runtime.parse(symbolsCode, this.runtime.getStaticBaseURI().toASCIIString());
            SymbolsReplacer symbolsReplacer = new SymbolsReplacer(symbolsCodeNode);
            Document document = Utils.convertToDocument(book);
            symbolsReplacer.replaceSymbols(document);
            symbolsReplacer.insertSymbolsList(document, header);
            XdmNode newBook = Utils.convertToXdmNode(document, this.runtime.getProcessor(), true);
            this.result.write(newBook);
            this.result.close();
        }
        catch (Exception e) {
            logger.error("dedicon:symbols-list failed", (Throwable)e);
            throw new XProcException(this.step.getNode(), (Throwable)e);
        }
    }

    @Component(name="dedicon-symbols-list", service={XProcStepProvider.class}, property={"type:String={http://www.dedicon.nl}symbols-list"})
    public static class Provider
    implements XProcStepProvider {
        public XProcStep newStep(XProcRuntime runtime, XAtomicStep step, XProcMonitor monitor, Map<String, String> map) {
            return new SymbolsListStep(runtime, step);
        }
    }
}

