/*
 * Decompiled with CFR 0.152.
 */
package nl.dedicon.pipeline.braille.step;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Utils {
    public static Document convertToDocument(XdmNode node) throws ParserConfigurationException, SAXException, IOException, SaxonApiException {
        return Utils.convertToDocument(Utils.toString(node));
    }

    public static XdmNode convertToXdmNode(Document document, Processor processor, boolean useFile) throws IOException, SaxonApiException {
        net.sf.saxon.s9api.DocumentBuilder documentBuilder = processor.newDocumentBuilder();
        String xml = Utils.toString(document, documentBuilder);
        if (useFile) {
            String className = new Object(){}.getClass().getName();
            File tempFile = File.createTempFile(className, ".tmp");
            tempFile.deleteOnExit();
            Files.write(tempFile.toPath(), xml.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return documentBuilder.build(tempFile);
        }
        return documentBuilder.build((Source)new StreamSource(new StringReader(xml)));
    }

    public static String toString(XdmNode node) throws SaxonApiException {
        Processor processor = new Processor(false);
        Serializer serializer = processor.newSerializer();
        serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
        serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        serializer.setOutputProperty(Serializer.Property.INDENT, "no");
        return serializer.serializeNodeToString(node);
    }

    public static String toString(Document document, net.sf.saxon.s9api.DocumentBuilder documentBuilder) throws SaxonApiException {
        return Utils.toString(documentBuilder.wrap((Object)document));
    }

    public static Document convertToDocument(String xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
        ByteBuffer encoded = StandardCharsets.UTF_8.encode(xml);
        return documentBuilder.parse(new ByteBufferBackedInputStream(encoded));
    }

    public static Node getChild(Node node, String name) {
        if (node == null) {
            return null;
        }
        String namespace = node.getNamespaceURI();
        if (namespace == null) {
            return null;
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!namespace.equals(child.getNamespaceURI()) || !name.equals(child.getNodeName())) continue;
            return child;
        }
        return null;
    }

    public static Node getFirstChildWithAttribute(Node node, String name, String attributeName, String attributeValue) {
        if (node == null) {
            return null;
        }
        String namespace = node.getNamespaceURI();
        if (namespace == null) {
            return null;
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!namespace.equals(child.getNamespaceURI()) || !name.equals(child.getNodeName()) || child.getNodeType() != 1 || !attributeValue.equals(((Element)child).getAttribute(attributeName))) continue;
            return child;
        }
        return null;
    }

    public static Node getNextSiblingWithAttribute(Node node, String name, String attributeName, String attributeValue) {
        if (node == null) {
            return null;
        }
        String namespace = node.getNamespaceURI();
        if (namespace == null) {
            return null;
        }
        for (Node child = node.getNextSibling(); child != null; child = child.getNextSibling()) {
            if (!namespace.equals(child.getNamespaceURI()) || !name.equals(child.getNodeName()) || child.getNodeType() != 1 || !attributeValue.equals(((Element)child).getAttribute(attributeName))) continue;
            return child;
        }
        return null;
    }

    public static Element addChild(Node parent, String name) {
        Element child = parent.getOwnerDocument().createElementNS(parent.getNamespaceURI(), name);
        parent.appendChild(child);
        return child;
    }

    public static Element addChildBefore(Node parent, Node child, String name) {
        Element newChild = parent.getOwnerDocument().createElementNS(parent.getNamespaceURI(), name);
        parent.insertBefore(newChild, child);
        return newChild;
    }

    public static Node renameNode(Node node, String newNodeName) {
        Document document = node.getOwnerDocument();
        String namespace = document.getDocumentElement().getNamespaceURI();
        return document.renameNode(node, namespace, newNodeName);
    }

    public static void removeNodes(Set<Node> nodes) {
        nodes.forEach(node -> node.getParentNode().removeChild((Node)node));
    }

    public static XdmNode getChildNode(XdmNode node, QName childName) {
        XdmSequenceIterator childIterator = node.axisIterator(Axis.CHILD, childName);
        if (!childIterator.hasNext()) {
            return null;
        }
        return (XdmNode)childIterator.next();
    }

    public static String getValue(XdmNode node, QName childName) {
        XdmNode childNode = Utils.getChildNode(node, childName);
        return childNode != null ? childNode.getStringValue() : null;
    }

    public static String convertXmlEndtagsToHtmlEndtags(String xml) {
        return xml.replaceAll("<\\s*([^\\s>]+)([^>]*)/\\s*>", "<$1$2></$1>");
    }

    public static boolean isBraille(char c) {
        return '\u2800' <= c && c <= '\u283f';
    }

    public static char convertBraille(char braille) {
        if (!Utils.isBraille(braille)) {
            return '\u0000';
        }
        return " a,b'k;l\u2808cif/msp\u2810e:h*o!r\u2818djg@ntq\u2820\\?\u00ea-u(v\u2828\u00ee\u00f6\u00eb\u00a7x\u00e8&\u2830\u00fb.\u00fc)z\"[\u2838\u00f4w\u00ef\u283cy]\u00e9".charAt(braille - 10240);
    }

    public static boolean isBrailleDigit(char braille) {
        return Utils.isDigit(Utils.convertBrailleNumeric(braille));
    }

    public static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    public static char convertBrailleNumeric(char braille) {
        if (Utils.isBraille(braille)) {
            char converted = Utils.convertBraille(braille);
            if ('a' <= converted && converted <= 'j') {
                return "1234567890".charAt(converted - 97);
            }
            return converted;
        }
        return '\u0000';
    }

    public static boolean isBrailleMinus(char braille) {
        char converted = Utils.convertBraille(braille);
        return converted == '-';
    }

    public static boolean isBrailleDecimalSeparator(char braille) {
        return Utils.isDecimalSeparator(Utils.convertBraille(braille));
    }

    public static boolean isDecimalSeparator(char c) {
        return c == '.' || c == ',';
    }

    public static boolean isBrailleMoneyZeros(char braille) {
        return Utils.isMoneyZeros(Utils.convertBraille(braille));
    }

    public static boolean isMoneyZeros(char c) {
        return c == '-' || c == '=';
    }

    private static class ByteBufferBackedInputStream
    extends InputStream {
        final ByteBuffer buf;

        public ByteBufferBackedInputStream(ByteBuffer buf) {
            this.buf = buf;
        }

        @Override
        public int read() throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            return this.buf.get() & 0xFF;
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            len = Math.min(len, this.buf.remaining());
            this.buf.get(bytes, off, len);
            return len;
        }
    }
}

