/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.modules.impl;

import java.net.URI;
import java.util.LinkedList;
import org.daisy.pipeline.modules.Component;
import org.daisy.pipeline.modules.Module;
import org.daisy.pipeline.modules.ModuleRegistry;
import org.daisy.pipeline.modules.ResolutionException;
import org.daisy.pipeline.xmlcatalog.XmlCatalogParser;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

@org.osgi.service.component.annotations.Component(name="org.daisy.pipeline.modules.impl.Module_braille_module", service={Module.class})
public class Module_braille_module
extends Module {
    private static final Logger logger = LoggerFactory.getLogger(Module_braille_module.class);
    private boolean initialized = false;
    private XmlCatalogParser catalogParser;
    private ModuleRegistry moduleRegistry;
    private final LinkedList<Component> componentsToAdd = new LinkedList();
    private final LinkedList<Component> componentsBeingAdded = new LinkedList();

    public Module_braille_module() {
        super("braille-module", "2.0.4", "DAISY Pipeline 2 module :: Dedicon");
    }

    @Reference(name="XmlCatalogParser", unbind="-", service=XmlCatalogParser.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
    public void setParser(XmlCatalogParser parser) {
        this.catalogParser = parser;
    }

    @Reference(name="ModuleRegistry", unbind="-", service=ModuleRegistry.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
    public void setModuleRegistry(ModuleRegistry registry) {
        this.moduleRegistry = registry;
    }

    private void tryResolveComponent(String uri, String versionRange) throws ResolutionException {
        if (this.moduleRegistry.getModuleByComponent(URI.create(uri), versionRange) == null) {
            throw new ResolutionException("Unresolved dependency " + uri + " with version=" + versionRange);
        }
    }

    @Activate
    protected void init() {
        logger.debug("Initializing module " + this.getName());
        Module tmpModule = new Module(this.getName(), this.getVersion(), this.getTitle()){

            public void resolveDependencies() {
            }

            public Logger getLogger() {
                return NOPLogger.NOP_LOGGER;
            }
        };
        Module.parseCatalog((Module)tmpModule, (XmlCatalogParser)this.catalogParser);
        for (String e : tmpModule.getEntities()) {
            this.addEntity(tmpModule.getEntity(e));
            logger.debug("Loaded entity: " + e);
        }
        for (URI c : tmpModule.getComponents()) {
            this.components.put(c, () -> null);
            this.componentsToAdd.add(tmpModule.getComponent(c));
        }
        logger.debug("Module " + this.getName() + " initialized, but dependencies have not been resolved yet");
    }

    public void resolveDependencies() {
        if (!this.initialized) {
            boolean recursive;
            boolean bl = recursive = !this.componentsBeingAdded.isEmpty();
            if (recursive) {
                logger.debug("Resolving dependencies of module " + this.getName() + " (continuing in recursive call)");
            } else {
                logger.debug("Resolving dependencies of module " + this.getName());
            }
            while (true) {
                if (this.componentsToAdd.isEmpty()) {
                    if (this.componentsBeingAdded.isEmpty()) break;
                    this.componentsToAdd.addAll(this.componentsBeingAdded);
                    this.componentsBeingAdded.clear();
                }
                Component c = this.componentsToAdd.poll();
                this.componentsBeingAdded.add(c);
                if (this.addComponent(c)) {
                    logger.debug("Loaded component: " + c.getURI());
                }
                this.componentsBeingAdded.remove(c);
                this.componentsToAdd.remove(c);
            }
            if (!this.initialized) {
                logger.debug("Done resolving dependencies of module " + this.getName());
            }
            this.initialized = true;
        }
    }

    protected boolean addComponent(Component component) {
        String name = component.getURI().toString();
        try {
            if ("http://www.dedicon.nl/pipeline/modules/braille/dtbook-to-pef.xpl".equals(name)) {
                this.tryResolveComponent("http://www.daisy.org/pipeline/modules/dtbook-utils/library.xpl", "[5.1.1,6.0.0)");
                this.tryResolveComponent("http://www.daisy.org/pipeline/modules/braille/common-utils/library.xpl", "[5.0.2,6.0.0)");
                this.tryResolveComponent("http://www.daisy.org/pipeline/modules/fileset-utils/library.xpl", "[6.1.4,7.0.0)");
                this.tryResolveComponent("http://www.daisy.org/pipeline/modules/braille/dtbook-to-pef/library.xpl", "[11.1.0,12.0.0)");
                this.tryResolveComponent("http://www.daisy.org/pipeline/modules/braille/pef-utils/library.xpl", "[6.0.3,7.0.0)");
                this.tryResolveComponent("http://www.daisy.org/pipeline/modules/file-utils/library.xpl", "[4.3.2,5.0.0)");
                this.tryResolveComponent("http://www.daisy.org/pipeline/modules/common-utils/library.xpl", "[3.1.3,4.0.0)");
            } else if ("http://www.dedicon.nl/pipeline/modules/braille/library.xpl".equals(name)) {
                this.tryResolveComponent("http://www.daisy.org/pipeline/modules/common-utils/library.xpl", "[3.1.3,4.0.0)");
            }
        }
        catch (ResolutionException re) {
            logger.warn("Component " + component.getURI() + " can not be loaded: " + re.getMessage());
            return false;
        }
        return super.addComponent(component);
    }
}

