/*
 * Decompiled with CFR 0.152.
 */
package nl.detestbaas.playwright.annotations;

import com.microsoft.playwright.Page;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import nl.detestbaas.playwright.annotations.How;
import nl.detestbaas.playwright.annotations.LocateBy;

public class PageFactory {
    private static final Map<How, BiFunction<Page, LocateBy, ?>> LOCATORS_MAP = new HashMap<How, BiFunction<Page, LocateBy, ?>>(){
        {
            this.put(How.ALT_TEXT, PageFactory::getLocatorByAltText);
            this.put(How.LABEL, PageFactory::getLocatorByLabel);
            this.put(How.PLACEHOLDER, PageFactory::getLocatorByPlaceholder);
            this.put(How.ROLE, PageFactory::getLocatorByRole);
            this.put(How.TEST_ID, PageFactory::getLocatorByTestId);
            this.put(How.TEXT, PageFactory::getLocatorByText);
            this.put(How.TITLE, PageFactory::getLocatorByTitle);
        }
    };

    private static Object getLocator(Function<String, ?> getByValue, Function<Pattern, ?> getByPattern, LocateBy locateBy) {
        String pattern = locateBy.pattern();
        return pattern.isEmpty() ? getByValue.apply(locateBy.value()) : getByPattern.apply(Pattern.compile(pattern));
    }

    private static Object getLocatorByAltText(Page page, LocateBy locateBy) {
        return PageFactory.getLocator(arg_0 -> ((Page)page).getByAltText(arg_0), arg_0 -> ((Page)page).getByAltText(arg_0), locateBy);
    }

    private static Object getLocatorByLabel(Page page, LocateBy locateBy) {
        return PageFactory.getLocator(arg_0 -> ((Page)page).getByLabel(arg_0), arg_0 -> ((Page)page).getByLabel(arg_0), locateBy);
    }

    private static Object getLocatorByPlaceholder(Page page, LocateBy locateBy) {
        return PageFactory.getLocator(arg_0 -> ((Page)page).getByPlaceholder(arg_0), arg_0 -> ((Page)page).getByPlaceholder(arg_0), locateBy);
    }

    private static Object getLocatorByRole(Page page, LocateBy locateBy) {
        return page.getByRole(locateBy.ariaRole(), new Page.GetByRoleOptions().setName(locateBy.value()));
    }

    private static Object getLocatorByTestId(Page page, LocateBy locateBy) {
        return PageFactory.getLocator(arg_0 -> ((Page)page).getByTestId(arg_0), arg_0 -> ((Page)page).getByTestId(arg_0), locateBy);
    }

    private static Object getLocatorByText(Page page, LocateBy locateBy) {
        return PageFactory.getLocator(arg_0 -> ((Page)page).getByText(arg_0), arg_0 -> ((Page)page).getByText(arg_0), locateBy);
    }

    private static Object getLocatorByTitle(Page page, LocateBy locateBy) {
        return PageFactory.getLocator(arg_0 -> ((Page)page).getByTitle(arg_0), arg_0 -> ((Page)page).getByTitle(arg_0), locateBy);
    }

    private static Object generateLocator(Page page, LocateBy locateBy) {
        return LOCATORS_MAP.getOrDefault((Object)locateBy.how(), (p, l) -> p.locator(l.value())).apply(page, locateBy);
    }

    private static void initializeFieldLocator(Page page, Object pageObject, Field field) {
        LocateBy locateBy = field.getAnnotation(LocateBy.class);
        field.setAccessible(true);
        try {
            if (locateBy.how() != How.UNSET) {
                Object locator = PageFactory.generateLocator(page, locateBy);
                field.set(pageObject, locator);
            } else {
                field.set(pageObject, page.locator(locateBy.value()));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static void initAnnotatedLocators(Page page, Object pageObject) {
        Arrays.stream(pageObject.getClass().getDeclaredFields()).filter(field -> !Objects.isNull(field.getAnnotation(LocateBy.class))).forEach(field -> PageFactory.initializeFieldLocator(page, pageObject, field));
    }
}

