/*
 * Decompiled with CFR 0.152.
 */
package nl.dionsegijn.konfetti.core.emitter;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import nl.dionsegijn.konfetti.core.models.CoreRect;
import nl.dionsegijn.konfetti.core.models.Shape;
import nl.dionsegijn.konfetti.core.models.Vector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b2\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 K2\u00020\u0001:\u0001KBy\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0003\u0012\u0006\u0010\u0011\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0007\u0012\u0006\u0010\u0014\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u0003J\u0006\u0010C\u001a\u00020\u0007J\u0006\u0010D\u001a\u00020\u000eJ\u0016\u0010E\u001a\u00020A2\u0006\u0010F\u001a\u00020\u00072\u0006\u0010G\u001a\u00020HJ\u0018\u0010I\u001a\u00020A2\u0006\u0010F\u001a\u00020\u00072\u0006\u0010G\u001a\u00020HH\u0002J\u0010\u0010J\u001a\u00020A2\u0006\u0010F\u001a\u00020\u0007H\u0002R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001e\u0010#\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010%R\u000e\u0010'\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u001fR\u001a\u00102\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u001f\"\u0004\b4\u0010!R\u0011\u0010\u0013\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u001fR\u0011\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u001fR\u000e\u00107\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00108\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u001f\"\u0004\b:\u0010!R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010.\"\u0004\b>\u00100R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010\u001f\u00a8\u0006L"}, d2={"Lnl/dionsegijn/konfetti/core/emitter/Confetti;", "", "location", "Lnl/dionsegijn/konfetti/core/models/Vector;", "color", "", "width", "", "mass", "shape", "Lnl/dionsegijn/konfetti/core/models/Shape;", "lifespan", "", "fadeOut", "", "acceleration", "velocity", "damping", "rotationSpeed3D", "rotationSpeed2D", "pixelDensity", "(Lnl/dionsegijn/konfetti/core/models/Vector;IFFLnl/dionsegijn/konfetti/core/models/Shape;JZLnl/dionsegijn/konfetti/core/models/Vector;Lnl/dionsegijn/konfetti/core/models/Vector;FFFF)V", "alpha", "getAlpha", "()I", "setAlpha", "(I)V", "alphaColor", "getAlphaColor", "setAlphaColor", "getDamping", "()F", "setDamping", "(F)V", "<set-?>", "drawParticle", "getDrawParticle", "()Z", "getFadeOut", "frameRate", "gravity", "getLifespan", "()J", "setLifespan", "(J)V", "getLocation", "()Lnl/dionsegijn/konfetti/core/models/Vector;", "setLocation", "(Lnl/dionsegijn/konfetti/core/models/Vector;)V", "getPixelDensity", "rotation", "getRotation", "setRotation", "getRotationSpeed2D", "getRotationSpeed3D", "rotationWidth", "scaleX", "getScaleX", "setScaleX", "getShape", "()Lnl/dionsegijn/konfetti/core/models/Shape;", "getVelocity", "setVelocity", "getWidth", "applyForce", "", "force", "getSize", "isDead", "render", "deltaTime", "drawArea", "Lnl/dionsegijn/konfetti/core/models/CoreRect;", "update", "updateAlpha", "Companion", "core"})
public final class Confetti {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Vector location;
    private final int color;
    private final float width;
    private final float mass;
    @NotNull
    private final Shape shape;
    private long lifespan;
    private final boolean fadeOut;
    @NotNull
    private Vector acceleration;
    @NotNull
    private Vector velocity;
    private float damping;
    private final float rotationSpeed3D;
    private final float rotationSpeed2D;
    private final float pixelDensity;
    private float rotation;
    private float rotationWidth;
    private float frameRate;
    @NotNull
    private Vector gravity;
    private int alpha;
    private float scaleX;
    private int alphaColor;
    private boolean drawParticle;
    private static final float DEFAULT_FRAME_RATE = 60.0f;
    private static final float GRAVITY = 0.02f;
    private static final int ALPHA_DECREMENT = 5;
    private static final int MILLIS_IN_SECOND = 1000;
    private static final float FULL_CIRCLE = 360.0f;

    public Confetti(@NotNull Vector location, int color, float width, float mass, @NotNull Shape shape, long lifespan, boolean fadeOut, @NotNull Vector acceleration, @NotNull Vector velocity, float damping, float rotationSpeed3D, float rotationSpeed2D, float pixelDensity) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)acceleration, (String)"acceleration");
        Intrinsics.checkNotNullParameter((Object)velocity, (String)"velocity");
        this.location = location;
        this.color = color;
        this.width = width;
        this.mass = mass;
        this.shape = shape;
        this.lifespan = lifespan;
        this.fadeOut = fadeOut;
        this.acceleration = acceleration;
        this.velocity = velocity;
        this.damping = damping;
        this.rotationSpeed3D = rotationSpeed3D;
        this.rotationSpeed2D = rotationSpeed2D;
        this.pixelDensity = pixelDensity;
        this.rotationWidth = this.width;
        this.frameRate = 60.0f;
        this.gravity = new Vector(0.0f, 0.02f);
        this.alpha = 255;
        this.drawParticle = true;
    }

    public /* synthetic */ Confetti(Vector vector, int n, float f, float f2, Shape shape, long l, boolean bl, Vector vector2, Vector vector3, float f3, float f4, float f5, float f6, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            l = -1L;
        }
        if ((n2 & 0x40) != 0) {
            bl = true;
        }
        if ((n2 & 0x80) != 0) {
            vector2 = new Vector(0.0f, 0.0f);
        }
        if ((n2 & 0x100) != 0) {
            vector3 = new Vector(0.0f, 0.0f, 3, null);
        }
        if ((n2 & 0x400) != 0) {
            f4 = 1.0f;
        }
        if ((n2 & 0x800) != 0) {
            f5 = 1.0f;
        }
        this(vector, n, f, f2, shape, l, bl, vector2, vector3, f3, f4, f5, f6);
    }

    @NotNull
    public final Vector getLocation() {
        return this.location;
    }

    public final void setLocation(@NotNull Vector vector) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"<set-?>");
        this.location = vector;
    }

    public final float getWidth() {
        return this.width;
    }

    @NotNull
    public final Shape getShape() {
        return this.shape;
    }

    public final long getLifespan() {
        return this.lifespan;
    }

    public final void setLifespan(long l) {
        this.lifespan = l;
    }

    public final boolean getFadeOut() {
        return this.fadeOut;
    }

    @NotNull
    public final Vector getVelocity() {
        return this.velocity;
    }

    public final void setVelocity(@NotNull Vector vector) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"<set-?>");
        this.velocity = vector;
    }

    public final float getDamping() {
        return this.damping;
    }

    public final void setDamping(float f) {
        this.damping = f;
    }

    public final float getRotationSpeed3D() {
        return this.rotationSpeed3D;
    }

    public final float getRotationSpeed2D() {
        return this.rotationSpeed2D;
    }

    public final float getPixelDensity() {
        return this.pixelDensity;
    }

    public final float getRotation() {
        return this.rotation;
    }

    public final void setRotation(float f) {
        this.rotation = f;
    }

    public final int getAlpha() {
        return this.alpha;
    }

    public final void setAlpha(int n) {
        this.alpha = n;
    }

    public final float getScaleX() {
        return this.scaleX;
    }

    public final void setScaleX(float f) {
        this.scaleX = f;
    }

    public final int getAlphaColor() {
        return this.alphaColor;
    }

    public final void setAlphaColor(int n) {
        this.alphaColor = n;
    }

    public final boolean getDrawParticle() {
        return this.drawParticle;
    }

    public final float getSize() {
        return this.width;
    }

    public final boolean isDead() {
        return this.alpha <= 0;
    }

    public final void applyForce(@NotNull Vector force) {
        Intrinsics.checkNotNullParameter((Object)force, (String)"force");
        this.acceleration.addScaled(force, 1.0f / this.mass);
    }

    public final void render(float deltaTime, @NotNull CoreRect drawArea) {
        Intrinsics.checkNotNullParameter((Object)drawArea, (String)"drawArea");
        this.applyForce(this.gravity);
        this.update(deltaTime, drawArea);
    }

    private final void update(float deltaTime, CoreRect drawArea) {
        float f = this.frameRate = deltaTime > 0.0f ? 1.0f / deltaTime : 60.0f;
        if (this.location.getY() > drawArea.getHeight()) {
            this.alpha = 0;
            return;
        }
        this.velocity.add(this.acceleration);
        this.velocity.mult(this.damping);
        this.location.addScaled(this.velocity, deltaTime * this.frameRate * this.pixelDensity);
        this.lifespan -= (long)(deltaTime * (float)1000);
        if (this.lifespan <= 0L) {
            this.updateAlpha(deltaTime);
        }
        this.rotation += this.rotationSpeed2D * deltaTime * this.frameRate;
        if (this.rotation >= 360.0f) {
            this.rotation = 0.0f;
        }
        this.rotationWidth -= Math.abs(this.rotationSpeed3D) * deltaTime * this.frameRate;
        if (this.rotationWidth < 0.0f) {
            this.rotationWidth = this.width;
        }
        this.scaleX = Math.abs(this.rotationWidth / this.width - 0.5f) * (float)2;
        this.alphaColor = this.alpha << 24 | this.color & 0xFFFFFF;
        this.drawParticle = drawArea.contains((int)this.location.getX(), (int)this.location.getY());
    }

    private final void updateAlpha(float deltaTime) {
        int n;
        if (this.fadeOut) {
            float interval = (float)5 * deltaTime * this.frameRate;
            n = RangesKt.coerceAtLeast((int)(this.alpha - (int)interval), (int)0);
        } else {
            n = 0;
        }
        this.alpha = n;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lnl/dionsegijn/konfetti/core/emitter/Confetti$Companion;", "", "()V", "ALPHA_DECREMENT", "", "DEFAULT_FRAME_RATE", "", "FULL_CIRCLE", "GRAVITY", "MILLIS_IN_SECOND", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

