/*
 * Decompiled with CFR 0.152.
 */
package nl.elec332.util.implementationmanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import nl.elec332.util.implementationmanager.api.IServiceSelector;
import nl.elec332.util.implementationmanager.impl.ServiceSelectorSelector;

public class ImplementationManager {
    public static <T> T loadService(Class<T> type) {
        return ImplementationManager.loadService(type, (ClassLoader)null);
    }

    public static <T> T loadService(Class<T> type, ModuleLayer layer) {
        return ImplementationManager.loadService(type, layer, (String)null);
    }

    public static <T> T loadService(Class<T> type, ClassLoader classLoader) {
        return ImplementationManager.loadService(type, classLoader, null);
    }

    public static <T> T loadService(Class<T> type, ModuleLayer layer, String defaultImpl) {
        return ImplementationManager.loadService(type, layer, null, defaultImpl);
    }

    public static <T> T loadService(Class<T> type, ClassLoader classLoader, String defaultImpl) {
        return ImplementationManager.loadService(type, null, classLoader, defaultImpl);
    }

    public static <T> T loadService(Class<T> type, ModuleLayer layer, ClassLoader classLoader) {
        return ImplementationManager.loadService(type, layer, classLoader, null);
    }

    public static <T> T loadService(Class<T> type, ModuleLayer layer, ClassLoader classLoader, String defaultImpl) {
        Collection<ServiceLoader.Provider<T>> allServices = ImplementationManager.loadServices(type, layer, classLoader, defaultImpl);
        if (allServices.isEmpty()) {
            if (defaultImpl == null) {
                return null;
            }
            throw new RuntimeException("Impossible?");
        }
        if (allServices.size() == 1) {
            return allServices.iterator().next().get();
        }
        IServiceSelector<T> serviceSelector = ServiceSelectorSelector.getServiceSelector(type);
        return Objects.requireNonNull(serviceSelector.getBestService(allServices.stream().map(ServiceLoader.Provider::get).collect(Collectors.toList())));
    }

    public static <T> Collection<ServiceLoader.Provider<T>> loadServices(Class<T> type) {
        return ImplementationManager.loadServices(type, (ClassLoader)null);
    }

    public static <T> Collection<ServiceLoader.Provider<T>> loadServices(Class<T> type, ModuleLayer layer) {
        return ImplementationManager.loadServices(type, layer, (String)null);
    }

    public static <T> Collection<ServiceLoader.Provider<T>> loadServices(Class<T> type, ClassLoader classLoader) {
        return ImplementationManager.loadServices(type, classLoader, null);
    }

    public static <T> Collection<ServiceLoader.Provider<T>> loadServices(Class<T> type, ModuleLayer layer, String defaultImpl) {
        return ImplementationManager.loadServices(type, layer, null, defaultImpl);
    }

    public static <T> Collection<ServiceLoader.Provider<T>> loadServices(Class<T> type, ClassLoader classLoader, String defaultImpl) {
        return ImplementationManager.loadServices(type, null, classLoader, defaultImpl);
    }

    public static <T> Collection<ServiceLoader.Provider<T>> loadServices(Class<T> type, ModuleLayer layer, ClassLoader classLoader) {
        return ImplementationManager.loadServices(type, layer, classLoader, null);
    }

    public static <T> Collection<ServiceLoader.Provider<T>> loadServices(Class<T> type, ModuleLayer layer, ClassLoader classLoader, String defaultImpl) {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        ArrayList<ServiceLoader.Provider<T>> providers = new ArrayList<ServiceLoader.Provider<T>>();
        ServiceLoader.load(type, classLoader).stream().forEach(providers::add);
        if (layer != null) {
            ServiceLoader.load(layer, type).stream().forEach(providers::add);
        }
        if (defaultImpl != null) {
            defaultImpl = defaultImpl.replace("/", ".");
            boolean isDefaultLoaded = false;
            for (ServiceLoader.Provider provider : providers) {
                if (!provider.type().getName().equals(defaultImpl)) continue;
                isDefaultLoaded = true;
                break;
            }
            if (!isDefaultLoaded) {
                try {
                    final Class<?> clazz = classLoader.loadClass(defaultImpl);
                    if (!type.isAssignableFrom(clazz)) {
                        throw new IllegalArgumentException(defaultImpl + " is not a valid implementation of " + type.getCanonicalName());
                    }
                    final Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    providers.add(new ServiceLoader.Provider<T>(){

                        @Override
                        public Class<? extends T> type() {
                            return clazz;
                        }

                        @Override
                        public T get() {
                            return obj;
                        }
                    });
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (providers.isEmpty()) {
            return Collections.emptyList();
        }
        return providers;
    }
}

