/*
 * Decompiled with CFR 0.152.
 */
package nl.elec332.util.implementationmanager.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import nl.elec332.util.implementationmanager.api.IServiceSelector;

public class ServiceSelectorSelector {
    private static final ServiceLoader<IServiceSelector> serviceSelectorLoader = ServiceLoader.load(IServiceSelector.class);

    public static <T> IServiceSelector<T> getServiceSelector(Class<T> type) {
        serviceSelectorLoader.reload();
        List selectors = serviceSelectorLoader.stream().map(ServiceLoader.Provider::get).collect(Collectors.toList());
        List specificSelectors = selectors.stream().filter(s -> s.getType() == type || type.isAssignableFrom(s.getType())).collect(Collectors.toList());
        if (!specificSelectors.isEmpty()) {
            return ServiceSelectorSelector.selectMostSpecific(specificSelectors);
        }
        specificSelectors = selectors.stream().filter(s -> s.getType().isAssignableFrom(type)).collect(Collectors.toList());
        if (!specificSelectors.isEmpty()) {
            return ServiceSelectorSelector.selectMostSpecific(specificSelectors);
        }
        throw new UnsupportedOperationException("No selector found for type " + type.getCanonicalName());
    }

    private static IServiceSelector selectMostSpecific(Collection<IServiceSelector> selectors) {
        Iterator<IServiceSelector> it = selectors.iterator();
        IServiceSelector ret = it.next();
        while (it.hasNext()) {
            IServiceSelector match = it.next();
            if (match.getType().isAssignableFrom(ret.getType())) continue;
            ret = match;
        }
        return ret;
    }
}

