/*
 * Decompiled with CFR 0.152.
 */
package nl.elec332.util.implementationmanager.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import nl.elec332.util.implementationmanager.ImplementationManager;
import nl.elec332.util.implementationmanager.api.IServiceSelector;
import nl.elec332.util.implementationmanager.impl.ServiceSelectorSelector;

public class ImplementationManagerImpl {
    public static <T> T loadService(Collection<T> allServices, Class<T> type) {
        if (allServices.size() == 1) {
            return allServices.iterator().next();
        }
        IServiceSelector<T> serviceSelector = ServiceSelectorSelector.getServiceSelector(type);
        return Objects.requireNonNull(serviceSelector.getBestService(allServices));
    }

    public static <T> Collection<T> loadServices(Collection<ServiceLoader.Provider<T>> allServices, Class<T> type, String defaultImpl) {
        if (allServices.isEmpty()) {
            if (defaultImpl == null) {
                return null;
            }
            throw new RuntimeException("Impossible?");
        }
        IServiceSelector serviceSelector = ServiceSelectorSelector.getServiceSelector(type);
        return allServices.stream().map(p -> {
            try {
                return serviceSelector.loadService((ServiceLoader.Provider)p);
            }
            catch (Throwable e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T> Collection<ServiceLoader.Provider<T>> loadServiceProviders(Class<T> type, ModuleLayer layer, ClassLoader classLoader, String defaultImpl) {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        ArrayList<ServiceLoader.Provider<T>> providers = new ArrayList<ServiceLoader.Provider<T>>();
        ImplementationManager.class.getModule().addUses(type);
        ServiceLoader.load(type, classLoader).stream().forEach(providers::add);
        if (layer != null) {
            ServiceLoader.load(layer, type).stream().forEach(providers::add);
        }
        if (defaultImpl != null) {
            defaultImpl = defaultImpl.replace("/", ".");
            boolean isDefaultLoaded = false;
            for (ServiceLoader.Provider provider : providers) {
                if (!provider.type().getName().equals(defaultImpl)) continue;
                isDefaultLoaded = true;
                break;
            }
            if (!isDefaultLoaded) {
                try {
                    final Class<?> clazz = classLoader.loadClass(defaultImpl);
                    if (!type.isAssignableFrom(clazz)) {
                        throw new IllegalArgumentException(defaultImpl + " is not a valid implementation of " + type.getCanonicalName());
                    }
                    final Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    providers.add(new ServiceLoader.Provider<T>(){

                        @Override
                        public Class<? extends T> type() {
                            return clazz;
                        }

                        @Override
                        public T get() {
                            return obj;
                        }
                    });
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (providers.isEmpty()) {
            return Collections.emptyList();
        }
        return providers;
    }
}

