/*
 * Decompiled with CFR 0.152.
 */
package jla.embed.org.jcodec.codecs.wav;

import java.io.IOException;
import jla.embed.org.jcodec.codecs.wav.WavHeader;
import jla.embed.org.jcodec.common.AudioCodecMeta;
import jla.embed.org.jcodec.common.AudioFormat;
import jla.embed.org.jcodec.common.Codec;
import jla.embed.org.jcodec.common.Muxer;
import jla.embed.org.jcodec.common.MuxerTrack;
import jla.embed.org.jcodec.common.VideoCodecMeta;
import jla.embed.org.jcodec.common.io.NIOUtils;
import jla.embed.org.jcodec.common.io.SeekableByteChannel;
import jla.embed.org.jcodec.common.model.Packet;

public class WavMuxer
implements Muxer,
MuxerTrack {
    protected SeekableByteChannel out;
    protected WavHeader header;
    protected int written;
    private AudioFormat format;

    public WavMuxer(SeekableByteChannel out) throws IOException {
        this.out = out;
    }

    @Override
    public void addFrame(Packet outPacket) throws IOException {
        this.written += this.out.write(outPacket.getData());
    }

    public void close() throws IOException {
        this.out.setPosition(0L);
        WavHeader.createWavHeader(this.format, this.format.bytesToFrames(this.written)).write(this.out);
        NIOUtils.closeQuietly(this.out);
    }

    @Override
    public MuxerTrack addVideoTrack(Codec codec, VideoCodecMeta meta) {
        return null;
    }

    @Override
    public MuxerTrack addAudioTrack(Codec codec, AudioCodecMeta meta) {
        this.header = WavHeader.createWavHeader(meta.getFormat(), 0);
        this.format = meta.getFormat();
        try {
            this.header.write(this.out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public void finish() throws IOException {
    }
}

