/*
 * Decompiled with CFR 0.152.
 */
package jla.embed.org.jcodec.common;

import java.lang.reflect.Array;
import jla.embed.org.jcodec.common.IntArrayList;

public class ArrayUtil {
    public static <T> void shiftRight1(T[] array) {
        for (int i = 1; i < array.length; ++i) {
            array[i] = array[i - 1];
        }
        array[0] = null;
    }

    public static <T> void shiftLeft1(T[] array) {
        for (int i = 0; i < array.length - 1; ++i) {
            array[i] = array[i + 1];
        }
        array[array.length - 1] = null;
    }

    public static <T> void shiftRight3(T[] array, int from, int to) {
        for (int i = to - 1; i > from; --i) {
            array[i] = array[i - 1];
        }
        array[from] = null;
    }

    public static <T> void shiftLeft3(T[] array, int from, int to) {
        for (int i = from; i < to - 1; ++i) {
            array[i] = array[i + 1];
        }
        array[to - 1] = null;
    }

    public static <T> void shiftLeft2(T[] array, int from) {
        ArrayUtil.shiftLeft3(array, from, array.length);
    }

    public static <T> void shiftRight2(T[] array, int to) {
        ArrayUtil.shiftRight3(array, 0, to);
    }

    public static final void swap(int[] arr, int ind1, int ind2) {
        if (ind1 == ind2) {
            return;
        }
        int tmp = arr[ind1];
        arr[ind1] = arr[ind2];
        arr[ind2] = tmp;
    }

    public static final int sumInt(int[] array) {
        int result = 0;
        for (int i = 0; i < array.length; ++i) {
            result += array[i];
        }
        return result;
    }

    public static final int sumByte(byte[] array) {
        int result = 0;
        for (int i = 0; i < array.length; ++i) {
            result += array[i];
        }
        return result;
    }

    public static int sumInt3(int[] array, int from, int count) {
        int result = 0;
        for (int i = from; i < from + count; ++i) {
            result += array[i];
        }
        return result;
    }

    public static int sumByte3(byte[] array, int from, int count) {
        int result = 0;
        for (int i = from; i < from + count; ++i) {
            result += array[i];
        }
        return result;
    }

    public static void addInt(int[] array, int val) {
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = array[n] + val;
        }
    }

    public static int[] addAllInt(int[] array1, int[] array2) {
        if (array1 == null) {
            return ArrayUtil.cloneInt(array2);
        }
        if (array2 == null) {
            return ArrayUtil.cloneInt(array1);
        }
        int[] joinedArray = new int[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static long[] addAllLong(long[] array1, long[] array2) {
        if (array1 == null) {
            return ArrayUtil.cloneLong(array2);
        }
        if (array2 == null) {
            return ArrayUtil.cloneLong(array1);
        }
        long[] joinedArray = new long[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static Object[] addAllObj(Object[] array1, Object[] array2) {
        if (array1 == null) {
            return ArrayUtil.cloneObj(array2);
        }
        if (array2 == null) {
            return ArrayUtil.cloneObj(array1);
        }
        Object[] joinedArray = (Object[])Array.newInstance(array1.getClass().getComponentType(), array1.length + array2.length);
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static int[] cloneInt(int[] array) {
        if (array == null) {
            return null;
        }
        return (int[])array.clone();
    }

    public static long[] cloneLong(long[] array) {
        if (array == null) {
            return null;
        }
        return (long[])array.clone();
    }

    public static Object[] cloneObj(Object[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }

    public static byte[] toByteArrayShifted(int[] array) {
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = (byte)(array[i] - 128);
        }
        return result;
    }

    public static byte[][] toByteArrayShifted2(int[][] intArray) {
        byte[][] result = new byte[intArray.length][];
        for (int i = 0; i < intArray.length; ++i) {
            result[i] = ArrayUtil.toByteArrayShifted(intArray[i]);
        }
        return result;
    }

    public static int[] toIntArrayUnshifted(byte[] bytes) {
        int[] result = new int[bytes.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(bytes[i] + 128);
        }
        return result;
    }

    public static byte[] toByteArray(int[] ints) {
        byte[] result = new byte[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            result[i] = (byte)ints[i];
        }
        return result;
    }

    public static int[] toIntArray(byte[] bytes) {
        int[] result = new int[bytes.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = bytes[i];
        }
        return result;
    }

    public static int[] toUnsignedIntArray(byte[] bytes) {
        int[] result = new int[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = bytes[i] & 0xFF;
        }
        return result;
    }

    public static <T> void reverse(T[] frames) {
        int i = 0;
        int j = frames.length - 1;
        while (i < frames.length >> 1) {
            T tmp = frames[i];
            frames[i] = frames[j];
            frames[j] = tmp;
            ++i;
            --j;
        }
    }

    public static int max(int[] array) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
        }
        return max;
    }

    public static int[][] rotate(int[][] src) {
        int[][] dst = new int[src[0].length][src.length];
        for (int i = 0; i < src.length; ++i) {
            for (int j = 0; j < src[0].length; ++j) {
                dst[j][i] = src[i][j];
            }
        }
        return dst;
    }

    public static byte[][] create2D(int width, int height) {
        byte[][] result = new byte[height][];
        for (int i = 0; i < height; ++i) {
            result[i] = new byte[width];
        }
        return result;
    }

    public static void printMatrixBytes(byte[] array, String format, int width) {
        String[] strings = new String[array.length];
        int maxLen = 0;
        for (int i = 0; i < array.length; ++i) {
            strings[i] = String.format(format, array[i]);
            maxLen = Math.max(maxLen, strings[i].length());
        }
        int ind = 0;
        while (ind < strings.length) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < width && ind < strings.length; ++i, ++ind) {
                for (int j = 0; j < maxLen - strings[ind].length() + 1; ++j) {
                    builder.append(" ");
                }
                builder.append(strings[ind]);
            }
            System.out.println(builder);
        }
    }

    public static void printMatrix(int[] array, String format, int width) {
        String[] strings = new String[array.length];
        int maxLen = 0;
        for (int i = 0; i < array.length; ++i) {
            strings[i] = String.format(format, array[i]);
            maxLen = Math.max(maxLen, strings[i].length());
        }
        int ind = 0;
        while (ind < strings.length) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < width && ind < strings.length; ++i, ++ind) {
                for (int j = 0; j < maxLen - strings[ind].length() + 1; ++j) {
                    builder.append(" ");
                }
                builder.append(strings[ind]);
            }
            System.out.println(builder);
        }
    }

    public static byte[] padLeft(byte[] array, int padLength) {
        byte[] result = new byte[array.length + padLength];
        for (int i = padLength; i < result.length; ++i) {
            result[i] = array[i - padLength];
        }
        return result;
    }

    public static int[] randomIntArray(int size, int from, int to) {
        int width = to - from;
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (int)(Math.random() * (double)width % (double)width) + from;
        }
        return result;
    }

    public static byte[] randomByteArray(int size, byte from, byte to) {
        byte width = (byte)(to - from);
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (byte)(Math.random() * (double)width % (double)width + (double)from);
        }
        return result;
    }

    public static void quickSort(int[] a, int start, int end, int[] p) {
        int len = end - start;
        if (len < 2) {
            return;
        }
        int startPlus1 = start + 1;
        if (len == 2) {
            if (a[start] > a[startPlus1]) {
                ArrayUtil.swap(a, start, startPlus1);
                if (p != null) {
                    ArrayUtil.swap(p, start, startPlus1);
                }
            }
            return;
        }
        if (len == 3) {
            int startPlus2;
            if (a[start] > a[startPlus1]) {
                ArrayUtil.swap(a, start, startPlus1);
                if (p != null) {
                    ArrayUtil.swap(p, start, startPlus1);
                }
            }
            if (a[startPlus1] > a[startPlus2 = start + 2]) {
                ArrayUtil.swap(a, startPlus1, startPlus2);
                if (p != null) {
                    ArrayUtil.swap(p, startPlus1, startPlus2);
                }
            }
            if (a[start] > a[startPlus1]) {
                ArrayUtil.swap(a, start, startPlus1);
                if (p != null) {
                    ArrayUtil.swap(p, start, startPlus1);
                }
            }
        }
        int pivot = a[0];
        int p_large = end - 1;
        for (int i = end - 1; i >= start; --i) {
            if (a[i] <= pivot) continue;
            ArrayUtil.swap(a, i, p_large);
            if (p != null) {
                ArrayUtil.swap(p, i, p_large);
            }
            --p_large;
        }
        ArrayUtil.swap(a, start, p_large);
        if (p != null) {
            ArrayUtil.swap(p, start, p_large);
        }
        ArrayUtil.quickSort(a, start, p_large, p);
        ArrayUtil.quickSort(a, p_large + 1, end, p);
    }

    public static int[] flatten5D(int[][][][][] is) {
        IntArrayList list = new IntArrayList(128);
        ArrayUtil.flatten5DL(is, list);
        return list.toArray();
    }

    public static int[] flatten4D(int[][][][] is) {
        IntArrayList list = new IntArrayList(128);
        ArrayUtil.flatten4DL(is, list);
        return list.toArray();
    }

    public static int[] flatten3D(int[][][] is) {
        IntArrayList list = new IntArrayList(128);
        ArrayUtil.flatten3DL(is, list);
        return list.toArray();
    }

    public static int[] flatten2D(int[][] is) {
        IntArrayList list = new IntArrayList(128);
        ArrayUtil.flatten2DL(is, list);
        return list.toArray();
    }

    private static void flatten5DL(int[][][][][] is, IntArrayList list) {
        for (int i = 0; i < is.length; ++i) {
            ArrayUtil.flatten4DL(is[i], list);
        }
    }

    private static void flatten4DL(int[][][][] is, IntArrayList list) {
        for (int i = 0; i < is.length; ++i) {
            ArrayUtil.flatten3DL(is[i], list);
        }
    }

    private static void flatten3DL(int[][][] is, IntArrayList list) {
        for (int i = 0; i < is.length; ++i) {
            ArrayUtil.flatten2DL(is[i], list);
        }
    }

    private static void flatten2DL(int[][] is, IntArrayList list) {
        for (int i = 0; i < is.length; ++i) {
            ArrayUtil.flatten1DL(is[i], list);
        }
    }

    private static void flatten1DL(int[] is, IntArrayList list) {
        for (int i = 0; i < is.length; ++i) {
            list.add(is[i]);
        }
    }

    public static void copy6D(int[][][][][][] to, int[][][][][][] from) {
        for (int i = 0; i < Math.min(to.length, from.length); ++i) {
            ArrayUtil.copy5D(to[i], from[i]);
        }
    }

    public static void copy5D(int[][][][][] to, int[][][][][] from) {
        for (int i = 0; i < Math.min(to.length, from.length); ++i) {
            ArrayUtil.copy4D(to[i], from[i]);
        }
    }

    public static void copy4D(int[][][][] to, int[][][][] from) {
        for (int i = 0; i < Math.min(to.length, from.length); ++i) {
            ArrayUtil.copy3D(to[i], from[i]);
        }
    }

    public static void copy3D(int[][][] to, int[][][] from) {
        for (int i = 0; i < Math.min(to.length, from.length); ++i) {
            ArrayUtil.copy2D(to[i], from[i]);
        }
    }

    public static void copy2D(int[][] to, int[][] from) {
        for (int i = 0; i < Math.min(to.length, from.length); ++i) {
            ArrayUtil.copy1D(to[i], from[i]);
        }
    }

    public static void copy1D(int[] to, int[] from) {
        for (int i = 0; i < Math.min(to.length, from.length); ++i) {
            to[i] = from[i];
        }
    }

    public static int fill6D(int[][][][][][] to, int[] from, int index) {
        for (int i = 0; i < to.length; ++i) {
            index = ArrayUtil.fill5D(to[i], from, index);
        }
        return index;
    }

    public static int fill5D(int[][][][][] to, int[] from, int index) {
        for (int i = 0; i < to.length; ++i) {
            index = ArrayUtil.fill4D(to[i], from, index);
        }
        return index;
    }

    public static int fill4D(int[][][][] to, int[] from, int index) {
        for (int i = 0; i < to.length; ++i) {
            index = ArrayUtil.fill3D(to[i], from, index);
        }
        return index;
    }

    public static int fill3D(int[][][] to, int[] from, int index) {
        for (int i = 0; i < to.length; ++i) {
            index = ArrayUtil.fill2D(to[i], from, index);
        }
        return index;
    }

    public static int fill2D(int[][] to, int[] from, int index) {
        for (int i = 0; i < to.length; ++i) {
            index = ArrayUtil.fill1D(to[i], from, index);
        }
        return index;
    }

    public static int fill1D(int[] to, int[] from, int index) {
        for (int i = 0; i < to.length; ++i) {
            to[i] = from[index++];
        }
        return index;
    }
}

